/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.composite;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyDefine;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.jface.viewers.TextCellEditor;

public class TimePropertyDefine
extends PropertyDefine
implements Serializable {
    public TimePropertyDefine() {
        this.m_cellEditor = new TextCellEditor();
    }

    public String getColumnText(Object value) {
        if (value instanceof Date) {
            SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
            return formatter.format((Date)value);
        }
        return "";
    }

    public Object getValue(Property element) {
        Object value = element.getValue();
        if (value instanceof Date) {
            SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
            return formatter.format((Date)value);
        }
        return "";
    }

    public void modify(Property element, Object value) {
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
        try {
            Date date = formatter.parse((String)value);
            element.setValue((Object)date);
            return;
        }
        catch (ParseException parseException) {
            formatter = new SimpleDateFormat("HH:mm");
            try {
                Date date = formatter.parse((String)value);
                element.setValue((Object)date);
            }
            catch (ParseException parseException2) {}
            return;
        }
    }

    public void initEditer() {
    }
}

