/*
 
 Copyright (C) 2008 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.snmptrap.factory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.MonitorConstant;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.monitor.run.bean.MonitorNumericValueInfo;
import com.clustercontrol.monitor.run.ejb.entity.MonitorInfoLocal;
import com.clustercontrol.monitor.run.ejb.entity.MonitorInfoPK;
import com.clustercontrol.monitor.run.ejb.entity.MonitorInfoUtil;
import com.clustercontrol.monitor.run.ejb.entity.MonitorNumericValueInfoLocal;
import com.clustercontrol.monitor.run.ejb.entity.MonitorNumericValueInfoUtil;
import com.clustercontrol.repository.bean.FacilityTreeAttributeConstant;
import com.clustercontrol.repository.ejb.session.RepositoryControllerBean;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import com.clustercontrol.snmptrap.bean.MonitorSnmpTrapInfo;
import com.clustercontrol.snmptrap.bean.MonitorSnmpTrapOidInfo;
import com.clustercontrol.snmptrap.bean.SnmpTrapFacilityInfo;
import com.clustercontrol.snmptrap.bean.SnmpTrapMasterInfo;
import com.clustercontrol.snmptrap.bean.SnmpTrapOidInfo;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapInfoLocal;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapInfoPK;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapInfoUtil;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMasterLocal;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMasterPK;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMasterUtil;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMibMasterData;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMibMasterLocal;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMibMasterPK;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMibMasterUtil;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapOidInfoLocal;
import com.clustercontrol.util.apllog.AplLogger;

/**
 * MIBマスター情報検索クラス
 *
 * @version 2.4.0
 * @since 2.4.0
 * @author Yosuke
 */
public class SelectMibMaster {
	
	protected static Log m_log = LogFactory.getLog( SelectMibMaster.class );
	
   /**
    * MIBマスターの詳細情報を取得します。
    * 
    * @param mib マスター情報がほしいMIB
    * @return　MIBマスターの詳細情報
    * @throws FinderException
    * @throws NamingException
    * @throws CreateException
    */
	public SnmpTrapMibMasterData getMibMasterData(String mib) throws FinderException, NamingException {
		
		SnmpTrapMibMasterData mibData = new SnmpTrapMibMasterData();
	
		try 
		{
			SnmpTrapMibMasterLocal mibMaster =  SnmpTrapMibMasterUtil.getLocalHome()
            .findByPrimaryKey(new SnmpTrapMibMasterPK(mib));

			mibData.setMib(mib);
			mibData.setOrderNo(mibMaster.getOrderNo());
			mibData.setRegDate(mibMaster.getRegDate());
			mibData.setUpdateDate(mibMaster.getUpdateDate());
			mibData.setRegUser(mibMaster.getRegUser());
			mibData.setUpdateUser(mibMaster.getUpdateUser());
			mibData.setDescription(mibMaster.getDescription());
			
	
		} catch (FinderException e) {
			AplLogger apllog = new AplLogger("TRAP", "trap");
			String[] args = null;
			apllog.put("SYS", "004", args);
			m_log.debug("getMibMasterData():" + e.getMessage());
			throw e;
		} catch (NamingException e) {
			AplLogger apllog = new AplLogger("TRAP", "trap");
			String[] args = null;
			apllog.put("SYS", "004", args);
			m_log.debug("getMibMasterData():" + e.getMessage());
			throw e;
		}
		
		return mibData;
	}
}
