package com.clustercontrol.snmptrap.ejb.entity;

import java.sql.Timestamp;
import java.util.Collection;

import javax.ejb.EntityBean;
import javax.ejb.FinderException;
import javax.naming.NamingException;

/**
 * SNMPトラップ監視設定情報を管理する　Entity Bean <BR>
 * 
 * @ejb.bean name="SnmpTrapInfo"
 *           jndi-name="SnmpTrapInfo"
 *           type="BMP"
 *           
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 *           
 * @ejb.dao class="com.clustercontrol.snmptrap.dao.SnmpTrapInfoDAO"
 * impl-class="com.clustercontrol.snmptrap.dao.SnmpTrapInfoDAOImpl"
 * 
 * @ejb.permission
 *     unchecked="true"
 *     
 */
public abstract class SnmpTrapInfoBean implements EntityBean {
	
	protected String monitorId;
	protected String description;
	protected String facilityId;
	protected String communityName;
	protected String notifyId;
	protected String application;
	protected Integer validFlg;
	protected String calendarId;
	protected Timestamp regDate;
	protected Timestamp updateDate;
	protected String regUser;
	protected String updateUser;
	protected int checkMode;
	
	/**
	 * @ejb.create-method 
	 */
	public SnmpTrapInfoPK ejbCreate(
			String monitorId, 
			String description, 
			String facilityId, 
			String communityName, 
			String notifyId, 
			String application, 
			Integer validFlg, 
			String calendarId, 
			Timestamp regDate, 
			Timestamp updateDate, 
			String regUser, 
			String updateUser,
			int checkMode) throws javax.ejb.CreateException {
		
		
		
		
		this.monitorId = monitorId;
		this.description = description;
		this.facilityId = facilityId;
		this.communityName = communityName;
		this.notifyId = notifyId;
		this.application = application;
		this.validFlg = validFlg;
		this.calendarId = calendarId;
		this.regDate = regDate;
		this.updateDate = updateDate;
		this.regUser = regUser;
		this.updateUser = updateUser;
		this.checkMode = checkMode;
		
		return null;
	}
	

	public Collection ejbFindAll() throws FinderException {
		return null;
	}
	
	public SnmpTrapInfoPK ejbFindByPrimaryKey(SnmpTrapInfoPK pk) throws FinderException {
		return null;
	}
	
	public Collection ejbFindByFacilityId(String facilityId) throws FinderException {
		return null;
	}
	
	/**
	 * @return the monitorId
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 */
	public String getMonitorId() {
		return monitorId;
	}
	
	/**
	 * @param java.lang.String the new monitorId value
	 * @ejb.interface-method
	 */
	public void setMonitorId(String monitorId) {
		this.monitorId = monitorId;
	}
	
	/**
	 * @return the description
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public String getDescription() {
		return description;
	}
	
	/**
	 * @param java.lang.String the new description value
	 * @ejb.interface-method
	 */
	public void setDescription(String description) {
		this.description = description;
	}
	
	/**
	 * @return the facilityId
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public String getFacilityId() {
		return facilityId;
	}
	
	/**
	 * @param java.lang.String the new facilityId value
	 * @ejb.interface-method
	 */
	public void setFacilityId(String facilityId) {
		this.facilityId = facilityId;
	}
	
	/**
	 * @return the communityName
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public String getCommunityName() {
		return communityName;
	}
	
	/**
	 * @param java.lang.String the new communityName value
	 * @ejb.interface-method
	 */
	public void setCommunityName(String communityName) {
		this.communityName = communityName;
	}
	
	/**
	 * @return the notifyId
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public String getNotifyId() {
		return notifyId;
	}
	
	/**
	 * @param java.lang.String the new notifyId value
	 * @ejb.interface-method
	 */
	public void setNotifyId(String notifyId) {
		this.notifyId = notifyId;
	}
	
	/**
	 * @return the application
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public String getApplication() {
		return application;
	}
	
	/**
	 * @param java.lang.String the new application value
	 * @ejb.interface-method
	 */
	public void setApplication(String application) {
		this.application = application;
	}
	
	/**
	 * @return the validFlg
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public Integer getValidFlg() {
		return validFlg;
	}
	
	/**
	 * @param java.lang.Integer the new validFlg value
	 * @ejb.interface-method
	 */
	public void setValidFlg(Integer validFlg) {
		this.validFlg = validFlg;
	}
	
	/**
	 * @return the calendarId
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public String getCalendarId() {
		return calendarId;
	}
	
	/**
	 * @param java.lang.String the new calendarId value
	 * @ejb.interface-method
	 */
	public void setCalendarId(String calendarId) {
		this.calendarId = calendarId;
	}
	
	/**
	 * @return the regDate
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public Timestamp getRegDate() {
		return regDate;
	}
	
	/**
	 * @param java.sql.Timestamp the new regDate value
	 * @ejb.interface-method
	 */
	public void setRegDate(Timestamp regDate) {
		this.regDate = regDate;
	}
	
	/**
	 * @return the updateDate
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public Timestamp getUpdateDate() {
		return updateDate;
	}
	
	/**
	 * @param java.sql.Timestamp the new updateDate value
	 * @ejb.interface-method
	 */
	public void setUpdateDate(Timestamp updateDate) {
		this.updateDate = updateDate;
	}
	
	/**
	 * @return the regUser
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public String getRegUser() {
		return regUser;
	}
	
	/**
	 * @param java.lang.String the new regUser value
	 * @ejb.interface-method
	 */
	public void setRegUser(String regUser) {
		this.regUser = regUser;
	}
	
	/**
	 * @return the updateUser
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public String getUpdateUser() {
		return updateUser;
	}
	
	/**
	 * @param java.lang.String the new updateUser value
	 * @ejb.interface-method
	 */
	public void setUpdateUser(String updateUser) {
		this.updateUser = updateUser;
	}
	
	// ==========================================
	//  CMR fields
	// ==========================================
	/**
	 * @ejb.interface-method view-type="local"
	 */
	public Collection getSnmpTrapOidInfo() throws FinderException, NamingException{
		Collection collection = null;
		try {
			collection = SnmpTrapOidInfoUtil.getLocalHome().findByMonitorId(getMonitorId());
		} catch (FinderException e) {
			throw e;
		} catch (NamingException e) {
			throw e;
		}
		return collection;
	}

	/**
	 * @return checkMode
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */

	public int getCheckMode() {
		return checkMode;
	}

	/**
	 * @param int checkMode
	 * @ejb.interface-method
	 */
	public void setCheckMode(int checkMode) {
		this.checkMode = checkMode;
	}
}
