/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.repository.util;

import java.io.File;
import java.io.FileInputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * SNMPでノードの情報を埋める際の定義情報のクラス<BR>
 *
 * @version 2.3.0
 * @since 2.1.2
 */
public class SearchNodeProperties {
   protected static Log m_log = LogFactory.getLog( SearchNodeProperties.class );

	private static SearchNodeProperties m_instance = null;
	private static Properties properties;
	
	private static final String DEFAULT_PORT="161";
	private static final String DEFAULT_COMMUNITY="public";
	private static final String DEFAULT_TIMEOUT="1000";
	private static final String DEFAULT_RETRY="1";
	private static final String DEFAULT_VERSION="1";//0:version 1  1:version 2c
	private static final String DEFAULT_ADDRESS="192.168.1.1";
 	private static final String DEFAULT_OID_NAME      =".1.3.6.1.2.1.1.5.0";
 	private static final String DEFAULT_OID_DESCR     =".1.3.6.1.2.1.1.1.0";
 	private static final String DEFAULT_OID_CONTACT   =".1.3.6.1.2.1.1.4.0";
 	private static final String DEFAULT_OID_DEV_NAME  =".1.3.6.1.2.1.25.3.2.1.3";
 	private static final String DEFAULT_OID_DEV_INDEX =".1.3.6.1.2.1.25.3.2.1.1";
 	private static final String DEFAULT_OID_DEV_TYPE  =".1.3.6.1.2.1.25.3.2.1.2";
 	private static final String DEFAULT_OID_DISK_INDEX=".1.3.6.1.4.1.2021.13.15.1.1.1";
 	private static final String DEFAULT_OID_DISK_NAME =".1.3.6.1.4.1.2021.13.15.1.1.2";
 	private static final String DEFAULT_OID_NIC_INDEX =".1.3.6.1.2.1.2.2.1.1";
 	private static final String DEFAULT_OID_NIC_NAME  =".1.3.6.1.2.1.2.2.1.2";
    private static final String DEFAULT_OID_FILESYSTEM_INDEX = ".1.3.6.1.2.1.25.2.3.1.1";
    private static final String DEFAULT_OID_FILESYSTEM_TYPE = ".1.3.6.1.2.1.25.2.3.1.2";
    private static final String DEFAULT_OID_FILESYSTEM_NAME  = ".1.3.6.1.2.1.25.2.3.1.3";
    	
	private static final String PORT_KEY          = "repository.snmp.port";
	private static final String COMMUNITY_KEY     = "repository.snmp.community";
	private static final String TIMEOUT_KEY       = "repository.snmp.timeout";
	private static final String RETRY_KEY         = "repository.snmp.retry";
	private static final String ADDRESS_KEY       = "repository.snmp.address";
	private static final String VERSION_KEY       = "repository.snmp.version";
	private static final String OID_NAME_KEY      = "repository.snmp.oid.name";
 	private static final String OID_DESCR_KEY     = "repository.snmp.oid.descr";
 	private static final String OID_CONTACT_KEY   = "repository.snmp.oid.contact";
 	private static final String OID_DEV_NAME_KEY  = "repository.snmp.oid.dev.name";
 	private static final String OID_DEV_INDEX_KEY = "repository.snmp.oid.dev.index";
 	private static final String OID_DEV_TYPE_KEY  = "repository.snmp.oid.dev.type";
 	private static final String OID_DISK_INDEX_KEY= "repository.snmp.oid.disk.index";
 	private static final String OID_DISK_NAME_KEY = "repository.snmp.oid.disk.name";
 	private static final String OID_NIC_INDEX_KEY = "repository.snmp.oid.nic.index";
 	private static final String OID_NIC_NAME_KEY  = "repository.snmp.oid.nic.name";
 	private static final String OID_FILESYSTEM_INDEX_KEY = "repository.snmp.oid.filesystem.index";
 	private static final String OID_FILESYSTEM_TYPE_KEY = "repository.snmp.oid.filesystem.type";
 	private static final String OID_FILESYSTEM_NAME_KEY  = "repository.snmp.oid.filesystem.name";
 	
	/**
	 * プロパティのデータセットをシングルトンで返します。
	 * @version 2.3.0
	 * @since 2.1.2
	 * 
	 * @return ConnectionManager ���ͥ������ޥ͡�����
	 */
	public static SearchNodeProperties getProperties() {
		if (m_instance==null) {
			m_instance = new SearchNodeProperties();
		}
		return m_instance;
	}

	/**
	 * コンストラクタ
	 * @version 2.1.2
	 * @since 2.1.2
	 */
	private SearchNodeProperties() {
		this.setValue();
	}
	
	/**
	 * SNMPポーリングに必要な設定値をプロパティファイルから読み込みます。
	 * 
	 * @version 2.0.0
	 * @since 2.0.0
	 */
	private void setValue() {
		
	     properties = new Properties();
		
		try {
			String homedir = System.getProperty("jboss.server.home.dir");
			String propertyFile = homedir + File.separator + "conf" + File.separator + "repository-search-node.properties";
			properties.load(new FileInputStream(propertyFile));
		} catch (Exception e) {
			m_log.error("setValue(): " + e.getMessage());
		}
	}
	
	public int getPort(){
		int ret = Integer.parseInt(properties.getProperty(PORT_KEY,DEFAULT_PORT));
		return ret;
	}
	public String getCommunity(){
	   
		return properties.getProperty(COMMUNITY_KEY,DEFAULT_COMMUNITY);
	}
	
	public int getTimeOut(){
		int ret = Integer.parseInt(properties.getProperty(TIMEOUT_KEY,DEFAULT_TIMEOUT));
		return ret;
	}
	 public int getRetry(){
		 int ret = Integer.parseInt(properties.getProperty(RETRY_KEY,DEFAULT_RETRY));
		 return ret;
	 }
	
	public int getVersion(){
		int ret = Integer.parseInt(properties.getProperty(VERSION_KEY,DEFAULT_VERSION));
		return ret;
	}
	
	
	public InetAddress getAddress(){
		InetAddress ipaddress = null;
		try {
			
			ipaddress = InetAddress.getByName(properties.getProperty(ADDRESS_KEY,DEFAULT_ADDRESS));
		} catch (UnknownHostException e) {
			
			//e.printStackTrace();
		}
		return ipaddress;
	}
	
	@SuppressWarnings("unchecked")
	public ArrayList getOidList(){
		ArrayList ret = new ArrayList();
		
		ret.add(properties.getProperty(OID_NAME_KEY,DEFAULT_OID_NAME));	
		ret.add(properties.getProperty(OID_DESCR_KEY,DEFAULT_OID_DESCR));		
		ret.add(properties.getProperty(OID_CONTACT_KEY,DEFAULT_OID_CONTACT));
		ret.add(properties.getProperty(OID_DEV_NAME_KEY,DEFAULT_OID_DEV_NAME));
		ret.add(properties.getProperty(OID_DEV_INDEX_KEY,DEFAULT_OID_DEV_INDEX));
		ret.add(properties.getProperty(OID_DEV_TYPE_KEY,DEFAULT_OID_DEV_TYPE));
		ret.add(properties.getProperty(OID_DISK_INDEX_KEY,DEFAULT_OID_DISK_INDEX));
		ret.add(properties.getProperty(OID_DISK_NAME_KEY,DEFAULT_OID_DISK_NAME));
		ret.add(properties.getProperty(OID_NIC_INDEX_KEY,DEFAULT_OID_NIC_INDEX));
		ret.add(properties.getProperty(OID_NIC_NAME_KEY,DEFAULT_OID_NIC_NAME));
		ret.add(properties.getProperty(OID_FILESYSTEM_INDEX_KEY,DEFAULT_OID_FILESYSTEM_INDEX ));
		ret.add(properties.getProperty(OID_FILESYSTEM_TYPE_KEY ,DEFAULT_OID_FILESYSTEM_TYPE));
		ret.add(properties.getProperty(OID_FILESYSTEM_NAME_KEY,DEFAULT_OID_FILESYSTEM_NAME));
		
		return ret;
		
	}
	 
}
