/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.repository.factory;

import java.util.ArrayList;
import java.util.Locale;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import com.clustercontrol.bean.DataRangeConstant;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyConstant;
import com.clustercontrol.repository.ejb.entity.FacilityLocal;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;


/**
 * スコープ用プロパティを作成するクラス<BR>
 *
 * @version 1.0.0
 * @since 1.0.0
 */
public class ScopeProperty {
	/** ファシリティID */
	public static final String FACILITY_ID = "facilityId";
	/** ファシリティ名 */
	public static final String FACILITY_NAME = "facilityName";
	/** 説明 */
	public static final String DESCRIPTION = "notes";
	
	

	/**
	 * スコープ用プロパティを返します。
	 * 
	 * @param facilityId
	 * @param mode
	 * @param locale
	 * @return スコープ用プロパティ
	 * @throws FinderException
	 * @throws NamingException
	 */
	public Property getProperty(String facilityId, int mode, Locale locale) throws FinderException, NamingException {
		Property property = getProperty(mode, locale);
		
		if(facilityId != null && facilityId.compareTo("") != 0){
		    
		    //Facility取得
			SelectFacility select = new SelectFacility();
			FacilityLocal facility = select.getFacility(facilityId);

			if(facility != null){
			    //ファシリティID
				ArrayList propertyList = PropertyUtil.getProperty(property, FACILITY_ID);
				((Property)propertyList.get(0)).setValue(facility.getFacilityId());
				//ファシリティ名
				propertyList = PropertyUtil.getProperty(property, FACILITY_NAME);
				((Property)propertyList.get(0)).setValue(facility.getCn());
				//説明
				propertyList = PropertyUtil.getProperty(property, DESCRIPTION);
				if(facility.getDescription() != null && facility.getDescription().compareTo("") != 0){
					((Property)propertyList.get(0)).setValue(facility.getDescription());
				}
				
			}
		}
		
		return property;
	}
	
	/**
	 * スコープ用プロパティを返します。
	 * 
	 * @param mode
	 * @return スコープ用プロパティ
	 */
	public Property getProperty(int mode, Locale locale) {
		//ファシリティID
		Property facilityId =
			new Property(FACILITY_ID, Messages.getString("facility.id"), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_64);
		//ファシリティ名
		Property facilityName =
			new Property(FACILITY_NAME, Messages.getString("facility.name"), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_256);
		//説明
		Property description =
			new Property(DESCRIPTION, Messages.getString("description"), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		
		//値を初期化
		facilityId.setValue("");
		facilityName.setValue("");
		description.setValue("");
		
		//モードにより、変更を可に設定
		if(mode == PropertyConstant.MODE_ADD){
			facilityId.setModify(PropertyConstant.MODIFY_OK);
			facilityName.setModify(PropertyConstant.MODIFY_OK);
			description.setModify(PropertyConstant.MODIFY_OK);
		}
		else if(mode == PropertyConstant.MODE_MODIFY){
			facilityName.setModify(PropertyConstant.MODIFY_OK);
			description.setModify(PropertyConstant.MODIFY_OK);
		}
		
		Property property = new Property(null, null, "");
		
		property.removeChildren();
		property.addChildren(facilityId);
		property.addChildren(facilityName);
		property.addChildren(description);
		
		return property;
	}
}
