/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.repository.factory;

import java.util.Locale;

import com.clustercontrol.bean.DataRangeConstant;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyConstant;
import com.clustercontrol.util.Messages;

/**
 * ノードフィルタ用プロパティを作成するクラス<BR>
 *
 * @version 1.0.0
 * @since 1.0.0
 */
public class NodeFilterProperty {
	/** ファシリティID */
	public static final String FACILITY_ID = "facilityId";
	/** ファシリティ名 */
	public static final String FACILITY_NAME = "facilityName";
	/** 説明 */
	public static final String DESCRIPTION = "description";
	/** IPアドレス */
	public static final String IP_ADDRESS = "ipAddress";
	/** OS名 */
	public static final String OS_NAME = "osName";
	/** OSリリース */
	public static final String OS_RELEASE = "osRelease";
	/** 管理者 */
	public static final String ADMINISTRATOR = "administrator";
	/** 連絡先 */
	public static final String CONTACT = "contact";
	
	/** ネットワーク */
	public static final String NETWORK = "network";
	/** OS */
	public static final String OS = "os";	
	/** 保守 */
	public static final String MAINTENANCE = "maintenance";
	
	/**
	 * ノードフィルタ用プロパティを返します。
	 * 
	 * @param locale
	 * @return ノードフィルタ用プロパティ
	 */
	public Property getProperty(Locale locale) {
		//ファシリティID
		Property facilityId =
			new Property(FACILITY_ID, Messages.getString("facility.id", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_64);
		//ファシリティ名
		Property facilityName =
			new Property(FACILITY_NAME, Messages.getString("facility.name", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_256);
		//説明
		Property description =
			new Property(DESCRIPTION, Messages.getString("description", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//IPアドレス
		Property ipAddress =
			new Property(IP_ADDRESS, Messages.getString("ip.address.v4", locale), PropertyConstant.EDITOR_IPV4);
		//OS名
		Property osName =
			new Property(OS_NAME, Messages.getString("os.name", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//OSリリース
		Property osRelease =
			new Property(OS_RELEASE, Messages.getString("os.release", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//管理者
		Property administrator =
			new Property(ADMINISTRATOR, Messages.getString("administrator", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//連絡先
		Property contact =
			new Property(CONTACT, Messages.getString("contact", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);

		//ネットワーク
		Property network = 
			new Property(NETWORK, Messages.getString("network", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//OS
		Property os = 
			new Property(OS, Messages.getString("os", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//保守
		Property maintenance =
			new Property(MAINTENANCE, Messages.getString("maintenance", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);

		//値を初期化
		facilityId.setValue("");
		facilityName.setValue("");
		description.setValue("");
		ipAddress.setValue("");
		osName.setValue("");
		osRelease.setValue("");
		administrator.setValue("");
		contact.setValue("");

		os.setValue("");
		network.setValue("");
		maintenance.setValue("");
		
		//変更の可/不可を設定
		facilityId.setModify(PropertyConstant.MODIFY_OK);
		facilityName.setModify(PropertyConstant.MODIFY_OK);
		description.setModify(PropertyConstant.MODIFY_OK);
		ipAddress.setModify(PropertyConstant.MODIFY_OK);
		osName.setModify(PropertyConstant.MODIFY_OK);
		osRelease.setModify(PropertyConstant.MODIFY_OK);
		administrator.setModify(PropertyConstant.MODIFY_OK);
		contact.setModify(PropertyConstant.MODIFY_OK);

		os.setModify(PropertyConstant.MODIFY_NG);
		network.setModify(PropertyConstant.MODIFY_NG);
		maintenance.setModify(PropertyConstant.MODIFY_NG);

		Property property = new Property(null, null, "");
		
		// 初期表示ツリーを構成。
		property.removeChildren();
		property.addChildren(facilityId);
		property.addChildren(facilityName);
		property.addChildren(description);
		property.addChildren(network);
		property.addChildren(os);
		property.addChildren(maintenance);
		
		// ネットワークツリー
		network.removeChildren();
		network.addChildren(ipAddress);

		// OSツリー
		os.removeChildren();
		os.addChildren(osName);
		os.addChildren(osRelease);
		
		// 保守ツリー
		maintenance.removeChildren();
		maintenance.addChildren(administrator);
		maintenance.addChildren(contact);
		
		return property;
	}
}
