/*
 
Copyright (C) 2007 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.ping.util;

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * プロセス監視プロパティ情報取得クラス
 *
 * @version 2.3.0 bata
 * @since 2.3.0
 * @author Yosuke Miyamoto 
 */
public class PingProperties {
    protected static Log m_log = LogFactory.getLog( PingProperties.class );

    private static final String FPING_ENABLE="true";
	private static final String FPING_COUNT= "1";
	private static final String FPING_INTERVAL= "1000";
	private static final String FPING_TIMEOUT="1000";
	private static final String FPING_PATH="/opt/hinemos/sbin/fping";
    
	private static final String FPING_ENABLE_KEY = "hinemos.fping.enable";
	private static final String FPING_COUNT_KEY = "hinemos.fping.count";
	private static final String FPING_INTERVAL_KEY="hinemos.fping.interval";
	private static final String FPING_TIMEOUT_KEY="hinemos.fping.timeout";
	private static final String FPING_PATH_KEY="hinemos.fping.path";
	
	private static PingProperties m_instance = null;
	
	/** Fpingを使用するか？　falseであれば2.2までのisReachableを利用 */
	private static boolean m_fpingEnable;
	/** fping利用時のデフォルトの　ping回数 */
	private static int m_fpingCount;
	/** fping利用時のデフォルトの　pingインターバル msec*/
	private static int m_fpingInterval;
	/** fping利用時のデフォルトの　pingタイムアウト msec*/
	private static int m_fpingTimeout;
	
	/** fping のパス **/
	private static String m_fpingPath;
	
	/**
	 * このオブジェクトを取得します。
	 * 
	 * 
	 * @version 2.0.0
	 * @since 2.0.0
	 * 
	 * @return ConnectionManager コネクションマネージャ
	 */
	public static PingProperties getProperties() {
		if (m_instance==null) {
			m_instance = new PingProperties();
		}
		return m_instance;
	}

	/**
	 * コンストラクタ
	 * 
	 * @version 2.0.0
	 * @since 2.0.0
	 */
	private PingProperties() {
		this.setValue();
	}
	
	/**m_fpingEnable
	 * プロセス監視情報をプロパティファイルから取得
	 * 
	 * @version 2.0.0
	 * @since 2.0.0
	 */
	private void setValue() {
		
	    Properties properties = new Properties();
		
		try {
			String homedir = System.getProperty("jboss.server.home.dir");
			String propertyFile = homedir + File.separator + "conf" + File.separator + "ping.properties";
			
			// プロパティファイルからキーと値のリストを読み込みます
			properties.load(new FileInputStream(propertyFile));
			
			String enable= properties.getProperty(FPING_ENABLE_KEY, FPING_ENABLE);
			String count = properties.getProperty(FPING_COUNT_KEY, FPING_COUNT);
			String interval = properties.getProperty(FPING_INTERVAL_KEY,FPING_INTERVAL);
			String timeout = properties.getProperty(FPING_TIMEOUT_KEY,FPING_TIMEOUT);
			m_fpingPath =  properties.getProperty(FPING_PATH_KEY,FPING_PATH);
			
			m_fpingEnable = new Boolean(enable).booleanValue();
			m_fpingCount = new Integer(count).intValue();
			m_fpingInterval = new Integer(interval).intValue();
			m_fpingTimeout = new Integer(timeout).intValue();
			
		} catch (Exception e) {
			m_log.error("setValue(): " + e.getMessage());
		}
	}

	public static int getM_fpingCount() {
		return m_fpingCount;
	}

	public static boolean isM_fpingEnable() {
		return m_fpingEnable;
	}

	public static int getM_fpingInterval() {
		return m_fpingInterval;
	}

	public static int getM_fpingTimeout() {
		return m_fpingTimeout;
	}

	public static String getM_fpingPath() {
		
		return m_fpingPath;
	}

}
