/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 */

package com.clustercontrol.performanceMGR.util.code;

import java.io.Serializable;


/**
 * 収集項目コードの情報を保持するクラス
 * 
 * @version 1.0
 * @since 1.0
 */
public class CollectorItemCodeInfo implements ICollectorItemInfo, Serializable {
    private String itemCode;
	private String categoryCode;
	private String parentCode;
	private String category;
    private String itemName;
    private String measure;
    private boolean deviceFlag;
    private String deviceType;
    private boolean rangeFixed;

    /**
     * コンストラクター
     * @param itemCode 収集項目コード
     * @param categoryCode カテゴリコード
     * @param parentCode 親の収集項目コード
     * @param category カテゴリ
     * @param itemName 収集項目名
     * @param measure 単位
     * @param deviceFlag デバイス別の収集項目か否かのフラグ
     * @param deviceType デバイスタイプ
     * @param rangeFixed グラフの縦軸のレンジが固定か否かのフラグ
     */
    public CollectorItemCodeInfo(
    		String itemCode,
    		String categoryCode,
    		String parentCode,
    		String category,
    		String itemName,
            String measure,
            boolean deviceFlag,
            String deviceType,
            boolean rangeFixed) {
        this.itemCode = itemCode;
        this.categoryCode = categoryCode;
        this.parentCode = parentCode;
        this.category = category;
        this.itemName = itemName;
        this.measure = measure;
        this.deviceFlag = deviceFlag;
        this.deviceType = deviceType;
        this.rangeFixed = rangeFixed;
    }

    /**
     * デバイス別収集か否かをチェックします。
     * @return デバイス別収集の場合はtrue
     */
    public boolean isDeviceFlag() {
        return deviceFlag;
    }

    /**
     * デバイス別収集であるか否かを設定します。
     * 
     * @param deviceFlag デバイス別収集の場合はtrue
     */
    public void setDeviceFlag(boolean deviceFlag) {
        this.deviceFlag = deviceFlag;
    }

    /**
     * 収集項目コードを取得します。
     * @return itemCode 収集項目コード
     */
    public String getItemCode() {
        return itemCode;
    }

    /**
     * 収集項目コードを設定します。
     * 
     * @param itemCode 収集項目コード
     */
    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    /**
     * 収集項目名を取得します。
     * 
     * @return itemName 収集項目名
     */
    public String getItemName() {
        return itemName;
    }

    /**
     * 収集項目名を設定します。
     * 
     * @param itemName 収集項目名
     */
    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    /**
     * 単位を取得します。
     * @return measure 単位
     */
    public String getMeasure() {
        return measure;
    }

    /**
     * 単位を設定します。
     * @param measure　単位
     */
    public void setMeasure(String measure) {
        this.measure = measure;
    }

    /**
     * グラフの縦軸のレンジが固定か否かを取得します。
     * @return rangeFixed 固定の場合はtrue
     */
    public boolean isRangeFixed() {
        return rangeFixed;
    }

    /**
     * グラフの縦軸のレンジが固定か否かを設定します。
     * @param rangeFixed 固定の場合はtrue
     */
    public void setRangeFixed(boolean rangeFixed) {
        this.rangeFixed = rangeFixed;
    }

    /**
     * 収集項目名を取得します。
     */
	public String getName() {
		return getItemName();
	}

	/**
 	 * 収集項目コードを取得します。
	 */
	public String getCode() {
		return getItemCode();
	}

	/**
	 * カテゴリ名を取得します。
	 * @return カテゴリ名
	 */
	public String getCategory() {
		return category;
	}

	/**
	 * カテゴリ名を設定します。
	 * @param category カテゴリ名
	 */
	public void setCategory(String category) {
		this.category = category;
	}

	/**
	 * カテゴリコードを設定します。
	 * @return カテゴリコード
	 */
	public String getCategoryCode() {
		return categoryCode;
	}

	/**
	 * カテゴリコードを取得します。
	 * @param categoryCode カテゴリコード
	 */
	public void setCategoryCode(String categoryCode) {
		this.categoryCode = categoryCode;
	}

	/**
	 * デバイス種別を取得します。
	 * @return デバイス種別
	 */
	public String getDeviceType() {
		return deviceType;
	}

	/**
	 * デバイス種別を設定します。
	 * @param deviceType デバイス種別
	 */
	public void setDeviceType(String deviceType) {
		this.deviceType = deviceType;
	}

	/**
	 * 親の収集項目コードを取得します。
	 * @return 親の収集項目コード
	 */
	public String getParentCode() {
		return parentCode;
	}

	/**
	 * 親の収集項目コードを設定します。
	 * @param parentCode 親の収集項目コード
	 */
	public void setParentCode(String parentCode) {
		this.parentCode = parentCode;
	}
}