/*

 Copyright (C) 2006 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 */

package com.clustercontrol.performanceMGR.monitor.ejb.entity;

import javax.ejb.EntityBean;

/**
 * リソース監視の設定情報を管理するEntity Bean <BR>
 * @ejb.bean name="MonitorPerfInfo"
 *           jndi-name="MonitorPerfInfo"
 *           type="CMP"
 *           schema="MonitorPerfInfo" 
 *           cmp-version="2.x"
 *           data-source="java:/HinemosDS"
 *           primkey-field="monitorTypeId","monitorId"
 *           
 *  @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 *  
 *  @ejb.permission
 *     unchecked="true"
 *     
 *  @ejb.persistence 
 *   table-name="cc_monitor_perf_info"  
 *           
 *  @ejb.finder 
 *    query="SELECT OBJECT(a) FROM MonitorPerfInfo as a"  
 *    signature="java.util.Collection findAll()"  
 *
 *  @ejb.pk class="com.clustercontrol.performanceMGR.monitor.ejb.entity.MonitorPerfInfoPK"
 *   
 */
public abstract class MonitorPerfInfoBean implements EntityBean {
	
	/**
	 *
	 * <!-- begin-user-doc -->
	 * The  ejbCreate method.
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.create-method 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public MonitorPerfInfoPK ejbCreate(
			String monitorTypeId,
			String monitorId, 
			String collectorId,
			String itemCode, 
			int deviceIndex,
			String deviceName
			) throws javax.ejb.CreateException {
		
		this.setMonitorTypeId(monitorTypeId);
		this.setMonitorId(monitorId);
		this.setCollectorId(collectorId);
		this.setItemCode(itemCode);
		this.setDeviceIndex(deviceIndex);
		this.setDeviceName(deviceName);
		
		return null;
	}
	
	/**
	 * コンストラクター
	 * @param monitorTypeId 監視種別ID
	 * @param monitorId 監視項目ID
	 * @param collectorId 収集項目ID
	 * @param itemCode 収集項目コード
	 * @param deviceIndex デバイスインデックス
	 * @param deviceName デバイス名
	 * @throws javax.ejb.CreateException
	 */
	public void ejbPostCreate(
			String monitorTypeId,
			String monitorId, 
			String collectorId,
			String itemCode, 
			int deviceIndex,
			String deviceName
			) throws javax.ejb.CreateException {
	}
	
	/**
	 * 収集項目IDを取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="collector_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return Returns the collectorId.
	 */
	public abstract String getCollectorId();

	/**
	 * 収集項目コードを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param command The collectorId to set.
	 */
	public abstract void setCollectorId(String collectorId);

	/**
	 * 収集項目コードを取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="item_code"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return Returns the item code.
	 */
	public abstract String getItemCode();

	/**
	 * 収集項目コードを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param itemCode The item code to set.
	 */
	public abstract void setItemCode(String itemCode);

	/**
	 * デバイスのインデックスを取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="device_index"
	 *     jdbc-type="INTEGER"
	 *     sql-type="INTEGER"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return Returns the device index.
	 */
	public abstract int getDeviceIndex();

	/**
	 * デバイスのインデックスを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param deviceIndex The device index to set.
	 */
	public abstract void setDeviceIndex(int deviceIndex);
	
	/**
	 * デバイス名を取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="device_name"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return Returns the device name.
	 */
	public abstract String getDeviceName();

	/**
	 * デバイス名を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param deviceName The device name to set.
	 */
	public abstract void setDeviceName(String deviceName);
	
	/**
	 * 監視項目IDを取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="monitor_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * @return Returns the monitorId.
	 */
	public abstract String getMonitorId();

	/**
	 * 監視項目IDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param monitorId The monitorId to set.
	 */
	public abstract void setMonitorId(String monitorId);
	
	/**
	 * 監視種別IDを取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="monitor_type_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * @return Returns the monitorTypeId.
	 */
	public abstract String getMonitorTypeId();

	/**
	 * 監視種別IDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param monitorTypeId The monitorTypeId to set.
	 */
	public abstract void setMonitorTypeId(String monitorTypeId);
}
