/*
                                                                                                                                                                 
Copyright (C) 2006 NTT DATA Corporation
                                                                                                                                                                 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
                                                                                                                                                                 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
                                                                                                                                                                 
*/

package com.clustercontrol.performanceMGR.bean;

import java.io.Serializable;

/**
 * 収集項目の設定情報を保持するDTOクラス<p>
 * 
 * 収集設定には、全般の情報、収集項目に関する情報、閾値監視に関する情報があり、
 * そのうち、収集項目に関する情報を保持また、クライアントマネージャ間でやり取りをする
 * ためのクラスです。
 * 
 * @version 1.0
 * @since 1.0
 */
public class CollectorItemInfo implements Serializable {
	private String	m_collectorID;
	private int	m_collectorItemID;
	private String	m_collectorItemCode;
	private int	m_deviceIndex;
	private String	m_deviceName;
	
	private boolean m_thresholdFlag;  // 未使用項目(いずれ削除)
	
	/**
	 * 指定された値を保持した CollectorItemInfo オブジェクトを生成します。
	 * 
	 * @param collectorID 収集ID
	 * @param collectorItemID 収集項目ID
	 * @param collectorItemCode 収集項目コード
	 * @param deviceIndex デバイスのインデックス
	 * @param deviceName デバイス名称
	 * @param thresholdFlag 閾値監視行うか否かのフラグ
	 */
	public CollectorItemInfo(
			final String collectorID, 
			final int collectorItemID, 
			final String collectorItemCode, 
			final int deviceIndex, 
			final String deviceName,
			final boolean thresholdFlag){
		m_collectorID = collectorID;
		m_collectorItemID = collectorItemID;
		m_collectorItemCode = collectorItemCode;
		m_deviceIndex = deviceIndex;
		m_deviceName = deviceName;
		m_thresholdFlag = thresholdFlag;
	}
	
	/**
	 * 指定された値を保持した CollectorItemInfo オブジェクトを生成します。
	 * 
	 * @param collectorID 収集ID
	 * @param collectorItemID 収集項目ID
	 * @param collectorItemCode 収集項目コード
	 * @param deviceIndex デバイスのインデックス
	 * @param deviceName デバイス名称
	 * @param thresholdFlag 閾値監視行うか否かのフラグ
	 */
	public CollectorItemInfo(
			final String collectorID, 
			final int collectorItemID, 
			final String collectorItemCode, 
			final int deviceIndex, 
			final String deviceName){
		m_collectorID = collectorID;
		m_collectorItemID = collectorItemID;
		m_collectorItemCode = collectorItemCode;
		m_deviceIndex = deviceIndex;
		m_deviceName = deviceName;
	}
	
	/**
	 * 収集ID を取得します。
	 * @return 収集ID
	 */
	public String getCollectorID() {
		return m_collectorID;
	}
	
	/**
	 * 収集項目コード を取得します。
	 * @return 収集項目コード
	 */
	public String getCollectorItemCode() {
		return m_collectorItemCode;
	}
	/**
	 * 収集項目ID を取得します。
	 * @return 収集項目ID
	 */
	public int getCollectorItemID() {
		return m_collectorItemID;
	}
	/**
	 * デバイスのインデックス を取得します。
	 * デバイスがシステム上何番目であるかの情報
	 * @return デバイスのインデックス
	 */
	public int getDeviceIndex() {
		return m_deviceIndex;
	}
	/**
	 * デバイス名称 を取得します。
	 * @return デバイス名称
	 */
	public String getDeviceName() {
		return m_deviceName;
	}
	/**
	 * 収集IDを設定します。
	 * @param collectorid 収集ID
	 */
	public void setCollectorID(String collectorid) {
		m_collectorID = collectorid;
	}
	/**
	 *収集項目コードを取得します。
	 * @param itemCode 
	 */
	public void setCollectorItemCode(String itemCode) {
		m_collectorItemCode = itemCode;
	}
	/**
	 * 収集項目IDを設定します。
	 * @param itemID 収集項目ID
	 */
	public void setCollectorItemID(int itemID) {
		m_collectorItemID = itemID;
	}
	/**
	 * デバイスのインデックスを設定します。
	 * @param index デバイスのインデックス
	 */
	public void setDeviceIndex(int index) {
		m_deviceIndex = index;
	}
	/**
	 * デバイス名称を設定します。
	 * @param name デバイス名称
	 */
	public void setDeviceName(String name) {
		m_deviceName = name;
	}
	
	/**
	 * 現在は使われていません。
	 * @param flag
	 */
	public void setThresholdFlag(boolean flag) {
		
	}
}
