/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 */

package com.clustercontrol.performance;

import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;

import com.clustercontrol.performance.util.Messages;

/**
 * 性能管理のパースペクティブを生成するクラス
 *  
 */
public class PerformancePerspective implements IPerspectiveFactory {

	/**
	 * 画面レイアウトを実装します。
	 * 
     * @see org.eclipse.ui.IPerspectiveFactory#createInitialLayout(org.eclipse.ui.IPageLayout)
	 */
    public void createInitialLayout(IPageLayout layout) {
        //エディタを非表示
        layout.setEditorAreaVisible(false);

        layout.addActionSet("com.clustercontrol.ActionSet");
        layout.addActionSet("com.clustercontrol.collectiverun.ActionSet");
        layout.addActionSet("com.clustercontrol.jobmanagement.ActionSet");
        layout.addActionSet("com.clustercontrol.monitor.ActionSet");
        layout.addActionSet("com.clustercontrol.repository.ActionSet");
        layout.addActionSet("com.clustercontrol.syslogng.ActionSet");
        layout.addActionSet("com.clustercontrol.accesscontrol.ActionSet");
        layout.addActionSet("com.clustercontrol.process.ActionSet");
        layout.addActionSet("com.clustercontrol.sql.ActionSet");
        layout.addActionSet("com.clustercontrol.ping.ActionSet");
        layout.addActionSet("com.clustercontrol.port.ActionSet");
        layout.addActionSet("com.clustercontrol.hinemosagent.ActionSet");
        layout.addActionSet("com.clustercontrol.snmp.ActionSet");
        layout.addActionSet("com.clustercontrol.priority.ActionSet");
        layout.addActionSet("com.clustercontrol.http.ActionSet");
        layout.addActionSet("com.clustercontrol.troubledetection.ActionSet");
        layout.addActionSet("com.clustercontrol.performance.ActionSet");
        layout.addActionSet("com.clustercontrol.snmptrap.ActionSet");
        layout.addActionSet("com.clustercontrol.maintenance.ActionSet");
        layout.addActionSet("com.clustercontrol.traputil.ActionSet");
        
        // エディタ領域のIDを取得
        String editorArea = layout.getEditorArea();
        // エディタ領域の下部５０％を占めるフォルダを作成
        IFolderLayout top = layout.createFolder("top",
                IPageLayout.TOP, (float) 0.5f, editorArea);
        // 既に他のフォルダによって縮小されたエディタ領域の
        // 左側３０％を占めるフォルダの作成
        IFolderLayout bottom = layout.createFolder("bottom",
                IPageLayout.BOTTOM, (float) 0.5f, editorArea);

        top.addView(Messages.getString("VIEW_REALTIME_GRAPH"));
        top.addView(Messages.getString("VIEW_RECORD_GRAPH"));

        bottom.addView(Messages.getString("VIEW_CURRENT_LIST"));
    }

}