/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.maintenance.factory;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;

import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;
import org.quartz.jobs.ee.ejb.EJBInvokerJob;

import com.clustercontrol.bean.Schedule;
import com.clustercontrol.maintenance.bean.QuartzConstant;
import com.clustercontrol.quartzmanager.ejb.session.QuartzManager;
import com.clustercontrol.quartzmanager.util.QuartzUtil;

/**
 * スケジュール一覧情報を検索するクラスです。
 *
 * @version 2.2.0
 * @since 2.2.0
 */
public class SelectSchedule {
    protected static Log m_log = LogFactory.getLog( SelectSchedule.class );
    
    public ArrayList getSchedule(String maintenanceId) throws NamingException, SchedulerException {
    	
//        Schedule schedule = null;
        ArrayList info = new ArrayList();
        
        //QuartzのSchedulerをルックアップ
		QuartzManager manager = QuartzUtil.getQuartzManager();
		
		try {
			
            JobDetail job = null;
			try {
				job = manager.getJobDetail(maintenanceId, QuartzConstant.GROUP_NAME);
			} catch (RemoteException e) {
				//TODO RemoteException 未実装
			}

//            ArrayList info = new ArrayList();
            //スケジュールIDを取得
            info.add(job.getName());
            //スケジュール名を取得
            info.add(job.getDescription());
            //ジョブIDを取得
            Object[] jdArgs = (Object[])job.getJobDataMap().get(EJBInvokerJob.EJB_ARGS_KEY);
            info.add((String)jdArgs[0]);
            //ジョブ名を取得
            String jobName = (String)job.getJobDataMap().get(QuartzConstant.JOB_NAME_KEY);
            info.add(jobName);
            //カレンダIDを取得
            if(jdArgs.length > 1){
            	info.add((String)jdArgs[1]);
            }
            else{
            	info.add("");
            }
            //スケジュール定義を取得
            Schedule schedule = (Schedule)job.getJobDataMap().get(QuartzConstant.SCHEDULE_KEY);
            info.add(schedule);
            //有効/無効を取得
            Integer valid = (Integer)job.getJobDataMap().get(QuartzConstant.VALID_KEY);
            info.add(valid);
            //登録者を取得
            String createUser = (String)job.getJobDataMap().get(QuartzConstant.CREATE_USER_KEY);
            info.add(createUser);
            //登録日時を取得
            Date createDate = (Date)job.getJobDataMap().get(QuartzConstant.CREATE_DATE_KEY);
            info.add(createDate);
            //更新者を取得
            String upadteUser = (String)job.getJobDataMap().get(QuartzConstant.UPDATE_USER_KEY);
            info.add(upadteUser);
            //更新日時を取得
            Date upadteDate = (Date)job.getJobDataMap().get(QuartzConstant.UPDATE_DATE_KEY);
            info.add(upadteDate);
            
//			JobDetail jobDetail = manager.getJobDetail(maintenanceId, QuartzConstant.GROUP_NAME);
//			JobDetail jobDetail = manager.getJobDetail("mainte003", "MAITENANCE");
//			m_log.info("debug : " + jobDetail.getFullName());
//			System.out.println(jobDetail.getFullName());
//			schedule = (Schedule)jobDetail.getJobDataMap().get(QuartzConstant.SCHEDULE_KEY);
//		} catch (RemoteException e1) {
//			// TODO 自動生成された catch ブロック
//			e1.printStackTrace();
		} catch (NamingException e1) {
			// TODO 自動生成された catch ブロック
			e1.printStackTrace();
		} catch (SchedulerException e1) {
			// TODO 自動生成された catch ブロック
			e1.printStackTrace();
		}
		
		return info;
    }
    
	/**
	 * スケジュール一覧情報を取得します。
	 * <p>
	 * <ol>
	 * <li>Quartzからスケジュール情報を取得します。</li>
	 * <li>取得したスケジュール情報の数、以下の処理を行います。</li>
	 *  <ol>
	 *  <li>セッションからセッションジョブを取得します。</li>
	 *  <li>セッションジョブからジョブ情報を取得します。</li>
	 *  <li>1スケジュール情報をテーブルのカラム順（{@link com.clustercontrol.jobmanagement.bean.ScheduleTableDefine}）に、リスト（{@link ArrayList}）にセットします。</li>
	 *   <dl>
	 *   <dt>スケジュール情報一覧（Objectの2次元配列）</dt>
	 *   <dd>{ スケジュール情報1 {カラム1の値, カラム2の値, … }, スケジュール情報2{カラム1の値, カラム2の値, …}, … }</dd>
	 *   </dl>
	 *  </ol>
	 * </ol>
	 * 
     * @return スケジュール一覧情報
     * @throws NamingException
     * @throws SchedulerException
     */
    @SuppressWarnings("unchecked")
	public ArrayList getScheduleList() throws NamingException, SchedulerException {
        m_log.debug("getScheduleList()");
        
        ArrayList list = new ArrayList();
        
        //QuartzのSchedulerをルックアップ
		QuartzManager manager = QuartzUtil.getQuartzManager();
		
        //ジョブ名リスト取得
        String[] jobs = null;
		try {
			jobs = manager.getJobs(QuartzConstant.GROUP_NAME);
		} catch (RemoteException e) {
			//TODO RemoteException 未実装
		}
        for(int i = 0; i < jobs.length; i++){
            //ジョブ(JobDetail)取得
            JobDetail job = null;
			try {
				job = manager.getJobDetail(jobs[i], QuartzConstant.GROUP_NAME);
			} catch (RemoteException e) {
				//TODO RemoteException 未実装
			}

            ArrayList info = new ArrayList();
            //スケジュールIDを取得
            info.add(job.getName());
            //スケジュール名を取得
            info.add(job.getDescription());
            //ジョブIDを取得
            Object[] jdArgs = (Object[])job.getJobDataMap().get(EJBInvokerJob.EJB_ARGS_KEY);
            info.add((String)jdArgs[0]);
            //ジョブ名を取得
            String jobName = (String)job.getJobDataMap().get(QuartzConstant.JOB_NAME_KEY);
            info.add(jobName);
            //カレンダIDを取得
            if(jdArgs.length > 1){
            	info.add((String)jdArgs[1]);
            }
            else{
            	info.add("");
            }
            //スケジュール定義を取得
            Schedule schedule = (Schedule)job.getJobDataMap().get(QuartzConstant.SCHEDULE_KEY);
            info.add(schedule);
            //有効/無効を取得
            Integer valid = (Integer)job.getJobDataMap().get(QuartzConstant.VALID_KEY);
            info.add(valid);
            //登録者を取得
            String createUser = (String)job.getJobDataMap().get(QuartzConstant.CREATE_USER_KEY);
            info.add(createUser);
            //登録日時を取得
            Date createDate = (Date)job.getJobDataMap().get(QuartzConstant.CREATE_DATE_KEY);
            info.add(createDate);
            //更新者を取得
            String upadteUser = (String)job.getJobDataMap().get(QuartzConstant.UPDATE_USER_KEY);
            info.add(upadteUser);
            //更新日時を取得
            Date upadteDate = (Date)job.getJobDataMap().get(QuartzConstant.UPDATE_DATE_KEY);
            info.add(upadteDate);

            
            list.add(info);
        }
	    return list;
    }
}
