/*
 
Copyright (C) 2007 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.maintenance.factory;

import java.sql.Timestamp;
import java.util.Date;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import com.clustercontrol.accesscontrol.factory.AccessLock;
import com.clustercontrol.maintenance.ejb.entity.MaintenanceInfoData;
import com.clustercontrol.maintenance.ejb.entity.MaintenanceInfoLocal;
import com.clustercontrol.maintenance.ejb.entity.MaintenanceInfoUtil;

/**
 * メンテナンス情報を変更するためのクラスです。
 * 
 * @version 2.2.0
 * @since 2.2.0
 *
 */
public class ModifyMaintenance {

	public boolean modifyMaintenance(MaintenanceInfoData data, String name) throws FinderException, NamingException {

		AccessLock.lock(AccessLock.MAINTENANCE);
		
		//メンテナンス情報を取得
		MaintenanceInfoLocal maintenanceInfo = MaintenanceInfoUtil
				.getLocalHome().findByPrimaryKey(data.getMaintenance_id());
		
		//メンテナンス情報を更新
		if (maintenanceInfo != null) {
			maintenanceInfo.setDescription(data.getDescription());
			maintenanceInfo.setType_id(data.getType_id());
			maintenanceInfo.setKeep_id(data.getKeep_id());
			maintenanceInfo.setCalendar_id(data.getCalendar_id());
//			maintenanceInfo.setSchedule_date(data.getSchedule_date());
			maintenanceInfo.setSchedule_date(null);
			maintenanceInfo.setNotify_id(data.getNotify_id());
			maintenanceInfo.setApplication(data.getApplication());
			maintenanceInfo.setValid_flg(data.getValid_flg());
			maintenanceInfo.setRegUser(data.getRegUser());
			maintenanceInfo.setRegDate(data.getRegDate());
			maintenanceInfo.setUpdateUser(name);
			maintenanceInfo.setUpdateDate(new Timestamp(new Date().getTime()));
		}
			
	
		return true;
	}

}
