/*
 
Copyright (C) 2007 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.maintenance.factory;

import java.sql.Timestamp;
import java.util.Date;

import javax.ejb.CreateException;
import javax.naming.NamingException;

import com.clustercontrol.accesscontrol.factory.AccessLock;
import com.clustercontrol.maintenance.ejb.entity.MaintenanceInfoData;
import com.clustercontrol.maintenance.ejb.entity.MaintenanceInfoUtil;

/**
 * メンテナンス情報を登録するためのクラスです。
 * 
 * @version 2.2.0
 * @since 2.2.0
 *
 */
public class AddMaintenance {
	
	public boolean addMaintenance(MaintenanceInfoData data, String name) throws CreateException, NamingException {
		
		AccessLock.lock(AccessLock.MAINTENANCE);
		
		//エンティティBeanをつくる
		MaintenanceInfoUtil.getLocalHome().create(
				data.getMaintenance_id(),
				data.getDescription(),
				data.getType_id(),
				data.getKeep_id(),
				data.getCalendar_id(),
//				data.getSchedule_date(),
				null,
				data.getNotify_id(),
				data.getApplication(),
				data.getValid_flg(),
				name,
				new Timestamp(new Date().getTime()),
				name,
				new Timestamp(new Date().getTime()));
		
		return true;
		
	}
	
}
