/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.notify.bean;

import com.clustercontrol.bean.EventConfirmConstant;

/**
 * 通知イベント情報を保持するクラス<BR>
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class NotifyEventInfo
implements java.io.Serializable
{
	private static final long serialVersionUID = -5089086735470199399L;
	
	/** 通知ID。 */
	private String m_notifyId;
	
	/** 
	 * 重要度。
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	private Integer m_priority;
	
	/** 
	 * イベント通知フラグ。
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	private Integer m_eventNormalFlg;
	
	/** 
	 * イベント通知状態。
	 * @see com.clustercontrol.bean.EventConfirmConstant
	 */
	private Integer m_eventNormalState = new Integer(EventConfirmConstant.TYPE_UNCONFIRMED);
	
	/** 
	 * イベント抑制フラグ。
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	private Integer m_eventInhibitionFlg;
	
	/** 
	 * イベント抑制状態。
	 * @see com.clustercontrol.bean.EventConfirmConstant
	 */
	private Integer m_eventInhibitionState = new Integer(EventConfirmConstant.TYPE_CONFIRMED);
	
	/** 
	 * メールフラグ。
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	private Integer m_mailFlg;
	
	/** メールアドレス（セミコロン区切り）。 */
	private String m_mailAddress;
	
	
	/**
	 * コンストラクタ。
	 */
	public NotifyEventInfo() {
	}
	
	/**
	 * コンストラクタ。
	 * 
	 * @param notifyId 通知ID
	 * @param priority 重要度
	 * @param eventNormalFlg イベント通知フラグ
	 * @param eventNormalState イベント通知状態
	 * @param eventInhibitionFlg イベント抑制フラグ
	 * @param eventInhibitionState イベント抑制状態
	 * @param mailFlg メールフラグ
	 * @param mailAddress メールアドレス（セミコロン区切り）
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 * @see com.clustercontrol.bean.ValidConstant
	 * @see com.clustercontrol.bean.EventConfirmConstant
	 */
	public NotifyEventInfo(
			String notifyId,
			Integer priority,
			Integer eventNormalFlg,
			Integer eventNormalState,
			Integer eventInhibitionFlg,
			Integer eventInhibitionState,
			Integer mailFlg,
			String mailAddress ) {
		
		setNotifyId(notifyId);
		setPriority(priority);
		setEventNormalFlg(eventNormalFlg);
		setEventNormalState(eventNormalState);
		setEventInhibitionFlg(eventInhibitionFlg);
		setEventInhibitionState(eventInhibitionState);
		setMailFlg(mailFlg);
		setMailAddress(mailAddress);
	}
	
	/**
	 * コンストラクタ。
	 * 
	 * @param otherData コピー元の通知情報
	 */
	public NotifyEventInfo( NotifyEventInfo otherData ) {
		setNotifyId(otherData.getNotifyId());
		setPriority(otherData.getPriority());
		setEventNormalFlg(otherData.getEventNormalFlg());
		setEventNormalState(otherData.getEventNormalState());
		setEventInhibitionFlg(otherData.getEventInhibitionFlg());
		setEventInhibitionState(otherData.getEventInhibitionState());
		setMailFlg(otherData.getMailFlg());
		setMailAddress(otherData.getMailAddress());
		
	}
	
	/**
	 * 通知IDを返します。
	 * 
	 * @return 通知ID
	 */
	public String getNotifyId() {
		return this.m_notifyId;
	}
	
	/**
	 * 通知IDを設定します。
	 * 
	 * @param notifyId 通知ID
	 */
	public void setNotifyId( String notifyId ) {
		this.m_notifyId = notifyId;
	}
	
	/**
	 * 重要度を返します。
	 * 
	 * @return 重要度
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public Integer getPriority() {
		return this.m_priority;
	}
	
	/**
	 * 重要度を設定します。
	 * 
	 * @param priority 重要度
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public void setPriority( Integer priority ) {
		this.m_priority = priority;
	}
	
	/**
	 * イベント通知フラグを返します。
	 * 
	 * @return イベント通知フラグ
	 * 
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	public Integer getEventNormalFlg()  {
		return this.m_eventNormalFlg;
	}
	
	/**
	 * イベント通知フラグを設定します。
	 * 
	 * @param eventNormalFlg イベント通知フラグ
	 * 
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	public void setEventNormalFlg( Integer eventNormalFlg ) {
		this.m_eventNormalFlg = eventNormalFlg;
	}
	
	/**
	 * イベント通知状態を返します。
	 * 
	 * @return イベント通知状態
	 * 
	 * @see com.clustercontrol.bean.EventConfirmConstant
	 */
	public Integer getEventNormalState() {
		return this.m_eventNormalState;
	}
	
	/**
	 * イベント通知状態を設定します。
	 * 
	 * @param eventNormalState イベント通知状態
	 * 
	 * @see com.clustercontrol.bean.EventConfirmConstant
	 */
	public void setEventNormalState( Integer eventNormalState )  {
		this.m_eventNormalState = eventNormalState;
	}
	
	/**
	 * イベント抑制フラグを返します。
	 * 
	 * @return イベント抑制フラグ
	 * 
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	public Integer getEventInhibitionFlg() {
		return this.m_eventInhibitionFlg;
	}
	
	/**
	 * イベント抑制フラグを設定します。
	 * 
	 * @param eventInhibitionFlg イベント抑制フラグ
	 * 
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	public void setEventInhibitionFlg( Integer eventInhibitionFlg ) {
		this.m_eventInhibitionFlg = eventInhibitionFlg;
	}
	
	/**
	 * イベント抑制状態を返します。
	 * 
	 * @return イベント抑制状態
	 * 
	 * @see com.clustercontrol.bean.EventConfirmConstant
	 */
	public Integer getEventInhibitionState() {
		return this.m_eventInhibitionState;
	}
	
	/**
	 * イベント抑制状態を設定します。
	 * 
	 * @param eventInhibitionState イベント抑制状態
	 * 
	 * @see com.clustercontrol.bean.EventConfirmConstant
	 */
	public void setEventInhibitionState( Integer eventInhibitionState ) {
		this.m_eventInhibitionState = eventInhibitionState;
	}
	
	/**
	 * メールフラグを返します。
	 * 
	 * @return メールフラグ
	 * 
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	public Integer getMailFlg() {
		return this.m_mailFlg;
	}
	
	/**
	 * メールフラグを設定します。
	 * 
	 * @param mailFlg メールフラグ
	 * 
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	public void setMailFlg( Integer mailFlg ) {
		this.m_mailFlg = mailFlg;
	}
	
	/**
	 * メールアドレスを返します。
	 * 
	 * @return メールアドレス（セミコロン区切り）
	 */
	public String getMailAddress() {
		return this.m_mailAddress;
	}
	
	/**
	 * メールアドレスを設定します。
	 * 
	 * @param mailAddress メールアドレス（セミコロン区切り）
	 */
	public void setMailAddress( String mailAddress ) {
		this.m_mailAddress = mailAddress;
	}
}
