/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.snmptrap.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.ArrayList;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.snmptrap.bean.MonitorSnmpTrapInfo;
import com.clustercontrol.snmptrap.ejb.session.MonitorSnmpTrapController;
import com.clustercontrol.snmptrap.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;

/**
 * SNMPTRAP監視設定を取得するクライアント側アクションクラス<BR>
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class GetSnmpTrap {

    /**
     * SNMPTRAP監視情報を取得します。<BR>
     * 
     * @param monitorId 監視項目ID
     * @return SNMPTRAP監視情報
     */
    public MonitorSnmpTrapInfo getSnmp(String monitorId) {

    	MonitorSnmpTrapController snmpTrap = 
    		EjbConnectionManager.getConnectionManager().getSnmpTrapController();

    	MonitorSnmpTrapInfo info = null;
        try {
        	info = snmpTrap.getMonitorInfo(monitorId);
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
        } catch (CreateException e) {
        } catch (FinderException e) {
        } catch (NamingException e) {
        }
        return info;
    }
    
    /**
     * SNMPTRAP監視一覧を返します。
     * 
     * @return SNMPTRAP監視一覧
     */
    public ArrayList getSnmpTrapList() {

    	MonitorSnmpTrapController snmpTrap = 
    		EjbConnectionManager.getConnectionManager().getSnmpTrapController();

        ArrayList records = null;
        try {
            records = snmpTrap.getMonitorList();
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
        } catch (CreateException e) {
        } catch (FinderException e) {
        } catch (NamingException e) {
        }
        return records;
    }
}