/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.repository.factory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.accesscontrol.factory.AccessLock;
import com.clustercontrol.bean.FacilityConstant;
import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.SnmpVersionConstant;
import com.clustercontrol.repository.bean.FacilityAttributeConstant;
import com.clustercontrol.repository.bean.FacilityTreeAttributeConstant;
import com.clustercontrol.repository.bean.TopicConstant;
import com.clustercontrol.repository.dao.FacilityDAOImpl;
import com.clustercontrol.repository.dao.FacilityTreeDAOImpl;
import com.clustercontrol.repository.ejb.entity.DeviceInfoLocal;
import com.clustercontrol.repository.ejb.entity.DeviceInfoUtil;
import com.clustercontrol.repository.ejb.entity.FacilityLocal;
import com.clustercontrol.repository.ejb.entity.FacilityTreeLocal;
import com.clustercontrol.repository.ejb.entity.FacilityTreeUtil;
import com.clustercontrol.repository.ejb.entity.FacilityUtil;
import com.clustercontrol.repository.ejb.entity.FileSystemInfoLocal;
import com.clustercontrol.repository.ejb.entity.FileSystemInfoUtil;
import com.clustercontrol.repository.message.UpdateRepositoryInfo;
import com.clustercontrol.repository.util.SendTopic;
import com.clustercontrol.util.PropertyUtil;
import com.clustercontrol.util.apllog.AplLogger;

/**
 * ファシリティを更新するクラス<BR>
 *
 * @version 1.0.0
 * @since 1.0.0
 */
public class ModifyFacility {
	protected static Log m_log = LogFactory.getLog(ModifyFacility.class);
	
	//デフォルトのソート順位は100とする。
	public static int DEFAULT_SORT_ORDER = 100;
	
	/**
	 * スコープ追加
	 * 
	 * @param parentFacilityId
	 * @param property
	 * @throws RemoveException
	 * @throws CreateException
	 * @throws NamingException
	 */
	public void addScope(String parentFacilityId, Property property) throws RemoveException, CreateException, NamingException {
    	//アクセスロック
    	AccessLock.lock(AccessLock.REPOSITORY);
		
		//ファシリティID取得
		ArrayList facilityId = PropertyUtil.getPropertyValue(property, ScopeProperty.FACILITY_ID);
		//ファシリティ名取得
		ArrayList facilityName = PropertyUtil.getPropertyValue(property, ScopeProperty.FACILITY_NAME);
		//説明取得
		ArrayList description = PropertyUtil.getPropertyValue(property, ScopeProperty.DESCRIPTION);
		
	
		//Facilityを作成
		FacilityLocal facility;
		try {
			facility = FacilityUtil.getLocalHome().create(
					(String)facilityId.get(0), 
					(String)facilityName.get(0), 
					FacilityConstant.TYPE_SCOPE
					);
					
			//Facilityに説明を設定
			facility.setDescription(checkString(description.get(0)));

		} catch (EJBException e) {
            AplLogger apllog = new AplLogger("REP", "rep");
            String[] args = {(String)facilityId.get(0)};
            apllog.put("SYS", "012", args);
            
            m_log.debug("addScope() : " + e.getMessage());
			throw e;
		}
		
		try {
			//FacilityTreeを作成
			//FIXME　ソートの順番はとりあえずオンコードで100とする。
			FacilityTreeLocal facilityTree = FacilityTreeUtil.getLocalHome().create(
					(String)facilityId.get(0), 
					FacilityConstant.TYPE_SCOPE, 
					parentFacilityId,
					new Integer(DEFAULT_SORT_ORDER), 
					new Boolean(false)
					);
			
			
		} catch (EJBException e) {
            AplLogger apllog = new AplLogger("REP", "rep");
            String[] args = {(String)facilityId.get(0)};
            apllog.put("SYS", "012", args);
            
			try {
				//Facilityを削除
				facility.remove();
			} catch (EJBException e1) {
			    m_log.debug("addScope() : " + e.getMessage());
				throw e1;
			}
			m_log.debug("addScope() : " + e.getMessage());
			throw e;
		}
		
		try {
			//Topicに送信
			SendTopic send = new SendTopic(TopicConstant.TOPIC_NAME_EXECUTE);
			send.put(new UpdateRepositoryInfo());
		} catch (Exception e) {
			m_log.debug("addScope() : 更新情報送信エラー : " + e.getMessage());
		}
	}
	
	/**
	 * スコープ変更
	 * 
	 * @param property
	 * @throws NamingException
	 * @throws FinderException
	 */
	public void modifyScope(Property property) throws NamingException, FinderException  {
    	//アクセスロック
    	AccessLock.lock(AccessLock.REPOSITORY);
    	
    	ArrayList facilityId = null;
	    try {
			//ファシリティID取得
			facilityId = PropertyUtil.getPropertyValue(property, ScopeProperty.FACILITY_ID);
			//ファシリティ名取得
			ArrayList facilityName = PropertyUtil.getPropertyValue(property, ScopeProperty.FACILITY_NAME);
			//説明取得
			ArrayList description = PropertyUtil.getPropertyValue(property, ScopeProperty.DESCRIPTION);
			
			//Facilityを取得
			FacilityLocal facility = FacilityUtil.getLocalHome().findByFacilityId(
					(String)facilityId.get(0));
			
			//ファシリティ名設定
			facility.setCn(checkString(facilityName.get(0)));
			//説明設定
			facility.setDescription(checkString(description.get(0)));
			
			try {
				//Topicに送信
				SendTopic send = new SendTopic(TopicConstant.TOPIC_NAME_EXECUTE);
				send.put(new UpdateRepositoryInfo());
			} catch (Exception e) {
				m_log.debug("addScope() : 更新情報送信エラー : " + e.getMessage());
			}
		} catch (EJBException e) {
            AplLogger apllog = new AplLogger("REP", "rep");
            String[] args = {(String)facilityId.get(0)};
            apllog.put("SYS", "014", args);
            
            m_log.debug("modifyScope() : " + e.getMessage());
			throw e;
		} catch (FinderException e) {
            AplLogger apllog = new AplLogger("REP", "rep");
            String[] args = {(String)facilityId.get(0)};
            apllog.put("SYS", "014", args);
            
            m_log.debug("modifyScope() : " + e.getMessage());
			throw e;
		}
	}
	
	/**
	 * スコープへのノード割当て
	 * 
	 * @param parentFacilityId
	 * @param facilityIds
	 * @throws NamingException
	 * @throws CreateException
	 */
	public void assignNodeScope(String parentFacilityId, String[] facilityIds) throws NamingException, CreateException, FinderException {
    	//アクセスロック
    	AccessLock.lock(AccessLock.REPOSITORY);
    	
    	String facilityId = null;
	    try {
		    //親ファシリティIDにFacilityTree(ノード)を作成する
			for(int i = 0; i < facilityIds.length; i++){
			    facilityId = facilityIds[i];
			    //FIXME　ソートの順番はとりあえずオンコードで100+100とする。
			    //ソート順でスコープよりも後にするため
			    
			    FacilityLocal facility = FacilityUtil.getLocalHome().findByFacilityId(facilityId);
			    Boolean valid = facility.getValid();
			    FacilityTreeLocal facilityTree = 
			        FacilityTreeUtil.getLocalHome().create(
			                facilityId, 
			                FacilityConstant.TYPE_NODE, 
			                parentFacilityId, 
			                new Integer(DEFAULT_SORT_ORDER+100), 
			                valid);
			}
			
			try {
				//Topicに送信
				SendTopic send = new SendTopic(TopicConstant.TOPIC_NAME_EXECUTE);
				send.put(new UpdateRepositoryInfo());
			} catch (Exception e) {
				m_log.debug("addScope() : 更新情報送信エラー : " + e.getMessage());
			}
		} catch (EJBException e) {
            AplLogger apllog = new AplLogger("REP", "rep");
            String[] args = {facilityId, parentFacilityId};
            apllog.put("SYS", "015", args);
            
            m_log.debug("assignNodeScope() : " + e.getMessage());
			throw e;
			
		} catch (FinderException e) {
            AplLogger apllog = new AplLogger("REP", "rep");
            String[] args = {facilityId, parentFacilityId};
            apllog.put("SYS", "015", args);
            
            m_log.debug("assignNodeScope() : " + e.getMessage());
            throw e;
		}
	}
		
	
	/**
	 * ノード追加
	 * 
	 * @param property
	 * @param user
	 * @throws NamingException
	 * @throws CreateException
	 */
	public void addNode(Property property, String user) throws NamingException, CreateException  {
    	//アクセスロック
    	AccessLock.lock(AccessLock.REPOSITORY);
		
		String facilityId = null;
	    try {
			ArrayList values = null;
			//現在日時を取得
			Date now = new Date();
			
			//ファシリティID取得
			values = PropertyUtil.getPropertyValue(property, NodeProperty.FACILITY_ID);
			facilityId = (String)values.get(0);
			//ファシリティ名取得
			values = PropertyUtil.getPropertyValue(property, NodeProperty.FACILITY_NAME);
			String facilityName = (String)values.get(0);
			
			//Facilityを作成
			FacilityLocal facility = FacilityUtil.getLocalHome().create(
					facilityId, 
					facilityName, 
					FacilityConstant.TYPE_NODE);
			
//			//エージェント制御を取得し、Facilityに設定
//			values = PropertyUtil.getPropertyValue(property, NodeProperty.AGENT_CONTROL);
//			facility.setAgentControl((Boolean)values.get(0));
//			//エージェント監視を取得し、Facilityに設定
//			values = PropertyUtil.getPropertyValue(property, NodeProperty.AGENT_MONITOR);
//			facility.setAgentWatch((Boolean)values.get(0));
//			//エージェント監視ステータスを取得し、Facilityに設定
//			values = PropertyUtil.getPropertyValue(property, NodeProperty.AGENT_MONITOR_STATUS);
//			facility.setAgentWatchStatus((Boolean)values.get(0));
			//文字セットを取得し、Facilityに設定
			values = PropertyUtil.getPropertyValue(property, NodeProperty.CHARACTER_SET);
			facility.setCharSet(checkString(values.get(0)));
			//登録日時を取得し、Facilityに設定
			facility.setCreateTimestamp(now);
			//登録者を取得し、Facilityに設定
			facility.setCreatorsName(user);
			//説明を取得し、Facilityに設定
			values = PropertyUtil.getPropertyValue(property, NodeProperty.DESCRIPTION);
			facility.setDescription(checkString(values.get(0)));
			//有効/無効を取得し、Facilityに設定
			values = PropertyUtil.getPropertyValue(property, NodeProperty.VALID);
			facility.setValid((Boolean)values.get(0));
			//DHCPクライアントを取得し、Facilityに設定
			values = PropertyUtil.getPropertyValue(property, NodeProperty.DHCP_CLIENT);
			facility.setDhcpClient((Boolean)values.get(0));
			//ホスト名を取得し、Facilityに設定
			values = PropertyUtil.getPropertyValue(property, NodeProperty.HOST_NAME);
			facility.setHost(checkArrayList(values));
			//IPアドレスV4を取得し、Facilityに設定
			values = PropertyUtil.getPropertyValue(property, NodeProperty.IP_ADDRESS_V4);
			facility.setIpNetworkNumber(checkString(values.get(0)));
			//IPアドレスV6を取得し、Facilityに設定
			values = PropertyUtil.getPropertyValue(property, NodeProperty.IP_ADDRESS_V6);
			facility.setIpNetworkNumberV6(checkString(values.get(0)));
			//IPバージョンを取得し、Facilityに設定
			values = PropertyUtil.getPropertyValue(property, NodeProperty.IP_ADDRESS_VERSION);
			facility.setIpProtocolNumber(checkInteger(values.get(0)));
			//IPタイプを取得し、Facilityに設定
			values = PropertyUtil.getPropertyValue(property, NodeProperty.IP_ADDRESS_TYPE);
			facility.setIpType(checkInteger(values.get(0)));
//			//イベント監視を取得し、Facilityに設定
//			values = PropertyUtil.getPropertyValue(property, NodeProperty.EVENT_MONITOR);
//			facility.setLogWatch((Boolean)values.get(0));
			//H/Wタイプを取得し、Facilityに設定
			values = PropertyUtil.getPropertyValue(property, NodeProperty.HARDWARE_TYPE);
			facility.setMachine(checkString(values.get(0)));
			//管理者を取得し、Facilityに設定
			values = PropertyUtil.getPropertyValue(property, NodeProperty.ADMINISTRATOR);
			facility.setManagerName(checkString(values.get(0)));
			//連絡先を取得し、Facilityに設定
			values = PropertyUtil.getPropertyValue(property, NodeProperty.CONTACT);
			facility.setManagerContact(checkString(values.get(0)));
			//更新者を取得し、Facilityに設定
			facility.setModifiersName(user);
			//更新日時を取得し、Facilityに設定
			facility.setModifyTimestamp(now);
			//ノード名を取得し、Facilityに設定
			values = PropertyUtil.getPropertyValue(property, NodeProperty.NODE_NAME);
			facility.setNodeName(checkString(values.get(0)));
			//OS名を取得し、Facilityに設定
			values = PropertyUtil.getPropertyValue(property, NodeProperty.OS_NAME);
			facility.setOsName(checkString(values.get(0)));
			//OSリリースを取得し、Facilityに設定
			values = PropertyUtil.getPropertyValue(property, NodeProperty.OS_RELEASE);
			facility.setOsRelease(checkString(values.get(0)));
			//OSバージョンを取得し、Facilityに設定
			values = PropertyUtil.getPropertyValue(property, NodeProperty.OS_VERSION);
			facility.setOsVersion(checkString(values.get(0)));
//			//PING監視を取得し、Facilityに設定
//			values = PropertyUtil.getPropertyValue(property, NodeProperty.PING_MONITOR);
//			facility.setPingWatch((Boolean)values.get(0));
			//プラットフォームを取得し、Facilityに設定
			values = PropertyUtil.getPropertyValue(property, NodeProperty.PLATFORM_FAMILY_NAME);
			facility.setPlatform(checkString(values.get(0)));
//			//ステータス監視を取得し、Facilityに設定
//			values = PropertyUtil.getPropertyValue(property, NodeProperty.STATUS_MONITOR);
//			facility.setStatusWatch((Boolean)values.get(0));

			//ポート番号を取得し、Facilityに設定
			values = PropertyUtil.getPropertyValue(property, NodeProperty.SNMP_PORT);
			facility.setSnmpPort(checkInteger(values.get(0)));
			//コミュニティ名を取得し、Facilityに設定
			values = PropertyUtil.getPropertyValue(property, NodeProperty.SNMP_COMMUNITY);
			facility.setSnmpCommunity(checkString(values.get(0)));
			//SNMPバージョンを取得し、Facilityに設定
			values = PropertyUtil.getPropertyValue(property, NodeProperty.SNMP_VERSION);
			facility.setSnmpVersion(checkString(values.get(0)));
			
			//SNMPタイムアウト
			values = PropertyUtil.getPropertyValue(property, NodeProperty.SNMPTIMEOUT);
			facility.setSnmpTimeout(checkInteger(values.get(0)));
			
			//SNMPリトライ回数
			values = PropertyUtil.getPropertyValue(property, NodeProperty.SNMPRETRIES);
			facility.setSnmpRetries(checkInteger(values.get(0)));
						
			//SNMPプロキシ
			values = PropertyUtil.getPropertyValue(property, NodeProperty.SNMPPROXY);
			facility.setSnmpProxy(checkString(values.get(0)));
			
			//備考
			values = PropertyUtil.getPropertyValue(property, NodeProperty.NOTE);
			facility.setNote(checkArrayList(values));
			
			//画面アイコンイメージ
			values = PropertyUtil.getPropertyValue(property, NodeProperty.ICONIMAGE);
			facility.setIconImage(checkString(values.get(0)));
			
			//仮想化ノード種別
			values = PropertyUtil.getPropertyValue(property, NodeProperty.VIRTNODETYPE);
			facility.setVirtNodeType(checkString(values.get(0)));
			
			//仮想マシン管理ノード
			values = PropertyUtil.getPropertyValue(property, NodeProperty.VMMANAGEMENTNODE);
			facility.setVMManagementNode(checkString(values.get(0)));
			
			//仮想マシンINDEX
			values = PropertyUtil.getPropertyValue(property, NodeProperty.VMINDEX);
			facility.setVmIndex(checkInteger(values.get(0)));
			
			//仮想マシン名
			values = PropertyUtil.getPropertyValue(property, NodeProperty.VMNAME);
			facility.setVmName(checkString(values.get(0)));
			
			//仮想化ソリューション
			values = PropertyUtil.getPropertyValue(property, NodeProperty.VIRTSOLUTION);
			facility.setVirtSolution(checkString(values.get(0)));
			
			
//			FIXME　ソートの順番はとりあえずオンコードで100とする。
		
			facility.setSortValue(new Integer(DEFAULT_SORT_ORDER));
			
			//nullをセットすることでstore()を呼び出す。
			facility = null;

			//デバイスの配列を取得
			ArrayList deviceList = PropertyUtil.getProperty(property, NodeProperty.DEVICE);
			for(int i = 0; i < deviceList.size(); i++){
			    //デバイスINDEXを取得
				Property deviceProperty= (Property)deviceList.get(i);
				values = PropertyUtil.getPropertyValue(deviceProperty, NodeProperty.DEVICE_INDEX);
				Integer deviceIndex = checkInteger(values.get(0));
				
				//デバイスタイプを取
				values = PropertyUtil.getPropertyValue(deviceProperty, NodeProperty.DEVICE_TYPE);
				String deviceType = checkString(values.get(0));
				
				if(deviceIndex != null && deviceType != null && !deviceType.equals("")){
					//DeviceInfoを作成
					DeviceInfoLocal device = DeviceInfoUtil.getLocalHome().create(
							deviceIndex, 
							deviceType,
							facilityId);
				
					if(device != null){
						//デバイス名を取得し、DeviceInfoに設定
						values = PropertyUtil.getPropertyValue(deviceProperty, NodeProperty.DEVICE_NAME);
						device.setDeviceName(checkString(values.get(0)));
					    //デバイスINDEXを取得し、DeviceInfoに設定
						values = PropertyUtil.getPropertyValue(deviceProperty, NodeProperty.DEVICE_INDEX);
						device.setDeviceIndex(checkInteger(values.get(0)));
						//デバイスOIDを取得し、DeviceInfoに設定
						values = PropertyUtil.getPropertyValue(deviceProperty, NodeProperty.DEVICE_OID);
						device.setSnmpOID(checkString(values.get(0)));
						//デバイスタイプを取得し、DeviceInfoに設定
						values = PropertyUtil.getPropertyValue(deviceProperty, NodeProperty.DEVICE_TYPE);
						device.setDeviceType(checkString(values.get(0)));
						//説明を取得し、DeviceInfoに設定
						values = PropertyUtil.getPropertyValue(deviceProperty, NodeProperty.DEVICE_DESCRIPTION);
						device.setDescription(checkString(values.get(0)));
					}
				}
			}
			
			//ファイルシステムの配列を取得
			ArrayList fileSystemList = PropertyUtil.getProperty(property, NodeProperty.FILE_SYSTEM);
			for(int i = 0; i < fileSystemList.size(); i++){
			    //ファイルシステムINDEXを取得
				Property fileSystemProperty= (Property)fileSystemList.get(i);
				values = PropertyUtil.getPropertyValue(fileSystemProperty, NodeProperty.FILE_SYSTEM_INDEX);
				Integer cn = checkInteger(values.get(0));
				
				if(cn != null){
					//FileSystemInfoを作成
					FileSystemInfoLocal fileSystem = FileSystemInfoUtil.getLocalHome().create(
							cn, 
							facilityId);
				
					if(fileSystem != null){
					    //マウント位置を取得し、FileSystemInfoに設定
						values = PropertyUtil.getPropertyValue(fileSystemProperty, NodeProperty.FILE_SYSTEM_MOUNT_POINT);
						fileSystem.setFileSystemMountPoint(checkString(values.get(0)));
						//ファイルシステムOIDを取得し、FileSystemInfoに設定
						values = PropertyUtil.getPropertyValue(fileSystemProperty, NodeProperty.FILE_SYSTEM_OID);
						fileSystem.setSnmpOID(checkString(values.get(0)));
						//ファイルシステムタイプを取得し、FileSystemInfoに設定
						values = PropertyUtil.getPropertyValue(fileSystemProperty, NodeProperty.FILE_SYSTEM_TYPE);
						fileSystem.setFileSystemType(checkString(values.get(0)));
						//説明を取得し、FileSystemInfoに設定
						values = PropertyUtil.getPropertyValue(fileSystemProperty, NodeProperty.FILE_SYSTEM_DESCRIPTION);
						fileSystem.setDescription(checkString(values.get(0)));
					}
				}
			}
			
			try {
				//Topicに送信
				SendTopic send = new SendTopic(TopicConstant.TOPIC_NAME_EXECUTE);
				send.put(new UpdateRepositoryInfo());
			} catch (Exception e) {
				m_log.debug("addScope() : 更新情報送信エラー : " + e.getMessage());
			}
		} catch (EJBException e) {
            AplLogger apllog = new AplLogger("REP", "rep");
            String[] args = {facilityId};
            apllog.put("SYS", "009", args);
            
            m_log.debug("addNode() : " + e.getMessage());
			throw e;
		}
	}
	
	/**
	 * ノード変更
	 * 
	 * @param property
	 * @param user
	 * @throws NamingException
	 * @throws FinderException
	 * @throws CreateException
	 */
	public void modifyNode(Property property, String user) throws NamingException, FinderException, CreateException  {
    	//アクセスロック
    	AccessLock.lock(AccessLock.REPOSITORY);
    	
    	String facilityId = null;
	    try {
			ArrayList values = null;
			Date now = new Date();
			
			//ファシリティIDを取得
			values = PropertyUtil.getPropertyValue(property, NodeProperty.FACILITY_ID);
			facilityId = (String)values.get(0);
			
			//Facilityを検索し取得
			FacilityLocal facility = FacilityUtil.getLocalHome().findByFacilityId(facilityId);
			
			//ファシリティ名を取得し、Facilityに設定
			values = PropertyUtil.getPropertyValue(property, NodeProperty.FACILITY_NAME);
			facility.setCn(checkString(values.get(0)));
//			//エージェント制御を取得し、Facilityに設定
//			values = PropertyUtil.getPropertyValue(property, NodeProperty.AGENT_CONTROL);
//			facility.setAgentControl((Boolean)values.get(0));
//			//エージェント監視を取得し、Facilityに設定
//			values = PropertyUtil.getPropertyValue(property, NodeProperty.AGENT_MONITOR);
//			facility.setAgentWatch((Boolean)values.get(0));
//			//エージェント監視ステータスを取得し、Facilityに設定
//			values = PropertyUtil.getPropertyValue(property, NodeProperty.AGENT_MONITOR_STATUS);
//			facility.setAgentWatchStatus((Boolean)values.get(0));
			//文字セットを取得し、Facilityに設定
			values = PropertyUtil.getPropertyValue(property, NodeProperty.CHARACTER_SET);
			facility.setCharSet(checkString(values.get(0)));
			//説明を取得し、Facilityに設定
			values = PropertyUtil.getPropertyValue(property, NodeProperty.DESCRIPTION);
			facility.setDescription(checkString(values.get(0)));
			//有効/無効フラグを取得し、Facilityに設定
			values = PropertyUtil.getPropertyValue(property, NodeProperty.VALID);
			facility.setValid((Boolean)values.get(0));
			//DHCPクライアントを取得し、Facilityに設定
			values = PropertyUtil.getPropertyValue(property, NodeProperty.DHCP_CLIENT);
			facility.setDhcpClient((Boolean)values.get(0));
			//ホスト名を取得し、Facilityに設定
			values = PropertyUtil.getPropertyValue(property, NodeProperty.HOST_NAME);
			facility.setHost(checkArrayList(values));
			//IPアドレスV4を取得し、Facilityに設定
			values = PropertyUtil.getPropertyValue(property, NodeProperty.IP_ADDRESS_V4);
			facility.setIpNetworkNumber(checkString(values.get(0)));
			//IPアドレスV6を取得し、Facilityに設定
			values = PropertyUtil.getPropertyValue(property, NodeProperty.IP_ADDRESS_V6);
			facility.setIpNetworkNumberV6(checkString(values.get(0)));
			//IPバージョンを取得し、Facilityに設定
			values = PropertyUtil.getPropertyValue(property, NodeProperty.IP_ADDRESS_VERSION);
			facility.setIpProtocolNumber(checkInteger(values.get(0)));
			//IPタイプを取得し、Facilityに設定
			values = PropertyUtil.getPropertyValue(property, NodeProperty.IP_ADDRESS_TYPE);
			facility.setIpType(checkInteger(values.get(0)));
//			//イベント監視を取得し、Facilityに設定
//			values = PropertyUtil.getPropertyValue(property, NodeProperty.EVENT_MONITOR);
//			facility.setLogWatch((Boolean)values.get(0));
			//H/Wタイプを取得し、Facilityに設定
			values = PropertyUtil.getPropertyValue(property, NodeProperty.HARDWARE_TYPE);
			facility.setMachine(checkString(values.get(0)));
			//管理者を取得し、Facilityに設定
			values = PropertyUtil.getPropertyValue(property, NodeProperty.ADMINISTRATOR);
			facility.setManagerName(checkString(values.get(0)));
			//連絡先を取得し、Facilityに設定
			values = PropertyUtil.getPropertyValue(property, NodeProperty.CONTACT);
			facility.setManagerContact(checkString(values.get(0)));
			//更新者を取得し、Facilityに設定
			facility.setModifiersName(user);
			//更新日時を取得し、Facilityに設定
			facility.setModifyTimestamp(now);
			//ノード名を取得し、Facilityに設定
			values = PropertyUtil.getPropertyValue(property, NodeProperty.NODE_NAME);
			facility.setNodeName(checkString(values.get(0)));
			//OS名を取得し、Facilityに設定
			values = PropertyUtil.getPropertyValue(property, NodeProperty.OS_NAME);
			facility.setOsName(checkString(values.get(0)));
			//OSリリースを取得し、Facilityに設定
			values = PropertyUtil.getPropertyValue(property, NodeProperty.OS_RELEASE);
			facility.setOsRelease(checkString(values.get(0)));
			//OSバージョンを取得し、Facilityに設定
			values = PropertyUtil.getPropertyValue(property, NodeProperty.OS_VERSION);
			facility.setOsVersion(checkString(values.get(0)));
//			//PING監視を取得し、Facilityに設定
//			values = PropertyUtil.getPropertyValue(property, NodeProperty.PING_MONITOR);
//			facility.setPingWatch((Boolean)values.get(0));
//			//PING監視ステータスを取得し、Facilityに設定
//			values = PropertyUtil.getPropertyValue(property, NodeProperty.PING_MONITOR_STATUS);
//			if(values.get(0) instanceof Boolean)
//			    facility.setPingWatchStatus((Boolean)values.get(0));
			//プラットフォームを取得し、Facilityに設定
			values = PropertyUtil.getPropertyValue(property, NodeProperty.PLATFORM_FAMILY_NAME);
			facility.setPlatform(checkString(values.get(0)));
//			//ステータス監視を取得し、Facilityに設定
//			values = PropertyUtil.getPropertyValue(property, NodeProperty.STATUS_MONITOR);
//			facility.setStatusWatch((Boolean)values.get(0));
			
			//ポート番号を取得し、Facilityに設定
			values = PropertyUtil.getPropertyValue(property, NodeProperty.SNMP_PORT);
			facility.setSnmpPort(checkInteger(values.get(0)));
			//コミュニティ名を取得し、Facilityに設定
			values = PropertyUtil.getPropertyValue(property, NodeProperty.SNMP_COMMUNITY);
			facility.setSnmpCommunity(checkString(values.get(0)));
			//SNMPバージョンを取得し、Facilityに設定
			values = PropertyUtil.getPropertyValue(property, NodeProperty.SNMP_VERSION);
			facility.setSnmpVersion(checkString(values.get(0)));
			
			//SNMPタイムアウト
			values = PropertyUtil.getPropertyValue(property, NodeProperty.SNMPTIMEOUT);
			facility.setSnmpTimeout(checkInteger(values.get(0)));
			
			//SNMPリトライ回数
			values = PropertyUtil.getPropertyValue(property, NodeProperty.SNMPRETRIES);
			facility.setSnmpRetries(checkInteger(values.get(0)));
						
			//SNMPプロキシ
			values = PropertyUtil.getPropertyValue(property, NodeProperty.SNMPPROXY);
			facility.setSnmpProxy(checkString(values.get(0)));
			
			//備考
			values = PropertyUtil.getPropertyValue(property, NodeProperty.NOTE);
			facility.setNote(checkArrayList(values));
			
			//画面アイコンイメージ
			values = PropertyUtil.getPropertyValue(property, NodeProperty.ICONIMAGE);
			facility.setIconImage(checkString(values.get(0)));
			
			//仮想化ノード種別
			values = PropertyUtil.getPropertyValue(property, NodeProperty.VIRTNODETYPE);
			facility.setVirtNodeType(checkString(values.get(0)));
			
			//仮想マシン管理ノード
			values = PropertyUtil.getPropertyValue(property, NodeProperty.VMMANAGEMENTNODE);
			facility.setVMManagementNode(checkString(values.get(0)));
			
			//仮想マシンINDEX
			values = PropertyUtil.getPropertyValue(property, NodeProperty.VMINDEX);
			facility.setVmIndex(checkInteger(values.get(0)));
			
			//仮想マシン名
			values = PropertyUtil.getPropertyValue(property, NodeProperty.VMNAME);
			facility.setVmName(checkString(values.get(0)));
			
			//仮想化ソリューション
			values = PropertyUtil.getPropertyValue(property, NodeProperty.VIRTSOLUTION);
			facility.setVirtSolution(checkString(values.get(0)));
			
		    //Facilityと関連しているデバイスを削除
			try {
				//Facilityと関連しているデバイスを取得
				Collection ct = facility.getDeviceInfo();
				
				//DeviceInfoを全削除
				Iterator itr = ct.iterator();
				DeviceInfoLocal device = null;
				while(itr.hasNext()){
					device = (DeviceInfoLocal)itr.next();
					device.remove();
				}
			} catch (FinderException e) {
			    m_log.debug("modifyNode() : " + e.getMessage());
			} catch (EJBException e) {
			    m_log.debug("modifyNode() : " + e.getMessage());
			} catch (RemoveException e) {
			    m_log.debug("modifyNode() : " + e.getMessage());
			}

			// ファイルシステムの情報を取得した後で呼び出すため、コメントアウトした。
			//nullをセットすることでstore()を呼び出す。
			//facility = null;
			
			//デバイスの配列を取得
			ArrayList deviceList = PropertyUtil.getProperty(property, NodeProperty.DEVICE);

			//デバイスの作成
			for(int i = 0; i < deviceList.size(); i++){
				//デバイスINDEXを取得
				Property deviceProperty= (Property)deviceList.get(i);
				values = PropertyUtil.getPropertyValue(deviceProperty, NodeProperty.DEVICE_INDEX);
				Integer deviceIndex = checkInteger(values.get(0));
				
				//デバイスタイプを取得
				values = PropertyUtil.getPropertyValue(deviceProperty, NodeProperty.DEVICE_TYPE);
				String deviceType = checkString(values.get(0));
				
				if(deviceIndex != null && deviceType != null && !deviceType.equals("")){
					//DeviceInfoを作成
					DeviceInfoLocal device = DeviceInfoUtil.getLocalHome().create(
							deviceIndex, 
							deviceType,
							facilityId);
	
					if(device != null){
					    //デバイス名を取得し、DeviceInfoに設定
						values = PropertyUtil.getPropertyValue(deviceProperty, NodeProperty.DEVICE_NAME);
						device.setDeviceName(checkString(values.get(0)));
					    //デバイスINDEXを取得し、DeviceInfoに設定
						values = PropertyUtil.getPropertyValue(deviceProperty, NodeProperty.DEVICE_INDEX);
						device.setDeviceIndex(checkInteger(values.get(0)));
						//デバイスOIDを取得し、DeviceInfoに設定
						values = PropertyUtil.getPropertyValue(deviceProperty, NodeProperty.DEVICE_OID);
						device.setSnmpOID(checkString(values.get(0)));
						//デバイスタイプを取得し、DeviceInfoに設定
						values = PropertyUtil.getPropertyValue(deviceProperty, NodeProperty.DEVICE_TYPE);
						device.setDeviceType(checkString(values.get(0)));
						//説明を取得し、DeviceInfoに設定
						values = PropertyUtil.getPropertyValue(deviceProperty, NodeProperty.DEVICE_DESCRIPTION);
						device.setDescription(checkString(values.get(0)));
					}
				}
			}
			
			//Facilityと関連しているファイルシステムを削除
			try {
				//Facilityと関連しているファイルシステムを取得
				Collection ct = facility.getFileSystemInfo();
				
				//FileSystemInfoを全削除
				Iterator itr = ct.iterator();
				FileSystemInfoLocal fileSystem = null;
				while(itr.hasNext()){
					fileSystem = (FileSystemInfoLocal)itr.next();
					fileSystem.remove();
				}
			} catch (FinderException e) {
			    m_log.debug("modifyNode() : " + e.getMessage());
			} catch (EJBException e) {
			    m_log.debug("modifyNode() : " + e.getMessage());
			} catch (RemoveException e) {
			    m_log.debug("modifyNode() : " + e.getMessage());
			}
			//nullをセットすることでstore()を呼び出す。
			facility = null;
			
			//ファイルシステムの配列を取得
			ArrayList fileSystemList = PropertyUtil.getProperty(property, NodeProperty.FILE_SYSTEM);
			
			//ファイルシステムの作成
			for(int i = 0; i < fileSystemList.size(); i++){
			    //ファイルシステムINDEXを取得
				Property fileSystemProperty= (Property)fileSystemList.get(i);
				values = PropertyUtil.getPropertyValue(fileSystemProperty, NodeProperty.FILE_SYSTEM_INDEX);
				Integer cn = checkInteger(values.get(0));
				
				if(cn != null){					
					//FileSystemInfoを作成
					FileSystemInfoLocal fileSystem = FileSystemInfoUtil.getLocalHome().create(
							cn, 
							facilityId);
				
					if(fileSystem != null){
					    //マウント位置を取得し、FileSystemInfoに設定
						values = PropertyUtil.getPropertyValue(fileSystemProperty, NodeProperty.FILE_SYSTEM_MOUNT_POINT);
						fileSystem.setFileSystemMountPoint(checkString(values.get(0)));
						//ファイルシステムOIDを取得し、FileSystemInfoに設定
						values = PropertyUtil.getPropertyValue(fileSystemProperty, NodeProperty.FILE_SYSTEM_OID);
						fileSystem.setSnmpOID(checkString(values.get(0)));
						//ファイルシステムタイプを取得し、FileSystemInfoに設定
						values = PropertyUtil.getPropertyValue(fileSystemProperty, NodeProperty.FILE_SYSTEM_TYPE);
						fileSystem.setFileSystemType(checkString(values.get(0)));
						//説明を取得し、FileSystemInfoに設定
						values = PropertyUtil.getPropertyValue(fileSystemProperty, NodeProperty.FILE_SYSTEM_DESCRIPTION);
						fileSystem.setDescription(checkString(values.get(0)));
					}
				}
			}
			
			try {
				//Topicに送信
				SendTopic send = new SendTopic(TopicConstant.TOPIC_NAME_EXECUTE);
				send.put(new UpdateRepositoryInfo());
			} catch (Exception e) {
				m_log.debug("addScope() : 更新情報送信エラー : " + e.getMessage());
			}
		} catch (EJBException e) {
            AplLogger apllog = new AplLogger("REP", "rep");
            String[] args = {facilityId};
            apllog.put("SYS", "011", args);
            
            m_log.debug("modifyNode() : " + e.getMessage());
			throw e;
		} catch (FinderException e) {
            AplLogger apllog = new AplLogger("REP", "rep");
            String[] args = {facilityId};
            apllog.put("SYS", "011", args);
            
            m_log.debug("modifyNode() : " + e.getMessage());
			throw e;
		}
	}

	/**
	 * ノード変更(一括)
	 * 
	 * @param property
	 * @param parentFacilityId
	 * @param user
	 * @throws NamingException
	 * @throws FinderException
	 */
	public void modifyAllNode(Property property, String parentFacilityId, String user) throws NamingException, FinderException {
    	//アクセスロック
    	AccessLock.lock(AccessLock.REPOSITORY);
    	
    	Collection collection;
		try {
		    //ファシリティIDの配下のノードを取得する
			collection = FacilityTreeUtil.getLocalHome().findAllNode(parentFacilityId);

			Iterator itr = collection.iterator();
			while(itr.hasNext()){
				FacilityTreeLocal ft = (FacilityTreeLocal)itr.next();
				FacilityLocal facility = ft.getFacility();
				
				try {
				    //ノード変更
				    ArrayList values = null;
					Date now = new Date();
					
					//ファシリティ名を取得し、Facilityに設定
					values = PropertyUtil.getPropertyValue(property, NodeProperty.FACILITY_NAME);
					if(checkString(values.get(0)) != null)
					    facility.setCn(checkString(values.get(0)));
//					//エージェント制御を取得し、Facilityに設定
//					values = PropertyUtil.getPropertyValue(property, NodeProperty.AGENT_CONTROL);
//					if(values.get(0) != null && values.get(0) instanceof Boolean)
//					    facility.setAgentControl((Boolean)values.get(0));
//					//エージェント監視を取得し、Facilityに設定
//					values = PropertyUtil.getPropertyValue(property, NodeProperty.AGENT_MONITOR);
//					if(values.get(0) != null && values.get(0) instanceof Boolean)
//					    facility.setAgentWatch((Boolean)values.get(0));
//					//エージェント監視ステータスを取得し、Facilityに設定
//					values = PropertyUtil.getPropertyValue(property, NodeProperty.AGENT_MONITOR_STATUS);
//					if(values.get(0) != null && values.get(0) instanceof Boolean)
//					    facility.setAgentWatchStatus((Boolean)values.get(0));
					//文字セットを取得し、Facilityに設定
					values = PropertyUtil.getPropertyValue(property, NodeProperty.CHARACTER_SET);
					if(checkString(values.get(0)) != null)
					    facility.setCharSet(checkString(values.get(0)));
					//説明を取得し、Facilityに設定
					values = PropertyUtil.getPropertyValue(property, NodeProperty.DESCRIPTION);
					if(checkString(values.get(0)) != null)
					    facility.setDescription(checkString(values.get(0)));
					//有効/無効を取得し、Facilityに設定
					values = PropertyUtil.getPropertyValue(property, NodeProperty.VALID);
					if (values.get(0) != null && values.get(0) instanceof Boolean)
						facility.setValid((Boolean)values.get(0));
					//DHCPクライアントを取得し、Facilityに設定
					values = PropertyUtil.getPropertyValue(property, NodeProperty.DHCP_CLIENT);
					if(values.get(0) != null && values.get(0) instanceof Boolean)
					    facility.setDhcpClient((Boolean)values.get(0));
					//ホスト名を取得し、Facilityに設定
					values = PropertyUtil.getPropertyValue(property, NodeProperty.HOST_NAME);
					if(checkArrayList(values.get(0)) != null)
					    facility.setHost(checkArrayList(values));
					//IPアドレスV4を取得し、Facilityに設定
					values = PropertyUtil.getPropertyValue(property, NodeProperty.IP_ADDRESS_V4);
					if(checkString(values.get(0)) != null)
					    facility.setIpNetworkNumber(checkString(values.get(0)));
					//IPアドレスV6を取得し、Facilityに設定
					values = PropertyUtil.getPropertyValue(property, NodeProperty.IP_ADDRESS_V6);
					if(checkString(values.get(0)) != null)
					    facility.setIpNetworkNumberV6(checkString(values.get(0)));
					//IPバージョンを取得し、Facilityに設定
					values = PropertyUtil.getPropertyValue(property, NodeProperty.IP_ADDRESS_VERSION);
					if(checkInteger(values.get(0)) != null)
					    facility.setIpProtocolNumber(checkInteger(values.get(0)));
					//IPタイプを取得し、Facilityに設定
					values = PropertyUtil.getPropertyValue(property, NodeProperty.IP_ADDRESS_TYPE);
					if(checkInteger(values.get(0)) != null)
					    facility.setIpType(checkInteger(values.get(0)));
//					//イベント監視を取得し、Facilityに設定
//					values = PropertyUtil.getPropertyValue(property, NodeProperty.EVENT_MONITOR);
//					if(values.get(0) != null && values.get(0) instanceof Boolean)
//					    facility.setLogWatch((Boolean)values.get(0));
					//H/Wタイプを取得し、Facilityに設定
					values = PropertyUtil.getPropertyValue(property, NodeProperty.HARDWARE_TYPE);
					if(checkString(values.get(0)) != null)
					    facility.setMachine(checkString(values.get(0)));
					//管理者を取得し、Facilityに設定
					values = PropertyUtil.getPropertyValue(property, NodeProperty.ADMINISTRATOR);
					if(checkString(values.get(0)) != null)
					    facility.setManagerName(checkString(values.get(0)));
					//連絡先を取得し、Facilityに設定
					values = PropertyUtil.getPropertyValue(property, NodeProperty.CONTACT);
					if(checkString(values.get(0)) != null)
					    facility.setManagerContact(checkString(values.get(0)));
					//更新者を取得し、Facilityに設定
					facility.setModifiersName(user);
					//更新日時を取得し、Facilityに設定
					facility.setModifyTimestamp(now);
					//ノード名を取得し、Facilityに設定
					values = PropertyUtil.getPropertyValue(property, NodeProperty.NODE_NAME);
					if(checkString(values.get(0)) != null)
					    facility.setNodeName(checkString(values.get(0)));
					//OS名を取得し、Facilityに設定
					values = PropertyUtil.getPropertyValue(property, NodeProperty.OS_NAME);
					if(checkString(values.get(0)) != null)
					    facility.setOsName(checkString(values.get(0)));
					//OSリリースを取得し、Facilityに設定
					values = PropertyUtil.getPropertyValue(property, NodeProperty.OS_RELEASE);
					if(checkString(values.get(0)) != null)
					    facility.setOsRelease(checkString(values.get(0)));
					//OSバージョンを取得し、Facilityに設定
					values = PropertyUtil.getPropertyValue(property, NodeProperty.OS_VERSION);
					if(checkString(values.get(0)) != null)
					    facility.setOsVersion(checkString(values.get(0)));
//					//PING監視を取得し、Facilityに設定
//					values = PropertyUtil.getPropertyValue(property, NodeProperty.PING_MONITOR);
//					if(values.get(0) != null && values.get(0) instanceof Boolean)
//					    facility.setPingWatch((Boolean)values.get(0));
//					//PING監視ステータスを取得し、Facilityに設定
//					values = PropertyUtil.getPropertyValue(property, NodeProperty.PING_MONITOR_STATUS);
//					if(values.get(0) != null && values.get(0) instanceof Boolean)
//					    facility.setPingWatchStatus((Boolean)values.get(0));
					//プラットフォームを取得し、Facilityに設定
					values = PropertyUtil.getPropertyValue(property, NodeProperty.PLATFORM_FAMILY_NAME);
					if(checkString(values.get(0)) != null)
					    facility.setPlatform(checkString(values.get(0)));
//					//ステータス監視を取得し、Facilityに設定
//					values = PropertyUtil.getPropertyValue(property, NodeProperty.STATUS_MONITOR);
//					if(values.get(0) != null && values.get(0) instanceof Boolean)
//					    facility.setStatusWatch((Boolean)values.get(0));
					
					//ポート番号を取得し、Facilityに設定
					values = PropertyUtil.getPropertyValue(property, NodeProperty.SNMP_PORT);
					if(checkInteger(values.get(0)) != null)
						facility.setSnmpPort(checkInteger(values.get(0)));
					//コミュニティ名を取得し、Facilityに設定
					values = PropertyUtil.getPropertyValue(property, NodeProperty.SNMP_COMMUNITY);
					if(checkString(values.get(0)) != null)
						facility.setSnmpCommunity(checkString(values.get(0)));
					//SNMPバージョンを取得し、Facilityに設定
					values = PropertyUtil.getPropertyValue(property, NodeProperty.SNMP_VERSION);
					if(checkString(values.get(0)) != null)
						facility.setSnmpVersion(checkString(values.get(0)));
					
					//SNMPタイムアウト
					values = PropertyUtil.getProperty(property, NodeProperty.SNMPTIMEOUT);
					facility.setSnmpTimeout(checkInteger(values.get(0)));
					
					//SNMPリトライ回数
					values = PropertyUtil.getProperty(property, NodeProperty.SNMPRETRIES);
					facility.setSnmpRetries(checkInteger(values.get(0)));
								
					//SNMPプロキシ
					values = PropertyUtil.getProperty(property, NodeProperty.SNMPRETRIES);
					facility.setSnmpProxy(checkString(values.get(0)));
					
					//備考
					values = PropertyUtil.getProperty(property, NodeProperty.NOTE);
					facility.setNote(checkArrayList(values));
					
					//画面アイコンイメージ
					values = PropertyUtil.getProperty(property, NodeProperty.ICONIMAGE);
					facility.setIconImage(checkString(values.get(0)));
					
					//仮想化ノード種別
					values = PropertyUtil.getProperty(property, NodeProperty.VIRTNODETYPE);
					facility.setVirtNodeType(checkString(values.get(0)));
					
					//仮想マシン管理ノード
					values = PropertyUtil.getProperty(property, NodeProperty.VMMANAGEMENTNODE);
					facility.setVMManagementNode(checkString(values.get(0)));
					
					//仮想マシンINDEX
					values = PropertyUtil.getProperty(property, NodeProperty.VMINDEX);
					facility.setVmIndex(checkInteger(values.get(0)));
					
					//仮想マシン名
					values = PropertyUtil.getProperty(property, NodeProperty.VMNAME);
					facility.setVmName(checkString(values.get(0)));
					
					//仮想化ソリューション
					values = PropertyUtil.getProperty(property, NodeProperty.VIRTSOLUTION);
					facility.setVirtSolution(checkString(values.get(0)));
					
					//デバイスの配列を取得
					ArrayList deviceList = PropertyUtil.getProperty(property, NodeProperty.DEVICE);
				    //デバイス名を取得
					Property deviceProperty= (Property)deviceList.get(0);
					values = PropertyUtil.getPropertyValue(deviceProperty, NodeProperty.DEVICE_NAME);
					
					if(deviceList.size() > 0 && checkString(values.get(0)) != null){
					    //Facilityと関連しているデバイスを削除
						try {
							//Facilityと関連しているデバイスを取得
							Collection ct = facility.getDeviceInfo();
							
							//DeviceInfoを全削除
							Iterator itr1 = ct.iterator();
							DeviceInfoLocal device = null;
							while(itr.hasNext()){
								device = (DeviceInfoLocal)itr1.next();
								device.remove();
							}
						} catch (FinderException e) {
						    m_log.debug("modifyAllNode() : " + e.getMessage());
						} catch (EJBException e) {
						    m_log.debug("modifyAllNode() : " + e.getMessage());
						} catch (RemoveException e) {
						    m_log.debug("modifyAllNode() : " + e.getMessage());
						}
					}

					//デバイスの作成
					for(int i = 0; i < deviceList.size(); i++){
					    //デバイスINDEXを取得
						deviceProperty= (Property)deviceList.get(i);
						values = PropertyUtil.getPropertyValue(deviceProperty, NodeProperty.DEVICE_INDEX);
						Integer deviceIndex = checkInteger(values.get(0));
						
						//デバイスタイプを取得
						values = PropertyUtil.getPropertyValue(deviceProperty, NodeProperty.DEVICE_TYPE);
						String deviceType = checkString(values.get(0));
						
						if(deviceIndex != null && deviceType != null && !deviceType.equals("")){
							//DeviceInfoを作成
							DeviceInfoLocal device = DeviceInfoUtil.getLocalHome().create(
									deviceIndex, 
									deviceType,
									facility.getFacilityId());
			
							if(device != null){
							    //デバイス名を取得し、DeviceInfoに設定
								values = PropertyUtil.getPropertyValue(deviceProperty, NodeProperty.DEVICE_NAME);
								device.setDeviceName(checkString(values.get(0)));
							    //デバイスINDEXを取得し、DeviceInfoに設定
								values = PropertyUtil.getPropertyValue(deviceProperty, NodeProperty.DEVICE_INDEX);
								device.setDeviceIndex(checkInteger(values.get(0)));
								//デバイスOIDを取得し、DeviceInfoに設定
								values = PropertyUtil.getPropertyValue(deviceProperty, NodeProperty.DEVICE_OID);
								device.setSnmpOID(checkString(values.get(0)));
								//デバイスタイプを取得し、DeviceInfoに設定
								values = PropertyUtil.getPropertyValue(deviceProperty, NodeProperty.DEVICE_TYPE);
								device.setDeviceType(checkString(values.get(0)));
								//説明を取得し、DeviceInfoに設定
								values = PropertyUtil.getPropertyValue(deviceProperty, NodeProperty.DEVICE_DESCRIPTION);
								device.setDescription(checkString(values.get(0)));
							}
						}
					}
					
					
					//ファイルシステムの配列を取得
					ArrayList fileSystemList = PropertyUtil.getProperty(property, NodeProperty.FILE_SYSTEM);
					
				    //ファイルシステムINDEXを取得
					Property fileSystemProperty= (Property)fileSystemList.get(0);
					values = PropertyUtil.getPropertyValue(fileSystemProperty, NodeProperty.FILE_SYSTEM_INDEX);
					
					if(fileSystemList.size() > 0 && checkString(values.get(0)) != null){
					    //Facilityと関連しているファイルシステムを削除
						try {
							//Facilityと関連しているファイルシステムを取得
							Collection ct = facility.getDeviceInfo();
							
							//FileSystemInfoを全削除
							Iterator itr1 = ct.iterator();
							FileSystemInfoLocal fileSystem = null;
							while(itr.hasNext()){
								fileSystem = (FileSystemInfoLocal)itr1.next();
								fileSystem.remove();
							}
						} catch (FinderException e) {
						    m_log.debug("modifyAllNode() : " + e.getMessage());
						} catch (EJBException e) {
						    m_log.debug("modifyAllNode() : " + e.getMessage());
						} catch (RemoveException e) {
						    m_log.debug("modifyAllNode() : " + e.getMessage());
						}
					}
					
					//ファイルシステムの作成
					for(int i = 0; i < fileSystemList.size(); i++){
					    //ファイルシステムINDEXを取得
						fileSystemProperty= (Property)fileSystemList.get(i);
						values = PropertyUtil.getPropertyValue(fileSystemProperty, NodeProperty.FILE_SYSTEM_INDEX);
						Integer cn = checkInteger(values.get(0));
						
						if(cn != null){
							//FileSystemInfoを作成
							FileSystemInfoLocal fileSystem = FileSystemInfoUtil.getLocalHome().create(
									cn, 
									facility.getFacilityId());
						
							if(fileSystem != null){
							    //マウント位置を取得し、FileSystemInfoに設定
								values = PropertyUtil.getPropertyValue(fileSystemProperty, NodeProperty.FILE_SYSTEM_MOUNT_POINT);
								fileSystem.setFileSystemMountPoint(checkString(values.get(0)));
								//ファイルシステムOIDを取得し、FileSystemInfoに設定
								values = PropertyUtil.getPropertyValue(fileSystemProperty, NodeProperty.FILE_SYSTEM_OID);
								fileSystem.setSnmpOID(checkString(values.get(0)));
								//ファイルシステムタイプを取得し、FileSystemInfoに設定
								values = PropertyUtil.getPropertyValue(fileSystemProperty, NodeProperty.FILE_SYSTEM_TYPE);
								fileSystem.setFileSystemType(checkString(values.get(0)));
								//説明を取得し、FileSystemInfoに設定
								values = PropertyUtil.getPropertyValue(fileSystemProperty, NodeProperty.FILE_SYSTEM_DESCRIPTION);
								fileSystem.setDescription(checkString(values.get(0)));
							}
						}
					}
					
				} catch (CreateException e) {
				    m_log.debug("modifyAllNode() : " + e.getMessage());
				}
			}
			
			try {
				//Topicに送信
				SendTopic send = new SendTopic(TopicConstant.TOPIC_NAME_EXECUTE);
				send.put(new UpdateRepositoryInfo());
			} catch (Exception e) {
				m_log.debug("addScope() : 更新情報送信エラー : " + e.getMessage());
			}
		} catch (EJBException e) {
		    m_log.debug("modifyAllNode() : " + e.getMessage());
			throw e;
		}
	}
	
	public void modifyFacilityTreeValid(Property property) throws FinderException, NamingException {
    	//アクセスロック
    	AccessLock.lock(AccessLock.REPOSITORY);
  	
    	String facilityId = null;
		ArrayList values = null;
		Date now = new Date();
		
		try {
			//ファシリティIDを取得
			values = PropertyUtil.getPropertyValue(property, NodeProperty.FACILITY_ID);
			facilityId = (String)values.get(0);
			
			//Facilityを検索し取得
			FacilityLocal facility = FacilityUtil.getLocalHome().findByFacilityId(facilityId);
			
			//変更後の有効/無効フラグをPropertyから取得
			values = PropertyUtil.getPropertyValue(property, NodeProperty.VALID);
			Boolean postValid = (Boolean)values.get(0);

			//有効/無効フラグが変更後と等しくない、すべてのFacilityTreeを取得
			Collection collection = FacilityTreeUtil.getLocalHome().findByFacilityId(facilityId, !postValid);
			Iterator iterator = collection.iterator();
			
			//有効/無効フラグを変更
			while(iterator.hasNext()){
				FacilityTreeLocal facilitytree = (FacilityTreeLocal)iterator.next();
				facilitytree.setValid(postValid);
//				facilitytree = null;
			}

			try {
				//Topicに送信
				SendTopic send = new SendTopic(TopicConstant.TOPIC_NAME_EXECUTE);
				send.put(new UpdateRepositoryInfo());
			} catch (Exception e) {
				m_log.debug("addScope() : 更新情報送信エラー : " + e.getMessage());
			}
				
		} catch (FinderException e) {
			m_log.error("modifyFacilityTreeValid() : findByFacilityId() failure ", e);
			throw e;
		} catch (NamingException e) {
			m_log.error("modifyFacilityTreeValid() : getLocalHome() failure ", e);
			throw e;
 		}
		
	}

    /**
     * ノード詳細を設定
     * 
     * @param facilityId
     * @param attributes 属性名と値のHashMap
     * @throws FinderException
     * @throws NamingException
     */
    public void setNodeDetail(String facilityId, HashMap attributes) throws FinderException, NamingException {
    	//アクセスロック
    	AccessLock.lock(AccessLock.REPOSITORY);
    	
    	try {
            FacilityLocal facility = FacilityUtil.getLocalHome().findByFacilityId(facilityId);
            
            if(attributes.get(FacilityAttributeConstant.CN) != null){
                //cn取得
                String attribute = (String)attributes.get(FacilityAttributeConstant.CN);
                facility.setCn(attribute);
            }
            if(attributes.get(FacilityAttributeConstant.DESCRIPTION) != null){
                //description取得
                String attribute = (String)attributes.get(FacilityAttributeConstant.DESCRIPTION);
                facility.setDescription(attribute);
            }
            if(attributes.get(FacilityAttributeConstant.VALID) != null){
                //valid取得
                Boolean attribute = (Boolean)attributes.get(FacilityAttributeConstant.VALID);
                facility.setValid(attribute);
            }
            if(attributes.get(FacilityAttributeConstant.AGENTCONTROL) != null){
                //ccAgentControl取得
                Boolean attribute = (Boolean)attributes.get(FacilityAttributeConstant.AGENTCONTROL);
                facility.setAgentControl(attribute);
            }
            if(attributes.get(FacilityAttributeConstant.AGENTWATCH) != null){
                //ccAgentWatch取得
                Boolean attribute = (Boolean)attributes.get(FacilityAttributeConstant.AGENTWATCH);
                facility.setAgentWatch(attribute);
            }
            if(attributes.get(FacilityAttributeConstant.AGENTWATCHSTATUS) != null){
                //ccAgentWatchStatus取得
                Boolean attribute = (Boolean)attributes.get(FacilityAttributeConstant.AGENTWATCHSTATUS);
                facility.setAgentWatchStatus(attribute);
            }
            if(attributes.get(FacilityAttributeConstant.CHARSET) != null){
                //ccCharSet取得
                String attribute = (String)attributes.get(FacilityAttributeConstant.CHARSET);
                facility.setCharSet(attribute);
            }
            if(attributes.get(FacilityAttributeConstant.CREATETIMESTAMP) != null){
                //ccCreateTimestamp取得
                Date attribute = (Date)attributes.get(FacilityAttributeConstant.CREATETIMESTAMP);
                facility.setCreateTimestamp(attribute);
            }
            if(attributes.get(FacilityAttributeConstant.CREATORSNAME) != null){
                //ccCreatorsName取得
                String attribute = (String)attributes.get(FacilityAttributeConstant.CREATORSNAME);
                facility.setCreatorsName(attribute);
            }
            if(attributes.get(FacilityAttributeConstant.DHCPCLIENT) != null){
                //ccDhcpClient取得
                Boolean attribute = (Boolean)attributes.get(FacilityAttributeConstant.DHCPCLIENT);
                facility.setDhcpClient(attribute);
            }
            if(attributes.get(FacilityAttributeConstant.HOST) != null){
                //host取得
                ArrayList attribute = (ArrayList)attributes.get(FacilityAttributeConstant.HOST);
                facility.setHost(attribute);
            }
            if(attributes.get(FacilityAttributeConstant.IPNETWORKNUMBER) != null){
                //ipNetworkNumber取得
                String attribute = (String)attributes.get(FacilityAttributeConstant.IPNETWORKNUMBER);
                facility.setIpNetworkNumber(attribute);
            }
            if(attributes.get(FacilityAttributeConstant.IPNETWORKNUMBERV6) != null){
                //ccIpNetworkNumberV6取得
                String attribute = (String)attributes.get(FacilityAttributeConstant.IPNETWORKNUMBERV6);
                facility.setIpNetworkNumberV6(attribute);
            }
            if(attributes.get(FacilityAttributeConstant.IPPROTOCOLNUMBER) != null){
                //ipProtocolNumber取得
                Integer attribute = (Integer)attributes.get(FacilityAttributeConstant.IPPROTOCOLNUMBER);
                facility.setIpProtocolNumber(attribute);
            }
            if(attributes.get(FacilityAttributeConstant.IPTYPE) != null){
                //ccIpType取得
                Integer attribute = (Integer)attributes.get(FacilityAttributeConstant.IPTYPE);
                facility.setIpType(attribute);
            }
            if(attributes.get(FacilityAttributeConstant.LOGWATCH) != null){
                //ccLogWatch取得
                Boolean attribute = (Boolean)attributes.get(FacilityAttributeConstant.LOGWATCH);
                facility.setLogWatch(attribute);
            }
            if(attributes.get(FacilityAttributeConstant.MACHINE) != null){
                //ccMachine取得
                String attribute = (String)attributes.get(FacilityAttributeConstant.MACHINE);
                facility.setMachine(attribute);
            }
            if(attributes.get(FacilityAttributeConstant.MANAGERCONTACT) != null){
                //ccManagerContact取得
                String attribute = (String)attributes.get(FacilityAttributeConstant.MANAGERCONTACT);
                facility.setManagerContact(attribute);
            }
            if(attributes.get(FacilityAttributeConstant.MANAGERNAME) != null){
                //ccManagerName取得
                String attribute = (String)attributes.get(FacilityAttributeConstant.MANAGERNAME);
                facility.setManagerName(attribute);
            }
            if(attributes.get(FacilityAttributeConstant.MODIFIERSNAME) != null){
                //ccModifiersName取得
                String attribute = (String)attributes.get(FacilityAttributeConstant.MODIFIERSNAME);
                facility.setModifiersName(attribute);
            }
            if(attributes.get(FacilityAttributeConstant.MODIFYTIMESTAMP) != null){
                //ccModifyTimestamp取得
                Date attribute = (Date)attributes.get(FacilityAttributeConstant.MODIFYTIMESTAMP);
                facility.setModifyTimestamp(attribute);
            }
            if(attributes.get(FacilityAttributeConstant.NODENAME) != null){
                //ccNodeName取得
                String attribute = (String)attributes.get(FacilityAttributeConstant.NODENAME);
                facility.setNodeName(attribute);
            }
            if(attributes.get(FacilityAttributeConstant.OSNAME) != null){
                //ccOsName取得
                String attribute = (String)attributes.get(FacilityAttributeConstant.OSNAME);
                facility.setOsName(attribute);
            }
            if(attributes.get(FacilityAttributeConstant.OSRELEASE) != null){
                //ccOsRelease取得
                String attribute = (String)attributes.get(FacilityAttributeConstant.OSRELEASE);
                facility.setOsRelease(attribute);
            }
            if(attributes.get(FacilityAttributeConstant.OSVERSION) != null){
                //ccOsVersion取得
                String attribute = (String)attributes.get(FacilityAttributeConstant.OSVERSION);
                facility.setOsVersion(attribute);
            }
            if(attributes.get(FacilityAttributeConstant.PINGWATCH) != null){
                //ccPingWatch取得
                Boolean attribute = (Boolean)attributes.get(FacilityAttributeConstant.PINGWATCH);
                facility.setPingWatch(attribute);
            }
            if(attributes.get(FacilityAttributeConstant.PINGWATCHSTATUS) != null){
                //ccPingWatchStatus取得
                Boolean attribute = (Boolean)attributes.get(FacilityAttributeConstant.PINGWATCHSTATUS);
                facility.setPingWatchStatus(attribute);
            }
            if(attributes.get(FacilityAttributeConstant.PLATFORM) != null){
                //ccPlatform取得
                String attribute = (String)attributes.get(FacilityAttributeConstant.PLATFORM);
                facility.setPlatform(attribute);
            }
            if(attributes.get(FacilityAttributeConstant.STATUSWATCH) != null){
                //ccPlatform取得
                Boolean attribute = (Boolean)attributes.get(FacilityAttributeConstant.STATUSWATCH);
                facility.setStatusWatch(attribute);
            }
            if(attributes.get(FacilityAttributeConstant.SNMPPORT) != null){
            	//ccSnmpPort取得
            	Integer attribute = (Integer)attributes.get(FacilityAttributeConstant.SNMPPORT);
            	facility.setSnmpPort(attribute);
            }
            if(attributes.get(FacilityAttributeConstant.SNMPCOMMUNITY) != null){
            	//ccSnmpCommunity取得
            	String attribute = (String)attributes.get(FacilityAttributeConstant.SNMPCOMMUNITY);
            	facility.setSnmpCommunity(attribute);
            }
            if(attributes.get(FacilityAttributeConstant.SNMPTIMEOUT) != null){
            	//ccSnmpTimeout取得
            	Integer attribute = (Integer)attributes.get(FacilityAttributeConstant.SNMPTIMEOUT);
            	facility.setSnmpTimeout(attribute);
            }
            if(attributes.get(FacilityAttributeConstant.SNMPVERSION) != null){
            	//ccSnmpRetries取得
            	Integer attribute = (Integer)attributes.get(FacilityAttributeConstant.SNMPRETRIES);
            	facility.setSnmpRetries(attribute);
            }
            if(attributes.get(FacilityAttributeConstant.SNMPPROXY) != null){
            	//ccSnmpProxy取得
            	String attribute = (String)attributes.get(FacilityAttributeConstant.SNMPPROXY);
            	facility.setSnmpProxy(attribute);
            }
            if(attributes.get(FacilityAttributeConstant.NOTE) != null){
            	//ccNote取得
            	ArrayList attribute = (ArrayList)attributes.get(FacilityAttributeConstant.NOTE);
            	facility.setNote(attribute);
            }
            if(attributes.get(FacilityAttributeConstant.ICONIMAGE) != null){
            	//ccIconImage取得
            	String attribute = (String)attributes.get(FacilityAttributeConstant.ICONIMAGE);
            	facility.setIconImage(attribute);
            }
            if(attributes.get(FacilityAttributeConstant.VIRTNODETYPE) != null){
            	//ccVirtNodeType取得
            	String attribute = (String)attributes.get(FacilityAttributeConstant.VIRTNODETYPE);
            	facility.setVirtNodeType(attribute);
            }
            if(attributes.get(FacilityAttributeConstant.VMMANAGEMENTNODE) != null){
            	//ccVmManagementNode取得
            	String attribute = (String)attributes.get(FacilityAttributeConstant.VMMANAGEMENTNODE);
            	facility.setVMManagementNode(attribute);
            }
            if(attributes.get(FacilityAttributeConstant.VMINDEX) != null){
            	//ccVmIndex取得
            	Integer attribute = (Integer)attributes.get(FacilityAttributeConstant.VMINDEX);
            	facility.setVmIndex(attribute);
            }
            if(attributes.get(FacilityAttributeConstant.VMNAME) != null){
            	//ccVmName取得
            	String attribute = (String)attributes.get(FacilityAttributeConstant.VMNAME);
            	facility.setVmName(attribute);
            }
            if(attributes.get(FacilityAttributeConstant.VIRTSOLUTION) != null){
            	//ccSnmpVersion取得
            	String attribute = (String)attributes.get(FacilityAttributeConstant.VIRTSOLUTION);
            	facility.setVirtSolution(attribute);
            }

            
        } catch (FinderException e) {
            m_log.debug("setNodeDetail() : " + e.getMessage());
            throw e;
        } catch (NamingException e) {
            m_log.debug("setNodeDetail() : " + e.getMessage());
            throw e;
        }
    }
	
	/**
	 * Integerのインスタンスかチェックし、違っていればnullを返す
	 * 
	 * @param value
	 * @return
	 */
    protected Integer checkInteger(Object value){
		if(value instanceof Integer){
			return (Integer)value;
		}
		else{
			return null;
		}
	}
	
	/**
	 * Stringのインスタンスかチェックし、違っていればnullを返す
	 * 
	 * @param value
	 * @return
	 */
	protected String checkString(Object value){
		if(value instanceof String){
			if(((String)value).compareTo("") == 0){
				return null;
			}
			else{
				return (String)value;
			}
		}
		else{
			return null;
		}
	}
	
	/**
	 * ArrayListのインスタンスかチェックし、違っていればnullを返す
	 * 
	 * @param value
	 * @return
	 */
	protected ArrayList checkArrayList(Object value){
		if(value instanceof ArrayList){
			boolean checkNull = true;
			ArrayList list = (ArrayList)value;
			for(int i = 0; i < list.size(); i++){
				if(checkString(list.get(i)) != null){
					list.set(i, checkString(list.get(i)));
					checkNull = false;
				}
				else if(checkInteger(list.get(i)) != null){
					list.set(i, checkInteger(list.get(i)));
					checkNull = false;
				}
				else{
					list.set(i, null);
				}
			}

			if(checkNull){
				list = null;
			}

			return list;
		}
		else{
			return null;
		}
	}
	
}
