/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.notify.bean;

import java.sql.Timestamp;
import java.util.ArrayList;

import com.clustercontrol.bean.ExclusionConstant;
import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.StatusExpirationConstant;
import com.clustercontrol.bean.StatusValidPeriodConstant;
import com.clustercontrol.bean.ValidConstant;

/**
 * 通知情報を保持するクラスです。
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class NotifyInfo
implements java.io.Serializable
{
	private static final long serialVersionUID = -4587823656729541121L;
	
	/** 通知ID。 */
	private java.lang.String m_notifyId;
	
	/** 説明。 */
	private java.lang.String m_description;
	
	/**
	 * 通知タイプ
	 * @see com.clustercontrol.bean.NotifyTypeConstant
	 */
	private java.lang.Integer m_notifyType;
	
	/**
	 * 抑制間隔フラグ。
	 * @see com.clustercontrol.bean.ExclusionConstant
	 */
	private java.lang.Integer m_inhibitionFlg = new Integer(ExclusionConstant.TYPE_NO);
	
	/** 抑制回数。 */
	private java.lang.Integer m_inhibitionFrequency;
	
	/** 抑制期間（分）。 */
	private java.lang.Integer m_inhibitionPeriod;
	
	/** 作成日時。 */
	private java.sql.Timestamp m_regDate;
	
	
	/** 最終変更日時。 */
	private java.sql.Timestamp m_updateDate;
	
	/** 作成ユーザ　*/
	private String m_regUser;
	
	/** 最終更新ユーザ*/
	private String m_updateUser;
	
	/**有効無効フラグ*/
	private Integer m_validFlg;
	
	/** 通知イベント情報。 */
	private java.util.ArrayList<NotifyInfoDetail> m_notifyInfoDetail;
	
	/**
	 * コンストラクタ。
	 */
	public NotifyInfo() {
	}
	
	/**
	 * コンストラクタ。
	 * 
	 * @param notifyId 通知ID
	 * @param description 説明
	 * @param notiftType 通知タイプ
	 * @param inhibitionFlg 抑制間隔フラグ
	 * @param inhibitionFrequency 抑制回数
	 * @param inhibitionPeriod 抑制期間（分）
	 * @param regDate 作成日時
	 * @param updateDate 最終変更日時
	 * @param regUser 作成ユーザ
	 * @param updateUser 最終更新ユーザ
	 * @param validFlg 有効無効フラグ
	 * @param notifyInfoDetail<NotifyInfoDetail> 通知情報詳細
	 * 
	 * @see com.clustercontrol.bean.ValidConstant
	 * @see com.clustercontrol.bean.ExclusionConstant
	 * @see com.clustercontrol.bean.StatusExpirationConstant
	 * @see com.clustercontrol.bean.PriorityConstant
	 * @see com.clustercontrol.bean.StatusValidPeriodConstant
	 */
	public NotifyInfo(
			String notifyId,
			String description,
			Integer notifyType,
			Integer inhibitionFlg,
			Integer inhibitionFrequency,
			Integer inhibitionPeriod,
			Timestamp regDate,
			Timestamp updateDate,
			String regUser,
			String updateUser,
			Integer validFlg,
			ArrayList<NotifyInfoDetail> notifyInfoDetail ) {
		
		setNotifyId(notifyId);
		setDescription(description);
		setNotifyType(notifyType);
		setInhibitionFlg(inhibitionFlg);
		setInhibitionFrequency(inhibitionFrequency);
		setInhibitionPeriod(inhibitionPeriod);
		setRegDate(regDate);
		setUpdateDate(updateDate);
		setRegUser(regUser);
		setUpdateUser(updateUser);
		setValidFlg(validFlg);
	
		setNotifyInfoDetail(notifyInfoDetail);
	}
	

	/**
	 * コンストラクタ。
	 * 
	 * @param otherData コピー元の通知情報
	 */
	public NotifyInfo( NotifyInfo otherData ) {
		
		setNotifyId(otherData.getNotifyId());
		setDescription(otherData.getDescription());
		setNotifyType(otherData.getNotifyType());
		setInhibitionFlg(otherData.getInhibitionFlg());
		setInhibitionFrequency(otherData.getInhibitionFrequency());
		setInhibitionPeriod(otherData.getInhibitionPeriod());
		setRegDate(otherData.getRegDate());
		setUpdateDate(otherData.getUpdateDate());
		setRegUser(otherData.getRegUser());
		setUpdateUser(otherData.getUpdateUser());
		setNotifyInfoDetail(otherData.getNotifyInfoDetail());
		
	}
	
	/**
	 * 通知IDを返します。
	 * 
	 * @return 通知ID
	 */
	public String getNotifyId() {
		return this.m_notifyId;
	}
	
	/**
	 * 通知IDを設定します。
	 * 
	 * @param notifyId 通知ID
	 */
	public void setNotifyId( String notifyId ) {
		this.m_notifyId = notifyId;
	}
	
	/**
	 * 説明を返します。
	 * 
	 * @return 説明
	 */
	public String getDescription() {
		return this.m_description;
	}
	
	/**
	 * 説明を設定します。
	 * 
	 * @param description 説明
	 */
	public void setDescription( String description ) {
		this.m_description = description;
	}
	

	/**
	 * 通知タイプを取得します。
	 * @return
	 */
	public Integer getNotifyType(){
		
		return this.m_notifyType;
	}
	
	/**
	 * 通知タイプを設定します。
	 * 
	 * @param notifyType
	 */
	public void setNotifyType(Integer notifyType){
		this.m_notifyType=notifyType;
	}
	
	/**
	 * 抑制間隔フラグを返します。
	 * 
	 * @return 抑制間隔フラグ
	 * 
	 * @see com.clustercontrol.bean.ExclusionConstant
	 */
	public Integer getInhibitionFlg() {
		return this.m_inhibitionFlg;
	}
	
	/**
	 * 抑制間隔フラグを設定します。
	 * 
	 * @param inhibitionFlg 抑制間隔フラグ
	 * 
	 * @see com.clustercontrol.bean.ExclusionConstant
	 */
	public void setInhibitionFlg( Integer inhibitionFlg ) {
		this.m_inhibitionFlg = inhibitionFlg;
	}
	
	/**
	 * 抑制回数を返します。
	 * 
	 * @return 抑制回数
	 */
	public Integer getInhibitionFrequency() {
		return this.m_inhibitionFrequency;
	}
	
	/**
	 * 抑制回数を設定します。
	 * 
	 * @param inhibitionFrequency 抑制回数
	 */
	public void setInhibitionFrequency( Integer inhibitionFrequency ) {
		this.m_inhibitionFrequency = inhibitionFrequency;
	}
	
	/**
	 * 抑制期間を返します。
	 * 
	 * @return inhibitionPeriod 抑制期間（分）
	 */
	public Integer getInhibitionPeriod() {
		return this.m_inhibitionPeriod;
	}
	
	/**
	 * 抑制期間を設定します。
	 * 
	 * @param inhibitionPeriod 抑制期間（分）
	 */
	public void setInhibitionPeriod( Integer inhibitionPeriod ) {
		this.m_inhibitionPeriod = inhibitionPeriod;
	}
	
	/**
	 * 作成日時を返します。
	 * 
	 * @return 作成日時
	 */
	public java.sql.Timestamp getRegDate() {
		return this.m_regDate;
	}
	
	/**
	 * 作成日時を設定します。
	 * 
	 * @param regDate 作成日時
	 */
	public void setRegDate( java.sql.Timestamp regDate ) {
		this.m_regDate = regDate;
	}
	
	/**
	 * 最終変更日時を返します。
	 * 
	 * @return 最終変更日時
	 */
	public java.sql.Timestamp getUpdateDate() {
		return this.m_updateDate;
	}
	
	/**
	 * 最終変更日時を設定します。
	 * 
	 * @param updateDate 最終変更日時
	 */
	public void setUpdateDate( java.sql.Timestamp updateDate ) {
		this.m_updateDate = updateDate;
	}
	
	/**
	 * 登録ユーザを返します。
	 * 
	 * @return　登録ユーザ
	 */
	public String getRegUser(){	
		return this.m_regUser;
	}
	
   /**
    * 登録ユーザを設定します。
    * 
    * @param regUser
    */
	public void setRegUser(String regUser){
		this.m_regUser=regUser;
		
	}
	
	
	/**
	 * 最終更新ユーザを返します。
	 * 
	 * @return　最終更新ユーザ
	 */
	public String getUpdateUser(){
		
		return this.m_updateUser;
	}
	
   /**
    * 最終更新ユーザを設定します。
    * 
    * @param regUser
    */
	public void setUpdateUser(String updateUser){
		this.m_updateUser=updateUser;
		
	}
	
	
	/**
	 *  通知情報詳細を返します。
	 * 
	 * @return  通知情報詳細
	 * 
	 * @see com.clustercontrol.notify.bean.NotifyEventInfo
	 */
	public java.util.ArrayList<NotifyInfoDetail> getNotifyInfoDetail() {
		return this.m_notifyInfoDetail;
		
	}
	
	/**
	 *  通知情報詳細を設定します。
	 * 
	 * @param notifyInfoDetail 通知情報詳細
	 * 
	 * @see com.clustercontrol.notify.bean.NotifyEventInfo
	 */
	public void setNotifyInfoDetail(java.util.ArrayList<NotifyInfoDetail> notifyInfoDetail) {
		this.m_notifyInfoDetail = notifyInfoDetail;
	}

	/**
	 * 有効無効フラグを返します。
	 * 
	 * @return 有効無効フラグ
	 */
	public Integer getValidFlg() {
		return m_validFlg;
	}

	/**
	 * 有効無効フラグを設定します。
	 * @param vaildFlg
	 */
	public void setValidFlg(Integer validFlg) {
		this.m_validFlg = validFlg;
	}
}
