/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.bean;

import java.io.Serializable;

/**
 * スコープ情報を保持するクラス<BR>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class FacilityInfo implements Serializable {

    // ----- instance フィールド ----- //

    /**
	 * 
	 */
	private static final long serialVersionUID = 5885187185548374558L;

	/** ファシリティID */
    private String facilityId = null;

    /** ファシリティ名 */
    private String facilityName = null;

    /** 種別 */
    private int type = 0;
    
    /**ツリー表示順ソートのための値*/
    private int sortOrder = 100;

    /**スコープがビルトインかのフラグ*/
    private boolean builtInFlg = false;

    /**ノード単位の有効／無効フラグ*/
    private boolean valid = false;

    /**
     * 初期化されたインスタンスを返します。
     */
    public FacilityInfo() {
        this.initialize();
    }

    // ----- instance メソッド ----- /

    /**
     * オブジェクトを初期化します。<BR>
     */
    public void initialize() {
        this.setFacilityId("");
        this.setFacilityName("");
        this.setType(FacilityConstant.TYPE_NODE);
        this.setBuiltInFlg(false);
        this.setSortOrder(100);
        
    }

    /**
     * ファシリティIDを取得します。<BR>
     * 
     * @return ファシリティID
     */
    public String getFacilityId() {
        return this.facilityId;
    }

    /**
     * ファシリティIDを設定します。
     * 
     * @param facilityId
     *            ファシリティID
     */
    public void setFacilityId(String facilityId) {
        this.facilityId = facilityId;
    }

    /**
     * ファシリティ名を取得します。<BR>
     * 
     * @return ファシリティ名
     */
    public String getFacilityName() {
        return this.facilityName;
    }

    /**
     * ファシリティ名を設定します。
     * 
     * @param name
     *            ファシリティ名
     */
    public void setFacilityName(String facilityName) {
        this.facilityName = facilityName;
    }

    /**
     * 種別を取得します。<BR>
     * 
     * @return type 種別
     */
    public int getType() {
        return this.type;
    }

    /**
     * 種別を設定します。
     * 
     * @param type
     *            種別
     */
    public void setType(int type) {
        this.type = type;
    }

    /**
     * スコープが組み込みスコープか判定します。
     * @return true : 組み込みスコープ　false:通常スコープ
     */
	public boolean isBuiltInFlg() {
		return builtInFlg;
	}
	/**
	 * 組み込みスコープフラグを設定します。
	 * @param builtInFlg
	 */
	public void setBuiltInFlg(boolean builtInFlg) {
		this.builtInFlg = builtInFlg;
	}
	
    /**
     * スコープツリーのソート順を取得します。
     * （この値の小さい順（昇順）にツリーの要素は並びます。）
     * @return
     */
 	public int getSortOrder() {
		return sortOrder;
	}
 	
   /**
   * スコープツリーのソート順を設定します。 
   * @param sortOrder
   */
	public void setSortOrder(int sortOrder) {
		this.sortOrder = sortOrder;
	}

	/**
	 * ノード単位の有効／無効フラグ を設定します。
	 * 
	 * @return ノード単位の有効／無効フラグ
	 */
	public boolean isValid() {
		return valid;
	}

	/**
	 * ノード単位の有効／無効フラグ を設定取得します。
	 * 
	 * @param ノード単位の有効／無効フラグ
	 */
	public void setValid(boolean valid) {
		this.valid = valid;
	}
}