/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.process.factory;

import java.util.ArrayList;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.poller.CollectorAlreadyExistException;
import com.clustercontrol.poller.FacilityNotFoundException;
import com.clustercontrol.poller.NotInitializedException;
import com.clustercontrol.poller.snmp.SnmpPoller;
import com.clustercontrol.poller.snmp.SnmpPollerManager;
import com.clustercontrol.process.bean.SnmpSharedTableConstant;
import com.clustercontrol.process.util.SnmpProcConnectionManager;
import com.clustercontrol.repository.ejb.session.RepositoryControllerBean;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import com.clustercontrol.sharedtable.DataTableNotFoundException;
import com.clustercontrol.sharedtable.SharedTable;
import com.clustercontrol.util.apllog.AplLogger;

/**
 * ポーリングを共通ポーラーに登録するクラス<BR>
 *
 * @version 2.0.0
 * @since 2.0.0
 */
public class ModifyPollingSchedule {
	
	protected static Log m_log = LogFactory.getLog( ModifyPollingSchedule.class );
	
	/**
	 * SNMPポーリングに登録します。<BR>
	 * 
	 * @param parentFacilityId ファシリティID
	 * @param interval 収集間隔(秒)
	 * @throws CreateException
	 * @throws FinderException
	 * @throws NamingException
	 */
	@SuppressWarnings("unchecked")
	public boolean addSchedule(String monitorTypeId, String monitorId, String parentFacilityId, int interval) {

		if(parentFacilityId != null && !"".equals(parentFacilityId)){
			
			try{
				// SNMP収集値の共有テーブルをルックアップ
		        SharedTable sst = SnmpProcConnectionManager.getSnmpSharedTable();
				
				// ファシリティIDの配下全ての一覧を取得
				RepositoryControllerLocal repository = RepositoryControllerUtil.getLocalHome().create();
				ArrayList facilityList = repository.getExecTargetFacilityIdList(parentFacilityId);
//				ArrayList facilityList = repository.getNodeFacilityIdList(parentFacilityId, RepositoryControllerBean.ALL);
//
//				//配下にノードがないということはノードの可能性があるので指定されたIDをセット
//				if (facilityList.size() == 0) {
//					if(repository.isNode(parentFacilityId) == true){
//						facilityList.add(parentFacilityId);
//					}
//				}
				
				// ファシリティ毎に登録
				String facilityId = null;
				for(int index=0; index<facilityList.size(); index++){
					facilityId = (String)facilityList.get(index);
					if(facilityId != null && !"".equals(facilityId)){
						// テーブル生成
						// テーブルが存在しない場合は生成する
						// 時系列情報を必要としないためページサイズは1を指定する
						if(sst.containsTable(monitorTypeId, facilityId, 1) == false){
							sst.createDataTable(monitorTypeId, facilityId, 1);
						}
						
						// ポーラを生成する
						InitialContext ctx = new InitialContext();
						Object obj = ctx.lookup(SnmpSharedTableConstant.POLLER_MANAGER_JNDI_NAME);
						SnmpPollerManager manager = 
							(SnmpPollerManager)PortableRemoteObject.narrow(obj, SnmpPollerManager.class);
						
						// ポーリングを開始する
						try {
							// ポーラを取得
							SnmpPoller poller = manager.getPoller(monitorTypeId, facilityId);
							// ない場合は生成する
							if(poller == null){
								poller = manager.createPoller(monitorTypeId, facilityId, true, monitorTypeId, facilityId);
							}
							poller.startPolling(monitorId, interval, SnmpSharedTableConstant.PROCESS_OIDS);
						} catch (NotInitializedException e) {
							m_log.error(e.getMessage(), e);
						} catch (DataTableNotFoundException e) {
							m_log.error(e.getMessage(), e);
						} catch (CollectorAlreadyExistException e) {
							m_log.error(e.getMessage(), e);
						} catch (FacilityNotFoundException e) {
							m_log.error(e.getMessage(), e);
						}
					}
				}
				return true;
				
			}catch(CreateException e){
				AplLogger apllog = new AplLogger("PROC", "proc");
				String[] args = { parentFacilityId };
				apllog.put("SYS", "001", args);
				m_log.debug("addSchedule():" + e.getMessage());
			}catch(FinderException e){
				AplLogger apllog = new AplLogger("PROC", "proc");
				String[] args = { parentFacilityId };
				apllog.put("SYS", "001", args);
				m_log.debug("addSchedule():" + e.getMessage());
			}catch(NamingException e){
				AplLogger apllog = new AplLogger("PROC", "proc");
				String[] args = { parentFacilityId };
				apllog.put("SYS", "001", args);
				m_log.debug("addSchedule():" + e.getMessage());
			}
		}
		return false;
	}
	
	/**
	 * SNMPポーリングを停止します。<BR>
	 * 
	 * @param parentFacilityId ファシリティID
	 * @param interval 収集間隔(秒)
	 * @throws CreateException
	 * @throws FinderException
	 * @throws NamingException
	 */
	@SuppressWarnings("unchecked")
	public boolean deleteSchedule(String monitorTypeId, String monitorId, String parentFacilityId) {

		if(parentFacilityId != null && !"".equals(parentFacilityId)){
			
			try{
				// SNMP収集値の共有テーブルをルックアップ
		        SharedTable sst = SnmpProcConnectionManager.getSnmpSharedTable();
				
				// ファシリティIDの配下全ての一覧を取得
				RepositoryControllerLocal repository = RepositoryControllerUtil.getLocalHome().create();
				ArrayList facilityList = repository.getNodeFacilityIdList(parentFacilityId, RepositoryControllerBean.ALL);

				//配下にノードがないということはノードの可能性があるので指定されたIDをセット
				if (facilityList.size() == 0) {
					if(repository.isNode(parentFacilityId) == true){
						facilityList.add(parentFacilityId);
					}
				}
				
				// ノード毎にポーリングを停止する
				String facilityId = null;
				for(int index=0; index<facilityList.size(); index++){
					facilityId = (String)facilityList.get(index);
					
					// ポーラを生成する
					InitialContext ctx = new InitialContext();
					Object obj = ctx.lookup(SnmpSharedTableConstant.POLLER_MANAGER_JNDI_NAME);
					SnmpPollerManager manager = 
						(SnmpPollerManager)PortableRemoteObject.narrow(obj, SnmpPollerManager.class);
					
					// ポーリングを停止する
					SnmpPoller poller = manager.getPoller(monitorTypeId, facilityId);
					if(poller != null){
						poller.stopPolling(monitorId);
					}
					
					// テーブルから参照登録を削除する
					obj = ctx.lookup(SnmpSharedTableConstant.SHARED_TABLE_JNDI_NAME);
					SharedTable sharedTable = 
						(SharedTable)PortableRemoteObject.narrow(obj, SharedTable.class);
					
					try {
						sharedTable.unregisterCollector(monitorTypeId, facilityId, monitorId);
					} catch (DataTableNotFoundException e) {
						m_log.error(e.getMessage(), e);
					}
				}
				return true;
				
			}catch(CreateException e){
				AplLogger apllog = new AplLogger("PROC", "proc");
				String[] args = { parentFacilityId };
				apllog.put("SYS", "001", args);
				m_log.debug("addSchedule():" + e.getMessage());
			}catch(FinderException e){
				AplLogger apllog = new AplLogger("PROC", "proc");
				String[] args = { parentFacilityId };
				apllog.put("SYS", "001", args);
				m_log.debug("addSchedule():" + e.getMessage());
			}catch(NamingException e){
				AplLogger apllog = new AplLogger("PROC", "proc");
				String[] args = { parentFacilityId };
				apllog.put("SYS", "001", args);
				m_log.debug("addSchedule():" + e.getMessage());
			}
		}
		return false;
	}
}