/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 */

package com.clustercontrol.performance.composite;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Listener;

import com.clustercontrol.performance.util.CollectorItemCodeFactory;
import com.clustercontrol.performance.util.Messages;
import com.clustercontrol.performance.util.RealtimeCollectorItemInfo;

/**
 * 性能[グラフの設定]ダイアログの収集設定部分のコンポジットを生成するクラス
 * 
 * @version 1.0
 * @since 1.0
 */

// Groupでのサブクラス化はみとめられない.composite単位のみ.
public class RecordSetItemComposite extends Composite {

	private Combo combo = null;

	private int arrayNum;

	private Group group;

	private Button radioButton00;

	private Button radioButton01;

	private Button radioButton02;

	private Button radioButton03;

	private RealtimeCollectorItemInfo collectorItemInfo = null;

	/**
	 * コンストラクター
	 * 
	 * @param parent
	 * @param style
	 * @param _property
	 */
	public RecordSetItemComposite(Composite parent, int style) {
		super(parent, style);
	}

	/**
	 * 情報を更新します。
	 * 
	 * @param i
	 */
	public void update(int i) {
		// 将来はデータ項目を選択可能にすることを視野にいれる。
		String displayType = null;
		boolean isRadioButton0 = false;
		boolean isRadioButton1 = false;
		boolean isRadioButton2 = false;
		boolean isRadioButton3 = false;

		// 初期化または前回設定の復元
		displayType = collectorItemInfo.getDisplayTypeForDialog(i);
		if (displayType.equals("NonDisplay")) {
			isRadioButton0 = true;
		} else if (displayType.equals("SelectedScope")) {
			isRadioButton1 = true;
		} else if (displayType.equals("Detail")) {
			isRadioButton2 = true;
		} else if (displayType.equals("SubScope")) {
			isRadioButton3 = true;
		}

		// グループの設定
		String itemCode = collectorItemInfo.getItemCodeForDialog(i);
		group = new Group(this, SWT.NONE);
		GridData gridDataGroup = new GridData(GridData.FILL_HORIZONTAL);
		group.setLayoutData(gridDataGroup);
		group.setText(Messages.getString("GRAPH_ITEM") + (i + 1));

		GridLayout gridLayout00 = new GridLayout();
		gridLayout00.numColumns = 3; //３列
		group.setLayout(gridLayout00);

		// 囲み線の幅がラジオボタンの箇所とインターバルの箇所とで異なる。後で直す.

		//comboの設定
		//     リスト内の文字列の編集を不可にするため
		//    SWT.READ_ONLYを指定(尚ビット演算指定以外の指定方法見つからず).
		combo = new Combo(group, SWT.NONE | SWT.READ_ONLY);
		GridData gridDataCombo = new GridData(GridData.VERTICAL_ALIGN_BEGINNING);
		gridDataCombo.horizontalSpan = 3; //3列分を占める
		combo.setLayoutData(gridDataCombo);

		arrayNum = i;

		for (int j = 0; j < collectorItemInfo.getItemNumForCollector(); j++) {
			combo.add(CollectorItemCodeFactory.getFullItemName(
					collectorItemInfo.getItemCodeForCollector(j),
					collectorItemInfo.getDeviceNameForCollector(j)));
		}

		int collectorComboSelectIndex = 0;

		// ItemCodeがnull もしくは 空文字の場合、
		if (itemCode != null && !itemCode.equals("")) {

			String deviceName = collectorItemInfo.getDeviceNameForDialog(i);
			boolean isWhile = true;
			int count = 0;
			try {
				while (isWhile) {
					// ItemCodeとDeviceNameが同様のモノを発見した場合
					if(collectorItemInfo.getItemCodeForCollector(count).equals(itemCode)){
						if(collectorItemInfo.getDeviceNameForCollector(count) == (deviceName) 
								|| collectorItemInfo.getDeviceNameForCollector(count).equals(deviceName)){
							collectorComboSelectIndex = count;
							break;
						}	
					}
					count++;
				}
			}
			catch (ArrayIndexOutOfBoundsException e){
				// FIXME 配列を最後まで走査した結果、配列をオーバーするケースがあるため、ここでキャッチする。
			}
		}
		
		// 既に選択されているときはそれを復元する必要がある.
		combo.select(collectorComboSelectIndex); //選択項目.この指定がない場合「指定なし」の選択が可能となってしまう.
		combo.addSelectionListener(new SelectionListener() {
			// 名前なしクラスのフィールド変数として保持。
			int k = arrayNum;

			public void widgetDefaultSelected(SelectionEvent e) {
			}

			public void widgetSelected(SelectionEvent e) {
				int selectionIndex = combo.getSelectionIndex();
				// 詳細表示可能か否かをチェック
				// 詳細表示可能か否かを調べ、選択されている収集項目が詳細表示できない項目の場合は、
				// ラジオボタンの”詳細グラフ”を選択不可とする。

				// 内訳表示に必要な収集項目コードを取得
				String itemCode = collectorItemInfo
						.getItemCodeForCollector(selectionIndex);

				if (!collectorItemInfo
						.getItemDetailedForCollector(selectionIndex)) { // 詳細表示が可能でない場合.
					radioButton02.setEnabled(false);
					collectorItemInfo.isItemDetailedForDialog(k, false);
					if (radioButton02.getSelection()) {
						radioButton02.setSelection(false);
						radioButton01.setSelection(true);
						collectorItemInfo.setDisplayTypeForDialog(k,
								"SelectedScope");
					}
				} else {
					if (!radioButton02.getEnabled()) {
						radioButton02.setEnabled(true); // 先に詳細表示が選択されていた状態から戻す.
						collectorItemInfo.isItemDetailedForDialog(k, true);
					}
				}

				String deviceName = collectorItemInfo
						.getDeviceNameForCollector(selectionIndex);

				collectorItemInfo.setItemCodeForDialog(k, itemCode);
				collectorItemInfo.setDeviceNameForDialog(k, deviceName);
//				collectorItemInfo.setItemIdForDialog(k, Integer
//						.toString(selectionIndex));
				collectorItemInfo.setHasDevice(k, true);
			}
		});

		// ラジオボタン(共通：前処理)
		GridData gridData00;

		// ラジオボタン(非表示)
		radioButton00 = new Button(group, SWT.RADIO);
		radioButton00.setText(Messages.getString("HIDDEN"));
		gridData00 = new GridData(GridData.FILL_VERTICAL);
		gridData00.horizontalSpan = 3; //３列分を占める
		radioButton00.setLayoutData(gridData00);
		radioButton00.setSelection(isRadioButton0);
		arrayNum = i;
		radioButton00.addListener(SWT.Selection, new Listener() {
			// 名前なしクラスのフィールド変数として保持。
			int j = arrayNum;

			public void handleEvent(Event event) {
				collectorItemInfo.setDisplayTypeForDialog(j, "NonDisplay");
			}
		});
		// ラジオボタン(スコープ代表値)
		radioButton01 = new Button(group, SWT.RADIO);
		radioButton01.setText(Messages.getString("SCOPE_REPRESENTING_VALUE"));
		gridData00 = new GridData(GridData.FILL_VERTICAL);
		radioButton01.setLayoutData(gridData00);
		radioButton01.setSelection(isRadioButton1);
		radioButton01.addListener(SWT.Selection, new Listener() {
			// 名前なしクラスのフィールド変数として保持。
			int j = arrayNum;

			public void handleEvent(Event event) {
				collectorItemInfo.setDisplayTypeForDialog(j, "SelectedScope");
			}
		});
		// ラジオボタン(スコープ代表値詳細)
		radioButton02 = new Button(group, SWT.RADIO);
		radioButton02.setText(Messages
				.getString("DETAIL_SCOPE_REPRESENTING_VALUE"));
		gridData00 = new GridData(GridData.FILL_VERTICAL);
		radioButton02.setLayoutData(gridData00);
		radioButton02.setSelection(isRadioButton2);
		if (!collectorItemInfo.getItemDetailed(i)) { // 詳細表示が可能でない場合.
			radioButton02.setEnabled(false);
		}
		radioButton02.addListener(SWT.Selection, new Listener() {
			// 名前なしクラスのフィールド変数として保持。
			int j = arrayNum;

			public void handleEvent(Event event) {
				collectorItemInfo.setDisplayTypeForDialog(j, "Detail");
			}
		});
		// ラジオボタン(サブスコープ代表値)
		radioButton03 = new Button(group, SWT.RADIO);
		radioButton03.setText(Messages.getString("SUB_SCOPE_REP_VAL"));
		gridData00 = new GridData(GridData.FILL_VERTICAL);
		radioButton03.setLayoutData(gridData00);
		radioButton03.setSelection(isRadioButton3);
		radioButton03.addListener(SWT.Selection, new Listener() {
			// 値をオブジェクト内で固定保持するため名前なしクラスのフィールド変数にセットする.
			int j = arrayNum;

			public void handleEvent(Event event) {
				collectorItemInfo.setDisplayTypeForDialog(j, "SubScope");
			}
		});
		// ラジオボタン(共通:後処理)
	}

	/**
	 * リアルタイムの情報を設定します。
	 * 
	 * @param collectorItemInfo リアルタイム情報
	 */
	public void setCollectorItemInfo(RealtimeCollectorItemInfo collectorItemInfo) {
		this.collectorItemInfo = collectorItemInfo;
	}
}
