/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.view.action;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.bean.ConfirmConstant;
import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.bean.Property;
import com.clustercontrol.monitor.action.ConfirmEvent;
import com.clustercontrol.monitor.dialog.EventBatchConfirmDialog;
import com.clustercontrol.monitor.view.EventView;

/**
 * 監視[一括確認]ダイアログによる確認の更新処理を行うクライアント側アクションクラス<BR>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class EventBatchConfirmAction implements IViewActionDelegate {

	/** ビュー */
    private IViewPart viewPart; // ビュー


    /**
     * ビューを保持します。ワークベンチにロードされた際に呼ばれます。
     * 
     * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
     */
    public void init(IViewPart viewPart) {
        this.viewPart = viewPart;
    }

    /**
     * 監視[一括確認]ダイアログで指定された条件に一致するイベント情報の確認を更新します。
     * <p>
	 * <ol>
	 * <li>監視[一括確認]ダイアログを表示します。</li>
	 * <li>ダイアログで指定された更新条件を取得します。</li>
	 * <li>スコープツリーで選択されているアイテムより、ファシリティIDを取得します。</li>
	 * <li>ファシリティIDと更新条件に一致するイベント情報の確認を一括更新します。 </li>
	 * <li>監視[イベント]ビューを更新します。</li>
	 * </ol>
     * 
     * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
     * @see com.clustercontrol.monitor.dialog.EventBatchConfirmDialog
     * @see com.clustercontrol.monitor.action.ConfirmEvent#confirmBatch(int, String, Property)
     * @see com.clustercontrol.monitor.view.EventView#update()
     */
    public void run(IAction action) {

        EventBatchConfirmDialog dialog = new EventBatchConfirmDialog(
                this.viewPart.getSite().getShell());

        EventView view = (EventView) this.viewPart.getAdapter(EventView.class);

        if (dialog.open() == IDialogConstants.OK_ID) {
            Property condition = dialog.getInputData();

            FacilityTreeItem item = view.getScopeTreeComposite()
                    .getSelectItem();
            String facilityId = null;
            if (item != null) {
                facilityId = item.getData().getFacilityId();
            }

            if (new ConfirmEvent().confirmBatch(ConfirmConstant.TYPE_CONFIRMED,
                    facilityId, condition)) {
                view.update();
            }
        }
    }

    /**
     * 選択を変更した際に呼ばれます。
     * 
     * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction,
     *      org.eclipse.jface.viewers.ISelection)
     */
    public void selectionChanged(IAction action, ISelection selection) {
    }
}