/*
 
Copyright (C) 2007 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.maintenance.dialog;

import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import com.clustercontrol.bean.DataRangeConstant;
import com.clustercontrol.bean.DayOfWeekConstant;
import com.clustercontrol.bean.HinemosModuleConstant;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.Schedule;
import com.clustercontrol.bean.ScheduleConstant;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.calendar.composite.CalendarIdListComposite;
import com.clustercontrol.composite.ComboModifyListener;
import com.clustercontrol.composite.NumberKeyListener;
import com.clustercontrol.composite.StringVerifyListener;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.maintenance.action.AddMaintenance;
import com.clustercontrol.maintenance.action.GetMaintenance;
import com.clustercontrol.maintenance.action.ModifyMaintenance;
import com.clustercontrol.maintenance.bean.MaintenanceKeepMstConstant;
import com.clustercontrol.maintenance.bean.MaintenanceTypeMstConstant;
import com.clustercontrol.maintenance.bean.ScheduleInfo;
import com.clustercontrol.maintenance.bean.ScheduleTableDefine;
import com.clustercontrol.maintenance.composite.MaintenanceKeepListComposite;
import com.clustercontrol.maintenance.composite.MaintenanceTypeListComposite;
import com.clustercontrol.notify.bean.NotifyRelationInfo;
import com.clustercontrol.notify.composite.NotifyInfoComposite;
import com.clustercontrol.util.Messages;
import com.clustercontrol.maintenance.bean.MaintenanceInfoDataImp;

/**
 * メンテナンス[メンテナンスの作成・変更]ダイアログクラスです。
 * 
 * @version 3.0.0
 * @since 2.2.0
 */
public class MaintenanceDialog extends CommonDialog {
	
	/** メンテナンスID用テキスト */
	protected Text m_textMaintenanceId = null;
	/** 説明 */
	protected Text m_textDescription = null;
	/** メンテナンス種別 */
	protected MaintenanceTypeListComposite m_maintenance_type = null;
	/** 削除対象外期間 */
	protected MaintenanceKeepListComposite m_maintenance_keep = null;
//	/** スケジュールID用テキスト */
//    protected Text m_scheduleId = null;
//    /** スケジュール名用テキスト */
//    protected Text m_scheduleName = null;
    /** カレンダID用テキスト */
    protected CalendarIdListComposite m_calendarId = null;
    /** スケジュール日時指定用ラジオボタン */
    protected Button m_type1 = null;
    /** スケジュール曜日指定用ラジオボタン */
    protected Button m_type2 = null;
    /** 月指定用コンボボックス */
    protected Combo m_comboMonth = null;
    /** 日指定用コンボボックス */
    protected Combo m_comboDay = null;
    /** 時指定用コンボボックス */
    protected Combo m_comboHours1 = null;
    /** 分指定用コンボボックス */
    protected Combo m_comboMinutes1 = null;
    /** 曜日指定用コンボボックス */
    protected Combo m_comboDayOfWeek = null;
    /** 時指定用コンボボックス */
    protected Combo m_comboHours2 = null;
    /** 分指定用コンボボックス */
    protected Combo m_comboMinutes2 = null;
    /** シェル */
    protected Shell m_shell = null;
    /** スケジュール情報 */
    protected ArrayList m_schedule = null;
    /** メンテナンスID */
    protected String maintenanceId = null;
	/** 通知情報 */
    private NotifyInfoComposite notifyInfo = null;
    /** この設定を有効にする */
    private Button confirmValid = null;
    
    private MaintenanceInfoDataImp maintenanceInfo = null;
    private ScheduleInfo scheduleInfo = null;
    
    private Date scheduleDate = null;

    /** 参照フラグ */
    private boolean referenceFlg = false;
    
    /**
     * コンストラクタ
     * 
     * @param parent 親シェル
     */
    public MaintenanceDialog(Shell parent) {
        super(parent);
    }
    
    public MaintenanceDialog(Shell parent, String maintenanceId, boolean referenceFlg) {
    	super(parent);
    	
    	this.maintenanceId = maintenanceId;
    	this.referenceFlg = referenceFlg;
    }

    /**
     * ダイアログエリアを生成します。
     * 
     * @param parent 親コンポジット
     */
    protected void customizeDialog(Composite parent) {
        Shell shell = this.getShell();

        // タイトル
        shell.setText(Messages.getString("dialog.maintenance.create.modify"));

        // 変数として利用されるラベル
        Label label = null;
        // 変数として利用されるグリッドデータ
        GridData gridData = null;

        // レイアウト
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 15;
        parent.setLayout(layout);
        
        /*
         * メンテナンスID
         */
        // ラベル
        label = new Label(parent, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("maintenance.id") + " : ");
        // テキスト
        this.m_textMaintenanceId = new Text(parent, SWT.BORDER | SWT.LEFT);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textMaintenanceId.setLayoutData(gridData);
        if(this.maintenanceId != null && !"".equals(this.maintenanceId.trim())){
        	this.m_textMaintenanceId.setEnabled(false);
        }
        this.m_textMaintenanceId.addVerifyListener(new StringVerifyListener(DataRangeConstant.VARCHAR_64));
        
        // 空白
        label = new Label(parent, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);

        /*
         * 説明
         */
        // ラベル
        label = new Label(parent, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("description") + " : ");
        // テキスト
        this.m_textDescription = new Text(parent, SWT.BORDER | SWT.LEFT);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textDescription.setLayoutData(gridData);
        this.m_textDescription.addVerifyListener(new StringVerifyListener(DataRangeConstant.VARCHAR_120));
        // 空白
        label = new Label(parent, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        /*
         * 種別
         */
		this.m_maintenance_type = new MaintenanceTypeListComposite(parent, SWT.NONE, true);
		gridData = new GridData();
		gridData.horizontalSpan = 15;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		m_maintenance_type.setLayoutData(gridData);
		
        /*
         * 削除対象外の期間
         */
		this.m_maintenance_keep = new MaintenanceKeepListComposite(parent, SWT.NONE, true);
		gridData = new GridData();
		gridData.horizontalSpan = 15;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		m_maintenance_keep.setLayoutData(gridData);		

        /*
         * カレンダ
         */
		this.m_calendarId = new CalendarIdListComposite(parent, SWT.NONE, true);
		gridData = new GridData();
		gridData.horizontalSpan = 15;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		m_calendarId.setLayoutData(gridData);
		
        label = new Label(parent, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        
        /*
         * スケジュール
         */
		//ラベル
        label = new Label(parent, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("schedule") + " : ");	
		
		
        Group group1 = new Group(parent, SWT.NONE);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 20;
        group1.setLayout(layout);
//        group1.setText(Messages.getString("schedule"));
		gridData = new GridData();
		gridData.horizontalSpan = 15;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
        group1.setLayoutData(gridData);

        createType1(group1);
        createType2(group1);
       
        
        
   		/*
         * 通知情報の属性グループ
         */
        // ラベル
        label = new Label(parent, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("notify.attribute") + " : ");
        
        // グループ
        Group groupNotifyAttribute = new Group(parent, SWT.NONE);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 1;
        groupNotifyAttribute.setLayout(layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        groupNotifyAttribute.setLayoutData(gridData);
        
        // 通知情報（通知ID，アプリケーションID）
		this.notifyInfo = new NotifyInfoComposite(groupNotifyAttribute, SWT.NONE);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		notifyInfo.setLayoutData(gridData);


	     /*
         * 有効／無効
         */
        this.confirmValid = new Button(parent, SWT.CHECK);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.confirmValid.setLayoutData(gridData);
        this.confirmValid.setText(Messages.getString("setting.valid.confirmed"));
        this.confirmValid.setSelection(true);

        // ラインを引く
        Label line = new Label(parent, SWT.SEPARATOR | SWT.HORIZONTAL);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 15;
        line.setLayoutData(gridData);

        // サイズを最適化
        // グリッドレイアウトを用いた場合、こうしないと横幅が画面いっぱいになります。
        shell.pack();
        shell.setSize(new Point(550, shell.getSize().y));

        // 画面中央に
        Display display = shell.getDisplay();
        shell.setLocation((display.getBounds().width - shell.getSize().x) / 2,
                (display.getBounds().height - shell.getSize().y) / 2);
        
        
        //最後に変更であれば情報を表示する
        MaintenanceInfoDataImp info = null; 
        if(this.maintenanceId != null){
        	info = new GetMaintenance().getMaintenanceInfo(this.maintenanceId);
        	this.setInputData(info);
        }
        
        this.reflectScheduleInfo();
    }

    /**
     * スケジュール日時指定を生成します。
     * 
     * @param parent 親グループ
     */
    protected void createType1(Group parent) {
        m_type1 = new Button(parent, SWT.RADIO);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        m_type1.setLayoutData(gridData);
        m_type1.addSelectionListener(new SelectionListener() {
            public void widgetSelected(SelectionEvent e) {
                Button check = (Button) e.getSource();
                if (check.getSelection()) {
                    m_type2.setSelection(false);
                    m_comboMonth.setEnabled(true);
                    m_comboDay.setEnabled(true);
                    m_comboHours1.setEnabled(true);
                    m_comboMinutes1.setEnabled(true);
                    m_comboDayOfWeek.setEnabled(false);
                    m_comboHours2.setEnabled(false);
                    m_comboMinutes2.setEnabled(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {

            }
        });

        m_comboMonth = new Combo(parent, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        m_comboMonth.setLayoutData(gridData);
        m_comboMonth.setTextLimit(2);
        m_comboMonth.setVisibleItemCount(10);
        m_comboMonth.addKeyListener(new NumberKeyListener());
        m_comboMonth.addModifyListener(new ComboModifyListener());
        DecimalFormat format = new DecimalFormat("00");
        m_comboMonth.add("");
        for (int month = 1; month <= 12; month++) {
            m_comboMonth.add(format.format(month));
        }

        Label labelMonth = new Label(parent, SWT.NONE);
        labelMonth.setText(Messages.getString("month"));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        labelMonth.setLayoutData(gridData);

        m_comboDay = new Combo(parent, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        m_comboDay.setLayoutData(gridData);
        m_comboDay.setTextLimit(2);
        m_comboDay.setVisibleItemCount(10);
        m_comboDay.addKeyListener(new NumberKeyListener());
        m_comboDay.addModifyListener(new ComboModifyListener());
        format = new DecimalFormat("00");
        m_comboDay.add("");
        for (int day = 1; day <= 31; day++) {
            m_comboDay.add(format.format(day));
        }

        Label labelDay = new Label(parent, SWT.NONE);
        labelDay.setText(Messages.getString("monthday"));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        labelDay.setLayoutData(gridData);

        m_comboHours1 = new Combo(parent, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        m_comboHours1.setLayoutData(gridData);
        m_comboHours1.setTextLimit(2);
        m_comboHours1.setVisibleItemCount(10);
        m_comboHours1.addKeyListener(new NumberKeyListener());
        m_comboHours1.addModifyListener(new ComboModifyListener());
        format = new DecimalFormat("00");
        m_comboHours1.add("");
        for (int hour = 0; hour < 24; hour++) {
            m_comboHours1.add(format.format(hour));
        }

        Label labelHours = new Label(parent, SWT.NONE);
        labelHours.setText(Messages.getString("hour"));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        labelHours.setLayoutData(gridData);

        m_comboMinutes1 = new Combo(parent, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        m_comboMinutes1.setLayoutData(gridData);
        m_comboMinutes1.setTextLimit(2);
        m_comboMinutes1.setVisibleItemCount(10);
        m_comboMinutes1.addKeyListener(new NumberKeyListener());
        m_comboMinutes1.addModifyListener(new ComboModifyListener());
        format = new DecimalFormat("00");
        m_comboMinutes1.add("");
        for (int minutes = 0; minutes < 60; minutes++) {
            m_comboMinutes1.add(format.format(minutes));
        }

        Label labelMinutes = new Label(parent, SWT.NONE);
        labelMinutes.setText(Messages.getString("minute"));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        labelMinutes.setLayoutData(gridData);
        
        // 空白
        Label label = new Label(parent, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
    }

    /**
     * スケジュール曜日指定を生成します。
     * 
     * @param parent 親グループ
     */
    protected void createType2(Group parent) {
        m_type2 = new Button(parent, SWT.RADIO);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        m_type2.setLayoutData(gridData);
        m_type2.addSelectionListener(new SelectionListener() {
            public void widgetSelected(SelectionEvent e) {
                Button check = (Button) e.getSource();
                if (check.getSelection()) {
                    m_type1.setSelection(false);
                    m_comboMonth.setEnabled(false);
                    m_comboDay.setEnabled(false);
                    m_comboHours1.setEnabled(false);
                    m_comboMinutes1.setEnabled(false);
                    m_comboDayOfWeek.setEnabled(true);
                    m_comboHours2.setEnabled(true);
                    m_comboMinutes2.setEnabled(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {

            }
        });

        Label labelDayOfWeek = new Label(parent, SWT.NONE);
        labelDayOfWeek.setText(Messages.getString("weekday"));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        labelDayOfWeek.setLayoutData(gridData);

        m_comboDayOfWeek = new Combo(parent, SWT.READ_ONLY);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 4;
        m_comboDayOfWeek.setLayoutData(gridData);
        m_comboDayOfWeek.setTextLimit(3);
        m_comboDayOfWeek.setVisibleItemCount(10);
        m_comboDayOfWeek.add(DayOfWeekConstant.STRING_SUNDAY);
        m_comboDayOfWeek.add(DayOfWeekConstant.STRING_MONDAY);
        m_comboDayOfWeek.add(DayOfWeekConstant.STRING_TUESDAY);
        m_comboDayOfWeek.add(DayOfWeekConstant.STRING_WEDNESDAY);
        m_comboDayOfWeek.add(DayOfWeekConstant.STRING_THURSDAY);
        m_comboDayOfWeek.add(DayOfWeekConstant.STRING_FRIDAY);
        m_comboDayOfWeek.add(DayOfWeekConstant.STRING_SATURDAY);

        Label labelDummy = new Label(parent, SWT.NONE);
        labelDummy.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        labelDummy.setLayoutData(gridData);

        m_comboHours2 = new Combo(parent, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        m_comboHours2.setLayoutData(gridData);
        m_comboHours2.setTextLimit(2);
        m_comboHours2.setVisibleItemCount(10);
        m_comboHours2.addKeyListener(new NumberKeyListener());
        m_comboHours2.addModifyListener(new ComboModifyListener());
        DecimalFormat format = new DecimalFormat("00");
        m_comboHours2.add("");
        for (int hour = 0; hour < 24; hour++) {
            m_comboHours2.add(format.format(hour));
        }

        Label labelHours = new Label(parent, SWT.NONE);
        labelHours.setText(Messages.getString("hour"));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        labelHours.setLayoutData(gridData);

        m_comboMinutes2 = new Combo(parent, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        m_comboMinutes2.setLayoutData(gridData);
        m_comboMinutes2.setTextLimit(2);
        m_comboMinutes2.setVisibleItemCount(10);
        m_comboMinutes2.addKeyListener(new NumberKeyListener());
        m_comboMinutes2.addModifyListener(new ComboModifyListener());
        format = new DecimalFormat("00");
        m_comboMinutes2.add("");
        for (int minutes = 0; minutes < 60; minutes++) {
            m_comboMinutes2.add(format.format(minutes));
        }

        Label labelMinutes = new Label(parent, SWT.NONE);
        labelMinutes.setText(Messages.getString("minute"));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        labelMinutes.setLayoutData(gridData);
        
        // 空白
        Label label = new Label(parent, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
    }

    /**
     * スケジュール情報を設定します。
     * 
     * @param info スケジュール情報
     */
    public void setSchedule(ArrayList info) {
        m_schedule = info;
    }

    /**
     * スケジュール情報を返します。
     * 
     * @return スケジュール情報
     */
    public ArrayList getSchedule() {
        return m_schedule;
    }

    /**
     * ダイアログにスケジュール情報を反映します。
     * 
     * @see com.clustercontrol.jobmanagement.bean.ScheduleTableDefine
     */
    protected void reflectScheduleInfo() {

        if (m_schedule instanceof ArrayList) {
            //スケジュールID設定
//            String scheduleId = (String) m_schedule
//                    .get(ScheduleTableDefine.SCHE_ID);
//            m_scheduleId.setText(scheduleId);
//
//            //スケジュール名設定
//            String scheduleName = (String) m_schedule
//                    .get(ScheduleTableDefine.SCHE_NAME);
//            m_scheduleName.setText(scheduleName);
//
//            //ジョブID設定
//            String jobId = (String) m_schedule.get(ScheduleTableDefine.JOB_ID);
//            m_jobId.setText(jobId);
//
//            //ジョブ名設定
//            String jobName = (String) m_schedule
//                    .get(ScheduleTableDefine.JOB_NAME);
//            m_jobName.setText(jobName);
//
//            //カレンダID
//            String calendarId = (String) m_schedule.get(ScheduleTableDefine.CALENDAR_ID);
//            if (calendarId != null && calendarId.length() > 0) {
//            	m_calendarId.select(0);
//                for (int i = 0; i < m_calendarId.getItemCount(); i++) {
//                    if (calendarId.equals(m_calendarId.getItem(i))) {
//                    	m_calendarId.select(i);
//                        break;
//                    }
//                }
//            }
//
//            //スケジュール設定
//            Schedule schedule = null;
//			try {
//				schedule = new SelectSchedule().getSchedule(maintenanceId);
//			} catch (NamingException e) {
//				e.printStackTrace();
//			} catch (SchedulerException e) {
//				e.printStackTrace();
//			} 
            //スケジュール設定
            Schedule schedule = (Schedule) m_schedule
                    .get(ScheduleTableDefine.SCHEDULE);
            
//            System.out.println("schedule string : " + schedule.getDate());
            
            //日時を設定
           	if (schedule.getDate() instanceof Date) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(schedule.getDate());

                DecimalFormat format = new DecimalFormat("00");
                //月を設定
                m_comboMonth.select(0);
                for (int i = 0; i < m_comboMonth.getItemCount(); i++) {
                    String month = format
                            .format(calendar.get(Calendar.MONTH) + 1);
                    if (month.equals(m_comboMonth.getItem(i))) {
                        m_comboMonth.select(i);
                        break;
                    }
                }
                //日を設定
                m_comboDay.select(0);
                for (int i = 0; i < m_comboDay.getItemCount(); i++) {
                    String day = format.format(calendar
                            .get(Calendar.DAY_OF_MONTH));
                    if (day.equals(m_comboDay.getItem(i))) {
                        m_comboDay.select(i);
                        break;
                    }
                }
                //時を設定
                m_comboHours1.select(0);
                for (int i = 0; i < m_comboHours1.getItemCount(); i++) {
                    String hours = format.format(calendar
                            .get(Calendar.HOUR_OF_DAY));
                    if (hours.equals(m_comboHours1.getItem(i))) {
                        m_comboHours1.select(i);
                        m_comboHours2.select(i);
                        break;
                    }
                }
                //分を設定
                m_comboMinutes1.select(0);
                for (int i = 0; i < m_comboMinutes1.getItemCount(); i++) {
                    String minutes = format.format(calendar
                            .get(Calendar.MINUTE));
                    if (minutes.equals(m_comboMinutes1.getItem(i))) {
                        m_comboMinutes1.select(i);
                        m_comboMinutes2.select(i);
                        break;
                    }
                }
                //曜日を設定
                m_comboDayOfWeek.select(0);
                for (int i = 0; i < m_comboDayOfWeek.getItemCount(); i++) {
                    String dayOfWeek = DayOfWeekConstant.typeToString(schedule
                            .getDayOfWeek());
                    if (dayOfWeek.equals(m_comboDayOfWeek.getItem(i))) {
                        m_comboDayOfWeek.select(i);
                        break;
                    }
                }
            }

            m_comboMonth.setEnabled(true);
            m_comboDay.setEnabled(true);
            m_comboHours1.setEnabled(true);
            m_comboMinutes1.setEnabled(true);
            m_comboDayOfWeek.setEnabled(false);
            m_comboHours2.setEnabled(false);
            m_comboMinutes2.setEnabled(false);

            //指定方式を設定
            if (schedule.getType() == ScheduleConstant.TYPE_EVERY_YEAR) {
                m_type1.setSelection(true);
            } else if (schedule.getType() == ScheduleConstant.TYPE_EVERY_MONTH) {
                m_type1.setSelection(true);
                m_comboMonth.select(0);
            } else if (schedule.getType() == ScheduleConstant.TYPE_EVERY_DAY) {
                m_type1.setSelection(true);
                m_comboMonth.select(0);
                m_comboDay.select(0);
            } else if (schedule.getType() == ScheduleConstant.TYPE_EVERY_HOUR) {
                m_type1.setSelection(true);
                m_comboMonth.select(0);
                m_comboDay.select(0);
                m_comboHours1.select(0);
            } else if (schedule.getType() == ScheduleConstant.TYPE_EVERY_WEEK) {
                m_type2.setSelection(true);
                m_comboMonth.select(0);
                m_comboDay.select(0);

                m_comboMonth.setEnabled(false);
                m_comboDay.setEnabled(false);
                m_comboHours1.setEnabled(false);
                m_comboMinutes1.setEnabled(false);
                m_comboDayOfWeek.setEnabled(true);
                m_comboHours2.setEnabled(true);
                m_comboMinutes2.setEnabled(true);
            }

//            //有効/無効設定
//            Integer effective = (Integer) m_schedule
//                    .get(ScheduleTableDefine.VALID);
//            if (effective.intValue() == ValidConstant.TYPE_VALID) {
//                m_valid.setSelection(true);
//                m_invalid.setSelection(false);
//            } else {
//                m_valid.setSelection(false);
//                m_invalid.setSelection(true);
//            }
        } else {
            m_type1.setSelection(true);
            m_comboMonth.setEnabled(true);
            m_comboDay.setEnabled(true);
            m_comboHours1.setEnabled(true);
            m_comboMinutes1.setEnabled(true);
            m_comboDayOfWeek.setEnabled(false);
            m_comboHours2.setEnabled(false);
            m_comboMinutes2.setEnabled(false);
        }
    }

    /**
     * ダイアログの情報からスケジュール情報を作成します。
     * 
     * @return 入力値の検証結果
     * 
     * @see com.clustercontrol.jobmanagement.bean.ScheduleTableDefine
     */
    protected ValidateResult createMaintenanceInfo() {
    	ValidateResult result = null;
    	
//    	MaintenanceInfoDataImp maintenanceInfo = new MaintenanceInfoDataImp();
    	maintenanceInfo = new MaintenanceInfoDataImp();
//    	ScheduleInfo scheduleInfo = new ScheduleInfo();
    	scheduleInfo = new ScheduleInfo();    	
        
        //FIXME メンテナンスID,説明をそれぞれ使用する
        //メンテナンスID取得
        if (m_textMaintenanceId.getText().length() > 0) {
        	maintenanceInfo.setMaintenance_id(m_textMaintenanceId.getText());
            scheduleInfo.setId(m_textMaintenanceId.getText());
        } else {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString("message.hinemos.1"));
            result.setMessage(Messages.getString("message.maintenance.9"));
            return result;
        }

        //説明取得
        if (m_textDescription.getText().length() > 0) {
        	maintenanceInfo.setDescription(m_textDescription.getText());
            scheduleInfo.setName(m_textDescription.getText());
        } else {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString("message.hinemos.1"));
            result.setMessage(Messages.getString("message.maintenance.10"));
            return result;
        }

        //ジョブID取得
        if (m_textMaintenanceId.getText().length() > 0) {
            scheduleInfo.setJobId(m_textMaintenanceId.getText());
        } else {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString("message.hinemos.1"));
            result.setMessage(Messages.getString("message.maintenance.9"));
            return result;
        }

        //ジョブ名取得
        if (m_textDescription.getText().length() > 0) {
            scheduleInfo.setJobName(m_textDescription.getText());
        } else {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString("message.hinemos.1"));
            result.setMessage(Messages.getString("message.maintenance.10"));
            return result;
        }
        
        //種別
        maintenanceInfo.setType_id(MaintenanceTypeMstConstant.indexToTypeId(m_maintenance_type.getIndex()));
        
        //削除対象外となる期間を指定
        maintenanceInfo.setKeep_id(MaintenanceKeepMstConstant.indexToKeepId(m_maintenance_keep.getIndex()));        
        
        //カレンダID
//        System.out.println(m_calendarId.getText().length());
        if (m_calendarId.getText().length() > 0) {
        	maintenanceInfo.setCalendar_id(m_calendarId.getText());
        	scheduleInfo.setCalendarId(m_calendarId.getText());
        }
        else{
        	maintenanceInfo.setCalendar_id("");
        	scheduleInfo.setCalendarId("");
        }

        //条件設定
        Schedule schedule = new Schedule();
        Integer month = null;
        Integer day = null;
        Integer hours = null;
        Integer minutes = null;
        Integer week = null;
//        System.out.println(m_type1.getSelection());
        if (m_type1.getSelection()) {
            //月を取得
            if (m_comboMonth.getText().length() > 0) {
                month = new Integer(m_comboMonth.getText());
            }
            //日を取得
            if (m_comboDay.getText().length() > 0) {
                day = new Integer(m_comboDay.getText());
            }
            //時を取得
            if (m_comboHours1.getText().length() > 0) {
                hours = new Integer(m_comboHours1.getText());
            }
            //分を取得
            if (m_comboMinutes1.getText().length() > 0) {
                minutes = new Integer(m_comboMinutes1.getText());
            }

            //スケジュール種別ごとにチェック
            if (m_comboMonth.getText().length() == 0
                    && m_comboDay.getText().length() == 0
                    && m_comboHours1.getText().length() == 0) {
                //スケジュール種別に毎時を設定
                schedule.setType(ScheduleConstant.TYPE_EVERY_HOUR);
            } else if (m_comboMonth.getText().length() == 0
                    && m_comboDay.getText().length() == 0) {
                //スケジュール種別に毎日を設定
                schedule.setType(ScheduleConstant.TYPE_EVERY_DAY);
            } else if (m_comboMonth.getText().length() == 0) {
                //スケジュール種別に毎月を設定
                schedule.setType(ScheduleConstant.TYPE_EVERY_MONTH);
            } else {
                //スケジュール種別に毎年を設定
                schedule.setType(ScheduleConstant.TYPE_EVERY_YEAR);
            }

            if (!(month instanceof Integer)) {
                if (schedule.getType() == ScheduleConstant.TYPE_EVERY_YEAR) {
                    result = new ValidateResult();
                    result.setValid(false);
                    result.setID(Messages.getString("message.hinemos.1"));
                    result.setMessage(Messages.getString("message.job.26"));
                    return result;
                }
            }
            if (!(day instanceof Integer)) {
                if (schedule.getType() == ScheduleConstant.TYPE_EVERY_YEAR
                        || schedule.getType() == ScheduleConstant.TYPE_EVERY_MONTH) {
                    result = new ValidateResult();
                    result.setValid(false);
                    result.setID(Messages.getString("message.hinemos.1"));
                    result.setMessage(Messages.getString("message.job.27"));
                    return result;
                }
            }
            if (!(hours instanceof Integer)) {
                if (schedule.getType() == ScheduleConstant.TYPE_EVERY_YEAR
                        || schedule.getType() == ScheduleConstant.TYPE_EVERY_MONTH
                        || schedule.getType() == ScheduleConstant.TYPE_EVERY_DAY) {
                    result = new ValidateResult();
                    result.setValid(false);
                    result.setID(Messages.getString("message.hinemos.1"));
                    result.setMessage(Messages.getString("message.job.28"));
                    return result;
                }
            }
            if (!(minutes instanceof Integer)) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString("message.hinemos.1"));
                result.setMessage(Messages.getString("message.job.29"));
                return result;
            }
        } else if (m_type2.getSelection()) {
            schedule.setType(ScheduleConstant.TYPE_EVERY_WEEK);

            //曜日を取得
            if (m_comboDayOfWeek.getText().length() > 0) {
                week = new Integer(DayOfWeekConstant
                        .stringToType(m_comboDayOfWeek.getText()));
            }
            //時を取得
            if (m_comboHours2.getText().length() > 0) {
                hours = new Integer(m_comboHours2.getText());
            }
            //分を取得
            if (m_comboMinutes2.getText().length() > 0) {
                minutes = new Integer(m_comboMinutes2.getText());
            }

            if (!(week instanceof Integer)) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString("message.hinemos.1"));
                result.setMessage(Messages.getString("message.job.37"));
                return result;
            }
            if (!(hours instanceof Integer)) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString("message.hinemos.1"));
                result.setMessage(Messages.getString("message.job.28"));
                return result;
            }
            if (!(minutes instanceof Integer)) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString("message.hinemos.1"));
                result.setMessage(Messages.getString("message.job.29"));
                return result;
            }
        }

        //日時を設定
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.YEAR, 0);
        if (month instanceof Integer) {
            calendar.set(Calendar.MONTH, month.intValue() - 1);
        }
        if (day instanceof Integer) {
            calendar.set(Calendar.DAY_OF_MONTH, day.intValue());
        }
        if (hours instanceof Integer) {
            calendar.set(Calendar.HOUR_OF_DAY, hours.intValue());
        }
        if (week instanceof Integer) {
            calendar.set(Calendar.DAY_OF_WEEK, week.intValue());
            schedule.setDayOfWeek(week.intValue());
        }
        calendar.set(Calendar.MINUTE, minutes.intValue());
        calendar.set(Calendar.SECOND, 0);
        schedule.setDate(calendar.getTime());
        scheduleInfo.setSchedule(schedule);
        
        maintenanceInfo.setSchedule_date(new Timestamp(schedule.getDate().getTime()));


        //通知関連情報の設定
        //通知グループIDの設定
        maintenanceInfo.setNotifyGroupId(NotifyRelationInfo.createNotifyGroupIdMaintenance(maintenanceInfo.getMaintenance_id()));
  
        
        //通知情報へのNotifyGroupIdのセット
        this.notifyInfo.setNotifyGroupId(maintenanceInfo.getNotifyGroupId());
        //コンポジットから通知情報を取得します。
        maintenanceInfo.setNotifyId(this.notifyInfo.getNotify());
        
        //アプリケーションを取得
        if(maintenanceInfo.getNotifyId() != null && maintenanceInfo.getNotifyId().size() != 0) {
        	if(notifyInfo.getApplication() == null || notifyInfo.getApplication().equals("")){
	        	result = new ValidateResult();
	            result.setValid(false);
	            result.setID(Messages.getString("message.hinemos.1"));
	            result.setMessage(Messages.getString("message.monitor.10"));
	            return result;
        	}
        }
        maintenanceInfo.setApplication(notifyInfo.getApplication());
        
        
        //有効/無効取得
        if (confirmValid.getSelection()) {
        	maintenanceInfo.setValid_flg(ValidConstant.TYPE_VALID);
        	scheduleInfo.setValid(ValidConstant.TYPE_VALID);
        } else {
        	maintenanceInfo.setValid_flg(ValidConstant.TYPE_INVALID);
            scheduleInfo.setValid(ValidConstant.TYPE_INVALID);
        }

        if (result == null) {
            if (m_schedule instanceof ArrayList) {
                //登録者、登録日時、更新日時を設定

                maintenanceInfo.setRegUser((String) m_schedule
                        .get(ScheduleTableDefine.CREATE_USER));
                maintenanceInfo.setRegDate(new Timestamp(((Date) m_schedule.get(ScheduleTableDefine.CREATE_TIME)).getTime()));
            	
//                maintenanceInfo.setUpdateDate((Timestamp) m_schedule
//                        .get(MaintenanceTableDefine.UPDATE_TIME));

                scheduleInfo.setCreateUser((String) m_schedule
                        .get(ScheduleTableDefine.CREATE_USER));
                scheduleInfo.setCreateTime((Date) m_schedule.get(ScheduleTableDefine.CREATE_TIME));
            	
//                scheduleInfo.setUpdateTime((Date) m_schedule
//                        .get(MaintenanceTableDefine.UPDATE_TIME));

//                ModifyMaintenance update = new ModifyMaintenance();
//                update.modify(maintenanceInfo, scheduleInfo);
            } else {
//                AddMaintenance add = new AddMaintenance();
//                add.add(maintenanceInfo, scheduleInfo);
            }
        }

        return result;
    }
    
    protected MaintenanceInfoDataImp getMaintenanceInfo() {
    	return maintenanceInfo;
    }
    
    protected ScheduleInfo getScheduleInfo() {
    	return scheduleInfo;
    }
    
    protected void setInputData(MaintenanceInfoDataImp info) {
 
		if (info.getMaintenance_id() != null) {
			this.maintenanceId = info.getMaintenance_id();
			this.m_textMaintenanceId.setText(this.maintenanceId);
		}
		
		if (info.getDescription() != null) {
			this.m_textDescription.setText(info.getDescription());
		}
		
		if (info.getKeep_id() != null) {
			this.m_maintenance_keep.setText(Messages.getString(MaintenanceKeepMstConstant.keepIdToNameId(info.getKeep_id())));
		}

		if (info.getCalendar_id() != null) {
			this.m_calendarId.setText(info.getCalendar_id());
		}
		
		if (info.getType_id() != null) {
			this.m_maintenance_type.setText(Messages.getString(MaintenanceTypeMstConstant.typeIdToNameId(info.getType_id())));
		}
		
		if (info.getSchedule_date() != null) {
			this.scheduleDate = (Date)info.getSchedule_date();
		}
	    //通知情報の設定
        if(info.getNotifyId() != null)
        this.notifyInfo.setNotify(info.getNotifyId());

		
		if (info.getApplication() != null) {
			this.notifyInfo.setApplication(info.getApplication());
		}
		
		if (info.getValid_flg() != null) {
			this.confirmValid.setSelection(ValidConstant.typeToBoolean(info.getValid_flg().intValue()));
		}

    	
    }

    /**
     * ＯＫボタンテキスト取得
     * 
     * @return ＯＫボタンのテキスト
     */
    protected String getOkButtonText() {
        return Messages.getString("ok");
    }

    /**
     * キャンセルボタンテキスト取得
     * 
     * @return キャンセルボタンのテキスト
     */
    protected String getCancelButtonText() {
        return Messages.getString("cancel");
    }

    /**
     * 入力値を保持したプロパティを返します。<BR>
     * プロパティオブジェクトのコピーを返します。
     * 
     * @return プロパティ
     * 
     * @see com.clustercontrol.util.PropertyUtil#copy(Property)
     */
    protected ValidateResult validate() {
        ValidateResult result = null;

        result = createMaintenanceInfo();
        if (result != null) {
            return result;
        }

        return null;
    }
    
    /**
     * 入力値をマネージャに登録します。
     * 
     * @return true：正常、false：異常
     * 
     * @see com.clustercontrol.dialog.CommonDialog#action()
     */
    protected boolean action() {
    	boolean result = false;
    	
    	if(this.maintenanceInfo != null && this.scheduleInfo != null){
            if(this.maintenanceId == null){
            	// 作成の場合
            	result = new AddMaintenance().add(maintenanceInfo, scheduleInfo);
            }
            else{
            	// 変更の場合
            	result = new ModifyMaintenance().modify(maintenanceInfo, scheduleInfo);
            }
    	}
    	
    	return result;
    }
}