/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.logtransfer.factory;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;

import javax.ejb.CreateException;
import javax.jms.JMSException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.accesscontrol.factory.AccessLock;
import com.clustercontrol.logtransfer.bean.LogTransferFileInfo;
import com.clustercontrol.logtransfer.bean.LogTransferInfo;
import com.clustercontrol.logtransfer.bean.QueueConstant;
import com.clustercontrol.logtransfer.ejb.entity.LogTransferFileInfoLocal;
import com.clustercontrol.logtransfer.ejb.entity.LogTransferFileInfoUtil;
import com.clustercontrol.logtransfer.ejb.entity.LogTransferInfoLocal;
import com.clustercontrol.logtransfer.ejb.entity.LogTransferInfoUtil;
import com.clustercontrol.commons.util.SendQueue;
import com.clustercontrol.util.apllog.AplLogger;

/**
 * ログ転送情報をマネージャに登録するクラス<BR>
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class AddLogTransfer {
	
	protected static Log m_log = LogFactory.getLog( AddLogTransfer.class );
	
	/**
	 * ログ転送情報を登録
	 * 
	 * @param info ログ転送情報
	 * @param user ユーザ
	 * @return
	 * @throws CreateException
	 * @throws NamingException
	 */
	@SuppressWarnings("unchecked")
	public boolean add(LogTransferInfo info, String user) throws CreateException, NamingException {
		//アクセスロック
		AccessLock.lock(AccessLock.LOG_TRANSFER);
		
		try 
		{
			Timestamp now = new Timestamp(new Date().getTime());
			
			// ログ転送情報を挿入
			LogTransferInfoLocal logTransfer = LogTransferInfoUtil.getLocalHome().create(
					info.getTransferId(),
					info.getDescription(),
					info.getFacilityId(),
					Integer.valueOf(info.getValid()),
					now,
					now,
					user,
					user
			);
			Collection ct = logTransfer.getLogTransferFileInfo();
			
			ArrayList<LogTransferFileInfo> fileList = info.getFileInfo();
			ArrayList<LogTransferFileInfoLocal> fileLocalList = new ArrayList<LogTransferFileInfoLocal>();
			
			// 転送対象ログファイル情報を挿入
			LogTransferFileInfo file = null;
			for(int index=0; index<fileList.size(); index++){
				file = (LogTransferFileInfo)fileList.get(index);
				if(file != null){
					LogTransferFileInfoLocal local = LogTransferFileInfoUtil.getLocalHome().create(
							info.getTransferId(),
							file.getFilePath(),
							Integer.valueOf(file.getRunInterval()),
							Integer.valueOf(file.getExistenceFlg()),
							Integer.valueOf(file.getValid()));
					fileLocalList.add(local);
				}
			}
			if(fileLocalList != null){
				ct.addAll(fileLocalList);
				logTransfer.setLogTransferFileInfo(ct);
			}
			
			SendQueue queue = null;
			
			try {
				// 転送対象ログファイル管理Queueへ通知
				queue = new SendQueue(QueueConstant.QUEUE_NAME_FILE_MANAGE);
				queue.put(info);
				
			} catch (Exception e) {
				m_log.debug("add() : 登録情報送信エラー : " + e.getMessage());
				
			} finally {
				if (queue != null) {
					try {
						queue.terminate();
					} catch (JMSException e) {
						m_log.error("Terminate SendQueue Failed : " + e.getMessage());
					}
				}
			}
			
		} catch (CreateException e) {
			AplLogger apllog = new AplLogger("TRANSFER", "logTransfer");
			String[] args = { info.getTransferId() };
			apllog.put("SYS", "001", args);
			m_log.debug("add():" + e.getMessage());
			throw e;
		} catch (NamingException e) {
			AplLogger apllog = new AplLogger("TRANSFER", "logTransfer");
			String[] args = { info.getTransferId() };
			apllog.put("SYS", "001", args);
			m_log.debug("add():" + e.getMessage());
			throw e;
		}
		
		return true;
	}
	
}
