/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.calendar.factory;

import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import com.clustercontrol.bean.DataRangeConstant;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyConstant;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.calendar.ejb.entity.CalendarAddInfoLocal;
import com.clustercontrol.calendar.ejb.entity.CalendarAddInfoPK;
import com.clustercontrol.calendar.ejb.entity.CalendarAddInfoUtil;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;

/**
 * カレンダ追加情報用プロパティ作成クラス<BR>
 *
 * @version 2.0.0
 * @since 2.0.0
 */
public class AddProperty {
	/** 時間帯(From) */
	public static final String TIME_FROM = "timeFrom";
	/** 時間帯(To) */
	public static final String TIME_TO = "timeTo";
	/** 実行 */
	public static final String EXECUTE = "execute";
	/** 説明 */
	public static final String DESCRIPTION = "description";
	/** 作成日時 */
	public static final String CREATE_TIME = "createTimestamp";
	/** 作成者 */
	public static final String CREATOR_NAME = "creatorName";
	/** 更新者 */
	public static final String MODIFIER_NAME = "ModifierName";
	/** 更新日時 */
	public static final String MODIFY_TIME = "ModifyTime";
	
	/**
	 * カレンダ追加情報用プロパティを取得します。<BR>
	 * 
	 * @param id
	 * @param from
	 * @param to
	 * @param mode
	 * @param locale
	 * @return カレンダ追加情報用プロパティ
	 * @throws FinderException
	 * @throws NamingException
	 * @throws FinderException
	 * @throws NamingException
	 */
	public Property getProperty(String id, Date from, Date to, int mode, Locale locale) throws FinderException, NamingException {
		Property property = getProperty(mode, locale);
		
		if(mode == PropertyConstant.MODE_MODIFY){
		    //カレンダ曜日別情報を取得
			CalendarAddInfoLocal info = 
				CalendarAddInfoUtil.getLocalHome().findByPrimaryKey(
						new CalendarAddInfoPK(id, from, to));
			
			if(info != null){
				//時間帯(From)
				ArrayList propertyList = PropertyUtil.getProperty(property, TIME_FROM);
				((Property)propertyList.get(0)).setValue(info.getTime_from());
				//時間帯(To)
				propertyList = PropertyUtil.getProperty(property, TIME_TO);
				((Property)propertyList.get(0)).setValue(info.getTime_to());
				//実行
				propertyList = PropertyUtil.getProperty(property, EXECUTE);
				((Property)propertyList.get(0)).setValue(Boolean.valueOf(ValidConstant.typeToBoolean(info.getExecute_flg().intValue())));
				//説明
				propertyList = PropertyUtil.getProperty(property, DESCRIPTION);
				if(info.getDescription() != null && info.getDescription().compareTo("") != 0){
					((Property)propertyList.get(0)).setValue(info.getDescription());
				}
				//登録者
				propertyList = PropertyUtil.getProperty(property, CREATOR_NAME);
				if(info.getReg_user() != null && info.getReg_user().compareTo("") != 0){
					((Property)propertyList.get(0)).setValue(info.getReg_user());
				}
				//登録日時
				propertyList = PropertyUtil.getProperty(property, CREATE_TIME);
				if(info.getReg_date() != null){
					((Property)propertyList.get(0)).setValue(info.getReg_date());
				}
				//更新者
				propertyList = PropertyUtil.getProperty(property, MODIFIER_NAME);
				if(info.getUpdate_user() != null && info.getUpdate_user().compareTo("") != 0){
					((Property)propertyList.get(0)).setValue(info.getUpdate_user());
				}
				//更新日時
				propertyList = PropertyUtil.getProperty(property, MODIFY_TIME);
				if(info.getUpdate_date() != null){
					((Property)propertyList.get(0)).setValue(info.getUpdate_date());
				}
			}
		}
		
		return property;
	}
	
	/**
	 * カレンダ追加情報用プロパティを取得します。<BR>
	 * 
	 * @param mode
	 * @return カレンダ追加情報用プロパティ
	 */
	public Property getProperty(int mode, Locale locale) {
		//時間帯(From)
		Property timeFrom =
			new Property(TIME_FROM, Messages.getString("time", locale) + "(" + Messages.getString("start", locale) + ")", 
					PropertyConstant.EDITOR_DATETIME);
		//時間帯(To)
		Property timeTo =
			new Property(TIME_TO, Messages.getString("time", locale) + "(" + Messages.getString("end", locale) + ")"
					, PropertyConstant.EDITOR_DATETIME);
	    //実行
		Property execute =
			new Property(EXECUTE, Messages.getString("run", locale), PropertyConstant.EDITOR_BOOL);
		//説明
		Property description =
			new Property(DESCRIPTION, Messages.getString("description", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_256);
		//登録日時
		Property createTime =
			new Property(CREATE_TIME, Messages.getString("create.time", locale), PropertyConstant.EDITOR_DATETIME);
		//登録者
		Property creatorName =
			new Property(CREATOR_NAME, Messages.getString("creator.name", locale), PropertyConstant.EDITOR_TEXT);
		//更新日時
		Property modifyTime =
			new Property(MODIFY_TIME, Messages.getString("update.time", locale), PropertyConstant.EDITOR_DATETIME);
		//更新者
		Property modifierName =
			new Property(MODIFIER_NAME, Messages.getString("modifier.name", locale), PropertyConstant.EDITOR_TEXT);

		//値を初期化
		timeFrom.setValue("");
		timeTo.setValue("");
		execute.setValue(Boolean.valueOf(true));
		description.setValue("");
		createTime.setValue("");
		creatorName.setValue("");
		modifyTime.setValue("");
		modifierName.setValue("");

		//モードにより、変更可及びコピー可を設定
		if(mode == PropertyConstant.MODE_ADD){
			execute.setModify(PropertyConstant.MODIFY_OK);
			timeFrom.setModify(PropertyConstant.MODIFY_OK);
			timeTo.setModify(PropertyConstant.MODIFY_OK);
			description.setModify(PropertyConstant.MODIFY_OK);
		}
		else if(mode == PropertyConstant.MODE_MODIFY){
			execute.setModify(PropertyConstant.MODIFY_OK);
			timeFrom.setModify(PropertyConstant.MODIFY_OK);
			timeTo.setModify(PropertyConstant.MODIFY_OK);
			description.setModify(PropertyConstant.MODIFY_OK);
		}
		
		Property property = new Property(null, null, "");
		
		// 初期表示ツリーを構成。
		property.removeChildren();
		property.addChildren(timeFrom);
		property.addChildren(timeTo);
		property.addChildren(execute);
		property.addChildren(description);
		property.addChildren(createTime);
		property.addChildren(creatorName);
		property.addChildren(modifyTime);
		property.addChildren(modifierName);

		return property;
	}
}
