/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.convert;

import java.util.List;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRBreak;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JREllipse;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.JRImage;
import net.sf.jasperreports.engine.JRLine;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintGraphicElement;
import net.sf.jasperreports.engine.JRRectangle;
import net.sf.jasperreports.engine.JRStaticText;
import net.sf.jasperreports.engine.JRSubreport;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.JRVisitable;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.base.JRBasePrintFrame;
import net.sf.jasperreports.engine.base.JRBasePrintRectangle;
import net.sf.jasperreports.engine.convert.ChartConverter;
import net.sf.jasperreports.engine.convert.CrosstabConverter;
import net.sf.jasperreports.engine.convert.EllipseConverter;
import net.sf.jasperreports.engine.convert.FrameConverter;
import net.sf.jasperreports.engine.convert.ImageConverter;
import net.sf.jasperreports.engine.convert.LineConverter;
import net.sf.jasperreports.engine.convert.RectangleConverter;
import net.sf.jasperreports.engine.convert.ReportConverter;
import net.sf.jasperreports.engine.convert.StaticTextConverter;
import net.sf.jasperreports.engine.convert.TextFieldConverter;

public class ConvertVisitor
implements JRVisitor {
    private ReportConverter reportConverter = null;
    private JRBasePrintFrame parentFrame = null;
    private JRPrintElement printElement = null;

    public ConvertVisitor(ReportConverter reportConverter) {
        this(reportConverter, null);
    }

    public ConvertVisitor(ReportConverter reportConverter, JRBasePrintFrame parentFrame) {
        this.reportConverter = reportConverter;
        this.parentFrame = parentFrame;
    }

    public JRPrintElement getVisitPrintElement(JRVisitable visitable) {
        if (visitable != null) {
            visitable.visit(this);
            return this.printElement;
        }
        return null;
    }

    public void visitBreak(JRBreak breakElement) {
    }

    public void visitChart(JRChart chart) {
        this.addElement(this.parentFrame, ChartConverter.getInstance().convert(this.reportConverter, chart));
    }

    public void visitCrosstab(JRCrosstab crosstab) {
        JRPrintElement printFrame = CrosstabConverter.getInstance().convert(this.reportConverter, crosstab);
        this.addElement(this.parentFrame, printFrame);
        this.addContour(this.reportConverter, this.parentFrame, printFrame);
    }

    public void visitElementGroup(JRElementGroup elementGroup) {
        List children = elementGroup.getChildren();
        if (children != null && children.size() > 0) {
            for (int i = 0; i < children.size(); ++i) {
                ((JRChild)children.get(i)).visit(this);
            }
        }
    }

    public void visitEllipse(JREllipse ellipse) {
        this.addElement(this.parentFrame, EllipseConverter.getInstance().convert(this.reportConverter, ellipse));
    }

    public void visitFrame(JRFrame frame) {
        JRPrintElement printFrame = FrameConverter.getInstance().convert(this.reportConverter, frame);
        this.addElement(this.parentFrame, printFrame);
        this.addContour(this.reportConverter, this.parentFrame, printFrame);
    }

    public void visitImage(JRImage image) {
        JRPrintElement printImage = ImageConverter.getInstance().convert(this.reportConverter, image);
        this.addElement(this.parentFrame, printImage);
        this.addContour(this.reportConverter, this.parentFrame, printImage);
    }

    public void visitLine(JRLine line) {
        this.addElement(this.parentFrame, LineConverter.getInstance().convert(this.reportConverter, line));
    }

    public void visitRectangle(JRRectangle rectangle) {
        this.addElement(this.parentFrame, RectangleConverter.getInstance().convert(this.reportConverter, rectangle));
    }

    public void visitStaticText(JRStaticText staticText) {
        JRPrintElement printText = StaticTextConverter.getInstance().convert(this.reportConverter, staticText);
        this.addElement(this.parentFrame, printText);
        this.addContour(this.reportConverter, this.parentFrame, printText);
    }

    public void visitSubreport(JRSubreport subreport) {
    }

    public void visitTextField(JRTextField textField) {
        JRPrintElement printText = TextFieldConverter.getInstance().convert(this.reportConverter, textField);
        this.addElement(this.parentFrame, printText);
        this.addContour(this.reportConverter, this.parentFrame, printText);
    }

    private void addElement(JRBasePrintFrame frame, JRPrintElement element) {
        this.printElement = element;
        if (frame != null) {
            frame.addElement(element);
        }
    }

    private void addContour(ReportConverter reportConverter, JRBasePrintFrame frame, JRPrintElement element) {
        if (frame != null) {
            JRBox box;
            boolean hasContour = false;
            JRBox jRBox = box = element instanceof JRBox ? (JRBox)((Object)element) : null;
            if (box != null && box.getTopBorder() == 0 && box.getLeftBorder() == 0 && box.getRightBorder() == 0 && box.getBottomBorder() == 0) {
                hasContour = true;
            } else {
                JRPrintGraphicElement graphicElement = element instanceof JRPrintGraphicElement ? (JRPrintGraphicElement)element : null;
                boolean bl = hasContour = graphicElement == null;
            }
            if (hasContour) {
                JRBasePrintRectangle rectangle = new JRBasePrintRectangle(reportConverter.getDefaultStyleProvider());
                rectangle.setX(element.getX());
                rectangle.setY(element.getY());
                rectangle.setWidth(element.getWidth());
                rectangle.setHeight(element.getHeight());
                rectangle.setPen((byte)5);
                rectangle.setForecolor(element.getForecolor());
                rectangle.setMode((byte)2);
                frame.addElement(rectangle);
            }
        }
    }
}

