/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.awt.font.TextAttribute;
import java.io.Serializable;
import java.util.Map;
import net.sf.jasperreports.engine.JRDefaultFontProvider;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRStyleContainer;
import net.sf.jasperreports.engine.util.JRStyleResolver;
import net.sf.jasperreports.engine.util.JRTextAttribute;

public class JRBaseFont
implements JRFont,
Serializable {
    private static final long serialVersionUID = 10200L;
    protected JRDefaultFontProvider defaultFontProvider = null;
    protected JRReportFont reportFont = null;
    protected JRStyleContainer styleContainer = null;
    protected String fontName = null;
    protected Boolean isBold = null;
    protected Boolean isItalic = null;
    protected Boolean isUnderline = null;
    protected Boolean isStrikeThrough = null;
    protected Integer fontSize = null;
    protected String pdfFontName = null;
    protected String pdfEncoding = null;
    protected Boolean isPdfEmbedded = null;

    public JRBaseFont() {
    }

    public JRBaseFont(Map attributes) {
        Boolean isPdfEmbeddedAttr;
        String pdfEncodingAttr;
        String pdfFontNameAttr;
        Object strikeThrough;
        Object underline;
        Float sizeAttr;
        Object italic;
        Object bold;
        String fontNameAttr = (String)attributes.get(TextAttribute.FAMILY);
        if (fontNameAttr != null) {
            this.setFontName(fontNameAttr);
        }
        if ((bold = attributes.get(TextAttribute.WEIGHT)) != null) {
            this.setBold(TextAttribute.WEIGHT_BOLD.equals(bold));
        }
        if ((italic = attributes.get(TextAttribute.POSTURE)) != null) {
            this.setItalic(TextAttribute.POSTURE_OBLIQUE.equals(italic));
        }
        if ((sizeAttr = (Float)attributes.get(TextAttribute.SIZE)) != null) {
            this.setFontSize(sizeAttr.intValue());
        }
        if ((underline = attributes.get(TextAttribute.UNDERLINE)) != null) {
            this.setUnderline(TextAttribute.UNDERLINE_ON.equals(underline));
        }
        if ((strikeThrough = attributes.get(TextAttribute.STRIKETHROUGH)) != null) {
            this.setStrikeThrough(TextAttribute.STRIKETHROUGH_ON.equals(strikeThrough));
        }
        if ((pdfFontNameAttr = (String)attributes.get(JRTextAttribute.PDF_FONT_NAME)) != null) {
            this.setPdfFontName(pdfFontNameAttr);
        }
        if ((pdfEncodingAttr = (String)attributes.get(JRTextAttribute.PDF_ENCODING)) != null) {
            this.setPdfEncoding(pdfEncodingAttr);
        }
        if ((isPdfEmbeddedAttr = (Boolean)attributes.get(JRTextAttribute.IS_PDF_EMBEDDED)) != null) {
            this.setPdfEmbedded(isPdfEmbeddedAttr);
        }
    }

    protected JRBaseFont(JRDefaultFontProvider defaultFontProvider) {
        this.defaultFontProvider = defaultFontProvider;
    }

    public JRBaseFont(JRDefaultFontProvider defaultFontProvider, JRReportFont reportFont, JRFont font) {
        this(defaultFontProvider, reportFont, null, font);
    }

    public JRBaseFont(JRDefaultFontProvider defaultFontProvider, JRReportFont reportFont, JRStyleContainer styleContainer, JRFont font) {
        this.defaultFontProvider = defaultFontProvider;
        this.reportFont = reportFont;
        this.styleContainer = styleContainer;
        if (font != null) {
            this.fontName = font.getOwnFontName();
            this.isBold = font.isOwnBold();
            this.isItalic = font.isOwnItalic();
            this.isUnderline = font.isOwnUnderline();
            this.isStrikeThrough = font.isOwnStrikeThrough();
            this.fontSize = font.getOwnFontSize();
            this.pdfFontName = font.getOwnPdfFontName();
            this.pdfEncoding = font.getOwnPdfEncoding();
            this.isPdfEmbedded = font.isOwnPdfEmbedded();
        }
    }

    public JRDefaultFontProvider getDefaultFontProvider() {
        return this.defaultFontProvider;
    }

    public JRDefaultStyleProvider getDefaultStyleProvider() {
        return this.styleContainer == null ? null : this.styleContainer.getDefaultStyleProvider();
    }

    public JRStyle getStyle() {
        return this.styleContainer == null ? null : this.styleContainer.getStyle();
    }

    public JRReportFont getReportFont() {
        return this.reportFont;
    }

    public void setReportFont(JRReportFont reportFont) {
        this.reportFont = reportFont;
    }

    public String getFontName() {
        return JRStyleResolver.getFontName(this);
    }

    public String getOwnFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public boolean isBold() {
        return JRStyleResolver.isBold(this);
    }

    public Boolean isOwnBold() {
        return this.isBold;
    }

    public void setBold(boolean isBold) {
        this.setBold(isBold ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setBold(Boolean isBold) {
        this.isBold = isBold;
    }

    public boolean isItalic() {
        return JRStyleResolver.isItalic(this);
    }

    public Boolean isOwnItalic() {
        return this.isItalic;
    }

    public void setItalic(boolean isItalic) {
        this.setItalic(isItalic ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setItalic(Boolean isItalic) {
        this.isItalic = isItalic;
    }

    public boolean isUnderline() {
        return JRStyleResolver.isUnderline(this);
    }

    public Boolean isOwnUnderline() {
        return this.isUnderline;
    }

    public void setUnderline(boolean isUnderline) {
        this.setUnderline(isUnderline ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setUnderline(Boolean isUnderline) {
        this.isUnderline = isUnderline;
    }

    public boolean isStrikeThrough() {
        return JRStyleResolver.isStrikeThrough(this);
    }

    public Boolean isOwnStrikeThrough() {
        return this.isStrikeThrough;
    }

    public void setStrikeThrough(boolean isStrikeThrough) {
        this.setStrikeThrough(isStrikeThrough ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setStrikeThrough(Boolean isStrikeThrough) {
        this.isStrikeThrough = isStrikeThrough;
    }

    public int getFontSize() {
        return JRStyleResolver.getFontSize(this);
    }

    public Integer getOwnFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int fontSize) {
        this.setFontSize(new Integer(fontSize));
    }

    public void setFontSize(Integer fontSize) {
        this.fontSize = fontSize;
    }

    public int getSize() {
        return this.getFontSize();
    }

    public Integer getOwnSize() {
        return this.getOwnFontSize();
    }

    public void setSize(int size) {
        this.setFontSize(size);
    }

    public void setSize(Integer size) {
        this.setFontSize(size);
    }

    public String getPdfFontName() {
        return JRStyleResolver.getPdfFontName(this);
    }

    public String getOwnPdfFontName() {
        return this.pdfFontName;
    }

    public void setPdfFontName(String pdfFontName) {
        this.pdfFontName = pdfFontName;
    }

    public String getPdfEncoding() {
        return JRStyleResolver.getPdfEncoding(this);
    }

    public String getOwnPdfEncoding() {
        return this.pdfEncoding;
    }

    public void setPdfEncoding(String pdfEncoding) {
        this.pdfEncoding = pdfEncoding;
    }

    public boolean isPdfEmbedded() {
        return JRStyleResolver.isPdfEmbedded(this);
    }

    public Boolean isOwnPdfEmbedded() {
        return this.isPdfEmbedded;
    }

    public void setPdfEmbedded(boolean isPdfEmbedded) {
        this.setPdfEmbedded(isPdfEmbedded ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setPdfEmbedded(Boolean isPdfEmbedded) {
        this.isPdfEmbedded = isPdfEmbedded;
    }

    public String getStyleNameReference() {
        return this.styleContainer == null ? null : this.styleContainer.getStyleNameReference();
    }
}

