/*
 * Decompiled with CFR 0.152.
 */
package de.imedic.webrcp;

import [Ljava.lang.String;;
import de.imedic.webrcp.AllPermissionPolicy;
import de.imedic.webrcp.ProgressDialog;
import de.imedic.webrcp.UnpackThread;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.security.Policy;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.Timer;

public class WebRCP {
    public static final String OS_WIN32 = "win32";
    public static final String OS_LINUX = "linux";
    public static final String OS_AIX = "aix";
    public static final String OS_SOLARIS = "solaris";
    public static final String OS_HPUX = "hpux";
    public static final String OS_QNX = "qnx";
    public static final String OS_MACOSX = "macosx";
    public static final String ARCH_X86 = "x86";
    public static final String ARCH_PA_RISC = "PA_RISC";
    public static final String ARCH_PPC = "ppc";
    public static final String ARCH_SPARC = "sparc";
    public static final String ARCH_X86_64 = "x86_64";
    public static final String ARCH_IA64 = "ia64";
    public static final String ARCH_IA64_32 = "ia64_32";
    public static final String WS_WIN32 = "win32";
    public static final String WS_MOTIF = "motif";
    public static final String WS_GTK = "gtk";
    public static final String WS_PHOTON = "photon";
    public static final String WS_CARBON = "carbon";
    private static final String PROP_APPNAME = "webrcp.appName";
    private static final String PROP_APPVERSION = "webrcp.appVersion";
    private static final String PROP_ARCHIVES = "webrcp.archives";
    private static final String PROP_SYSARCHIVES = "webrcp.sysArchives";
    private static final String PROP_LOCATION = "webrcp.location";
    private static final String ECLIPSE_EXITCODE = "eclipse.exitcode";
    private static final String ECLIPSE_EXIT_DATA = "eclipse.exitdata";
    private static final String ECLIPSE_VM = "eclipse.vm";
    private static final String OSGI_OS = "osgi.os";
    private static final String OSGI_WS = "osgi.ws";
    private static final String OSGI_ARCH = "osgi.arch";
    private static final String OSGI_CONFIGURATION_AREA = "osgi.configuration.area";
    private static final String OSGI_CLEAN = "osgi.clean";
    private static final int EXITCODE_SUCCESS = 0;
    private static final int EXITCODE_RESTART = 23;
    private static final int EXITCODE_RESTART_ARGS = 24;
    private static final String LAUNCHER_CLASS = "org.eclipse.core.launcher.Main";
    private static final String LAUNCHER_JAR = "startup.jar";
    private static final String UNPACKED_DIR = "unpacked";
    private static final String ARCHIVES_DIR = "archives";
    private static final String CONFIG_DIR = "configuration";
    private static final String VERSION_FILE = "version";
    private static final String CMDLINE_FILE = "cmdline";
    private static final String LOCK_FILE = "lock";
    private static final String APP_DIR_PREFIX = "WebRCP-";
    private String os;
    private String arch;
    private String appName;
    private String appVersion;
    private String[] archives;
    private String[] sysArchives;
    private String fileName;
    private String baseURL;
    private File appDir;
    private File unpackDir;
    private File archivesDir;
    private ProgressDialog progress;
    private UnpackThread unpackThread;
    private FileLock lock;

    private WebRCP() {
        System.out.println("Info:");
        String location = this.getProperty(PROP_LOCATION);
        System.out.println("\tLocation: " + location);
        int nameStart = location.lastIndexOf(47);
        this.fileName = location.substring(nameStart + 1);
        System.out.println("\tFile name: " + this.fileName);
        this.baseURL = location.substring(0, nameStart + 1);
        System.out.println("\tBase URL: " + this.baseURL);
        this.appName = this.getProperty(PROP_APPNAME);
        System.out.println("\tApplication: " + this.appName);
        this.appVersion = this.getProperty(PROP_APPVERSION);
        System.out.println("\tApp Version: " + this.appVersion);
        String archivesStr = this.getProperty(PROP_ARCHIVES);
        System.out.println("\tArchives: " + archivesStr);
        this.archives = archivesStr.split("\\s*,\\s*");
        archivesStr = System.getProperty(PROP_SYSARCHIVES);
        System.out.println("\tSys Archives: " + archivesStr);
        if (archivesStr != null) {
            this.sysArchives = archivesStr.split("\\s*,\\s*");
        }
        this.arch = this.determineArch();
        System.out.println("\tArchitecture: " + this.arch);
        this.os = this.determineOS();
        System.out.println("\tOS: " + this.os);
    }

    private void run() {
        boolean override;
        this.appDir = new File(this.getProperty("java.io.tmpdir"), APP_DIR_PREFIX + this.appName + '-' + this.getProperty("user.name"));
        System.out.println("Creating application directory: " + this.appDir);
        this.appDir.mkdirs();
        if (!this.appDir.isDirectory()) {
            this.fatalError("Installation Error", "Could not create application directory: " + this.appDir);
        }
        this.ensureSingleInstance();
        this.progress = new ProgressDialog();
        this.unpackDir = new File(this.appDir, UNPACKED_DIR);
        this.archivesDir = new File(this.appDir, ARCHIVES_DIR);
        File versionFile = new File(this.appDir, VERSION_FILE);
        String localVersion = this.readFile(versionFile);
        boolean bl = override = !this.appVersion.equals(localVersion);
        if (override) {
            System.out.println("New Version available. Cleaning up...");
            versionFile.delete();
            this.removeRecursively(this.unpackDir);
            this.removeRecursively(this.archivesDir);
            System.setProperty(OSGI_CLEAN, "true");
        }
        this.processArchives();
        this.processSysArchives();
        if (this.unpackThread != null) {
            System.out.println("Waiting for unpacking to finish...");
            this.progress.startTask("Unpacking archives...");
            this.unpackThread.finish();
        }
        this.writeFile(versionFile, this.appVersion);
        this.startLauncher();
    }

    private String determineArch() {
        String arch = System.getProperty("os.arch").toLowerCase();
        if (arch.indexOf(ARCH_X86) >= 0 || arch.matches("i.86")) {
            return ARCH_X86;
        }
        if (arch.indexOf(ARCH_PPC) >= 0 || arch.indexOf("power") >= 0) {
            return ARCH_PPC;
        }
        if (arch.indexOf(ARCH_X86_64) >= 0 || arch.indexOf("amd64") >= 0) {
            return ARCH_X86_64;
        }
        if (arch.indexOf(ARCH_IA64) >= 0) {
            return ARCH_IA64;
        }
        if (arch.indexOf(ARCH_IA64_32) >= 0) {
            return ARCH_IA64_32;
        }
        if (arch.indexOf("risc") >= 0) {
            return ARCH_PA_RISC;
        }
        if (arch.indexOf(ARCH_SPARC) >= 0) {
            return ARCH_SPARC;
        }
        this.fatalError("Unknown Architecture", "Your system has an unknown architecture: " + arch);
        return null;
    }

    private String determineOS() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.indexOf(OS_LINUX) >= 0) {
            return OS_LINUX;
        }
        if (os.indexOf("mac") >= 0) {
            return OS_MACOSX;
        }
        if (os.indexOf("windows") >= 0) {
            return "win32";
        }
        if (os.indexOf("hp") >= 0 && os.indexOf("ux") >= 0) {
            return OS_HPUX;
        }
        if (os.indexOf(OS_SOLARIS) >= 0) {
            return OS_SOLARIS;
        }
        if (os.indexOf(OS_AIX) >= 0) {
            return OS_AIX;
        }
        if (os.indexOf(OS_QNX) >= 0) {
            return OS_QNX;
        }
        this.fatalError("Unknown Operating System", "Your operating system is unknown: " + os);
        return null;
    }

    private String getWindowSystem() {
        if (this.os.equals("win32")) {
            return "win32";
        }
        if (this.os.equals(OS_LINUX)) {
            return WS_GTK;
        }
        if (this.os.equals(OS_QNX)) {
            return WS_PHOTON;
        }
        if (this.os.equals(OS_MACOSX)) {
            return WS_CARBON;
        }
        return WS_MOTIF;
    }

    private void ensureSingleInstance() {
        try {
            FileOutputStream out = new FileOutputStream(this.appDir + File.separator + LOCK_FILE);
            FileChannel channel = out.getChannel();
            this.lock = channel.tryLock();
            if (this.lock == null) {
                this.fatalError("Already running.", "There is already an instance of " + this.appName + " running.");
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void processArchives() {
        System.out.println("Downloading archives...");
        for (int i = 0; i < this.archives.length; ++i) {
            File destFile = new File(this.archivesDir, this.archives[i] + ".zip");
            if (!destFile.exists()) {
                this.downloadFile(this.archives[i] + ".zip", destFile, true);
                this.unpackArchive(destFile);
                continue;
            }
            System.out.println("\tArchive " + destFile + " exists already");
        }
    }

    private void processSysArchives() {
        if (this.sysArchives == null) {
            return;
        }
        System.out.println("Downloading sysarchives...");
        String sysArchivePostfix = this.os + '-' + this.arch + ".zip";
        for (int i = 0; i < this.sysArchives.length; ++i) {
            File destFile = new File(this.archivesDir, this.sysArchives[i] + ".zip");
            if (!destFile.exists()) {
                if (!this.downloadFile(this.sysArchives[i] + '-' + sysArchivePostfix, destFile, false)) {
                    this.downloadFile(this.sysArchives[i] + '/' + sysArchivePostfix, destFile, true);
                }
                this.unpackArchive(destFile);
                continue;
            }
            System.out.println("\tArchive " + destFile + " exists already");
        }
    }

    private void unpackArchive(File file) {
        if (this.unpackThread == null) {
            this.unpackThread = new UnpackThread(this.unpackDir);
        }
        this.unpackThread.addFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean downloadFile(String srcFile, File destFile, boolean exitOnError) {
        try {
            destFile.getParentFile().mkdirs();
            URL url = new URL(this.baseURL + srcFile);
            URLConnection conn = url.openConnection();
            System.out.println("\tDownloading " + url + "...");
            this.progress.startTask("Downloading " + destFile.getName() + "...", conn.getContentLength());
            InputStream in = null;
            FileOutputStream out = null;
            try {
                int size;
                out = new FileOutputStream(destFile);
                in = conn.getInputStream();
                byte[] buffer = new byte[65535];
                while ((size = in.read(buffer)) > 0 && !this.progress.isCanceled()) {
                    out.write(buffer, 0, size);
                    this.progress.worked(size);
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            if (this.progress.isCanceled()) {
                destFile.delete();
                System.exit(0);
            }
            return true;
        }
        catch (IOException ex) {
            if (exitOnError) {
                ex.printStackTrace();
                this.fatalError("Download Error", "Could not download file: " + ex);
            }
            return false;
        }
    }

    private void startLauncher() {
        this.progress.startTask("Launching " + this.appName + "...");
        Timer timer = new Timer(2500, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WebRCP.this.progress.setVisible(false);
            }
        });
        timer.setRepeats(false);
        timer.start();
        File cmdLineFile = new File(this.appDir, CMDLINE_FILE);
        System.out.println("Starting launcher...");
        Policy.setPolicy(new AllPermissionPolicy());
        System.setProperty(OSGI_OS, this.os);
        System.setProperty(OSGI_WS, this.getWindowSystem());
        System.setProperty(OSGI_ARCH, this.arch);
        System.setProperty(OSGI_CONFIGURATION_AREA, this.appDir + File.separator + CONFIG_DIR);
        System.setProperty(ECLIPSE_VM, "");
        try {
            URLClassLoader classLoader = new URLClassLoader(new URL[]{new URL(this.unpackDir.toURL() + "/" + LAUNCHER_JAR)});
            Class<?> launcherClass = classLoader.loadClass(LAUNCHER_CLASS);
            Method launcherRun = launcherClass.getMethod("run", String;.class);
            launcherRun.invoke(launcherClass.newInstance(), new Object[]{this.readLauncherArgs(cmdLineFile)});
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.fatalError("Startup Error", "Exception caught: " + ex);
        }
        String exitCodeStr = System.getProperty(ECLIPSE_EXITCODE);
        int exitCode = exitCodeStr != null ? Integer.parseInt(exitCodeStr) : -1;
        System.out.println("Exit code: " + exitCodeStr);
        switch (exitCode) {
            case 24: {
                String cmdline = System.getProperty(ECLIPSE_EXIT_DATA);
                System.out.println("Restarting Eclipse with new command-line: " + cmdline);
                this.writeFile(cmdLineFile, cmdline);
                this.restart();
                break;
            }
            case 23: {
                System.out.println("Restarting Eclipse...");
                this.restart();
                break;
            }
            case 0: {
                System.out.println("Eclipse successfully exited...");
                break;
            }
            default: {
                System.err.println("Eclipse exited with error: " + exitCode);
                int result = JOptionPane.showOptionDialog(null, "Eclipse exited with error: " + exitCode + "\nRemove application completely for reinstalling?", "Startup error", 0, 0, null, null, null);
                if (0 == result) {
                    this.removeRecursively(this.appDir);
                }
                System.exit(1);
            }
        }
    }

    private String[] readLauncherArgs(File file) {
        String argsStr = this.readFile(file);
        if (argsStr == null) {
            return new String[0];
        }
        System.out.println("Launcher Arguments:");
        ArrayList<String> argList = new ArrayList<String>();
        String[] args = argsStr.split("\n");
        for (int i = 0; i < args.length; ++i) {
            args[i] = args[i].trim();
            if (args[i].equals("")) continue;
            argList.add(args[i]);
            System.out.println("\t" + args[i]);
        }
        return argList.toArray(new String[argList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFile(File file) {
        block7: {
            String string;
            FileReader reader = new FileReader(file);
            try {
                int length;
                StringWriter content = new StringWriter();
                char[] buf = new char[1024];
                while ((length = reader.read(buf)) > 0) {
                    content.write(buf, 0, length);
                }
                string = content.toString();
            }
            catch (Throwable throwable) {
                try {
                    ((Reader)reader).close();
                    throw throwable;
                }
                catch (FileNotFoundException ex) {
                    break block7;
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            ((Reader)reader).close();
            return string;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(File file, String content) {
        try {
            FileWriter writer = new FileWriter(file);
            try {
                writer.write(content);
            }
            finally {
                ((Writer)writer).close();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void restart() {
        try {
            String javawsPath = System.getProperty("jnlpx.home");
            if (javawsPath == null) {
                javawsPath = this.getProperty("javax.home");
            }
            javawsPath = javawsPath + File.separator + "javaws";
            System.out.println("Executing: " + javawsPath + ' ' + this.baseURL + this.fileName);
            Runtime.getRuntime().exec(new String[]{javawsPath, this.baseURL + this.fileName});
        }
        catch (IOException ex) {
            ex.printStackTrace();
            this.fatalError("Restarting failed", "Restarting Java WebStart failed: " + ex);
        }
    }

    private void fatalError(String title, String message) {
        JOptionPane.showMessageDialog(null, message, title, 0);
        System.exit(1);
    }

    private String getProperty(String key) {
        String value = System.getProperty(key);
        if (value != null) {
            return value;
        }
        this.fatalError("Missing System Property", key + " is required");
        return null;
    }

    private void removeRecursively(File dir) {
        if (!dir.exists()) {
            return;
        }
        if (!dir.isDirectory()) {
            dir.delete();
            return;
        }
        File[] file = dir.listFiles();
        for (int i = 0; i < file.length; ++i) {
            this.removeRecursively(file[i]);
        }
        dir.delete();
    }

    public static void main(String[] args) {
        new WebRCP().run();
        System.exit(0);
    }
}

