#!/bin/bash

#Copyright (C) since 2006 NTT DATA Corporation
#
#This program is free software; you can redistribute it and/or
#Modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation, version 2.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details

. /opt/hinemos/hinemos.cfg

# Check JBoss process
if [ -f ${HINEMOS_JBOSS_PID} ] ; then
    echo ""    
else
    echo "jboss_stop.sh : PID file \"${HINEMOS_JBOSS_PID}\" does not exist"
    echo "Is JBoss running?"
    exit 2 
fi

# JBoss shutdown
echo "waiting for jboss to stop..."
${JBOSS_HOME}/bin/shutdown_hinemos.sh -S -s ${IP_ADDRESS}
REVAL=$?
                                                                                                     
if [ $REVAL -ne 0 ] ; then
    echo "Shutdown failer."
    exit 1
else
    while [ 1 ];
    do
        JBOSS_PIDS=`ps -ef | grep "${JAVA_HOME}/bin/java.*org.jboss.Main" | grep -v "grep"`
                                                                                                     
        if [ -z "${JBOSS_PIDS}" ]; then
            echo "done"
            break;
        fi
        sleep 2
        echo -n "."
    done
fi
                                                                                  
if [ -f ${HINEMOS_JBOSS_PID} ]; then
    read JBOSS_PID < ${HINEMOS_JBOSS_PID}
    TMP=0
    ps -p ${JBOSS_PID} e | grep ${HINEMOS_HOME} > /dev/null && TMP=1
    if [ "${TMP}" -eq 0 ] ; then
        rm -f ${HINEMOS_JBOSS_PID}
    fi
fi
                                                                                                     
echo "jboss stoped"
