/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.security;

import java.util.HashSet;
import javax.annotation.security.RunAs;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.annotation.security.RunAsPrincipal;
import org.jboss.annotation.security.SecurityDomain;
import org.jboss.aop.Advisor;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.advice.AspectFactory;
import org.jboss.aop.joinpoint.Joinpoint;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.metamodel.AssemblyDescriptor;
import org.jboss.ejb3.security.RunAsSecurityInterceptor;
import org.jboss.ejb3.security.SecurityDomainManager;
import org.jboss.ejb3.tx.NullInterceptor;
import org.jboss.logging.Logger;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.RealmMapping;
import org.jboss.security.RunAsIdentity;

public class RunAsSecurityInterceptorFactory
implements AspectFactory {
    private static final Logger log = Logger.getLogger(RunAsSecurityInterceptorFactory.class);

    public Object createPerVM() {
        throw new RuntimeException("PER_VM not supported for this interceptor factory, only PER_CLASS");
    }

    protected RunAsIdentity getRunAsIdentity(EJBContainer container) {
        RunAs runAs = (RunAs)container.resolveAnnotation(RunAs.class);
        if (runAs == null) {
            return null;
        }
        if (container.getXml() != null && container.getXml().getSecurityIdentity() != null && container.getXml().getSecurityIdentity().isUseCallerIdentity()) {
            return null;
        }
        RunAsPrincipal rap = (RunAsPrincipal)container.resolveAnnotation(RunAsPrincipal.class);
        String runAsPrincipal = null;
        if (rap != null) {
            runAsPrincipal = rap.value();
        } else if (container.getXml() != null && container.getXml().getSecurityIdentity() != null) {
            runAsPrincipal = container.getXml().getSecurityIdentity().getRunAsPrincipal();
        }
        HashSet extraRoles = new HashSet();
        AssemblyDescriptor ad = container.getAssemblyDescriptor();
        if (ad != null) {
            extraRoles.addAll(ad.getSecurityRolesGivenPrincipal(runAsPrincipal));
        }
        return new RunAsIdentity(runAs.value(), runAsPrincipal, extraRoles);
    }

    public Object createPerClass(Advisor advisor) {
        EJBContainer container = (EJBContainer)advisor;
        RunAsIdentity runAsIdentity = this.getRunAsIdentity(container);
        Object domain = null;
        try {
            InitialContext ctx = container.getInitialContext();
            SecurityDomain anSecurityDomain = (SecurityDomain)advisor.resolveAnnotation(SecurityDomain.class);
            if (anSecurityDomain != null) {
                String domainName = anSecurityDomain.value();
                domain = SecurityDomainManager.getSecurityManager(domainName, ctx);
            }
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
        Object interceptor = new NullInterceptor();
        if (domain != null) {
            AuthenticationManager manager = (AuthenticationManager)domain;
            RealmMapping mapping = (RealmMapping)domain;
            interceptor = new RunAsSecurityInterceptor(manager, mapping, this.getRunAsIdentity(container));
        }
        return interceptor;
    }

    public Object createPerInstance(Advisor advisor, InstanceAdvisor instanceAdvisor) {
        throw new RuntimeException("PER_VM not supported for this interceptor factory, only PER_CLASS");
    }

    public Object createPerJoinpoint(Advisor advisor, Joinpoint jp) {
        throw new RuntimeException("PER_VM not supported for this interceptor factory, only PER_CLASS");
    }

    public Object createPerJoinpoint(Advisor advisor, InstanceAdvisor instanceAdvisor, Joinpoint jp) {
        throw new RuntimeException("PER_VM not supported for this interceptor factory, only PER_CLASS");
    }

    public String getName() {
        return this.getClass().getName();
    }
}

