/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.security;

import java.security.GeneralSecurityException;
import java.security.Principal;
import java.util.Map;
import javax.ejb.EJBAccessException;
import org.jboss.annotation.security.SecurityDomain;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aspects.security.AuthenticationInterceptor;
import org.jboss.aspects.security.SecurityContext;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.EJBContainer;
import org.jboss.logging.Logger;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.RealmMapping;
import org.jboss.security.SecurityAssociation;
import org.jboss.security.SecurityRolesAssociation;
import org.jboss.security.SimplePrincipal;

public class Ejb3AuthenticationInterceptor
extends AuthenticationInterceptor {
    private static final Logger log = Logger.getLogger(Ejb3AuthenticationInterceptor.class);
    private EJBContainer container;
    protected RealmMapping realmMapping;

    public Ejb3AuthenticationInterceptor(AuthenticationManager manager, Container container) {
        super(manager);
        this.container = (EJBContainer)container;
        this.realmMapping = (RealmMapping)manager;
    }

    protected void handleGeneralSecurityException(GeneralSecurityException gse) {
        log.debug((Object)"Authentication failure", (Throwable)gse);
        throw new EJBAccessException("Authentication failure");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Invocation invocation) throws Throwable {
        MethodInvocation mi = (MethodInvocation)invocation;
        SecurityDomain domain = (SecurityDomain)this.container.resolveAnnotation(SecurityDomain.class);
        if (domain != null && domain.unauthenticatedPrincipal() != null && domain.unauthenticatedPrincipal().length() != 0) {
            Principal principal = (Principal)invocation.getMetaData((Object)"security", (Object)"principal");
            if (principal == null) {
                principal = SecurityAssociation.getPrincipal();
            }
            if (principal == null) {
                invocation.getMetaData().addMetaData((Object)"security", (Object)"principal", (Object)new SimplePrincipal(domain.unauthenticatedPrincipal()));
                Object oldDomain = SecurityContext.getCurrentDomain().get();
                try {
                    SecurityContext.getCurrentDomain().set(this.authenticationManager);
                    Object object = invocation.invokeNext();
                    return object;
                }
                finally {
                    SecurityContext.getCurrentDomain().set(oldDomain);
                }
            }
        }
        try {
            Object ignoreFlag;
            if (this.container.getAssemblyDescriptor() != null) {
                SecurityRolesAssociation.setSecurityRoles((Map)this.container.getAssemblyDescriptor().getPrincipalVersusRolesMap());
            }
            if ((ignoreFlag = invocation.getMetaData((Object)"AUTHORIZATION", (Object)"IGNORE_AUTHORIZATION")) != null) {
                Object object = invocation.invokeNext();
                return object;
            }
            Object object = super.invoke(invocation);
            return object;
        }
        finally {
            SecurityRolesAssociation.setSecurityRoles(null);
        }
    }
}

