/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.notify.ejb.entity;

import com.clustercontrol.notify.ejb.entity.NotifyStatusInfoHome;
import com.clustercontrol.notify.ejb.entity.NotifyStatusInfoLocalHome;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.Remote;
import java.security.SecureRandom;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

public class NotifyStatusInfoUtil {
    private static NotifyStatusInfoHome cachedRemoteHome = null;
    private static NotifyStatusInfoLocalHome cachedLocalHome = null;
    private static String hexServerIP = null;
    private static final SecureRandom seeder = new SecureRandom();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object lookupHome(Hashtable environment, String jndiName, Class narrowTo) throws NamingException {
        InitialContext initialContext = new InitialContext(environment);
        try {
            Object objRef = initialContext.lookup(jndiName);
            if (Remote.class.isAssignableFrom(narrowTo)) {
                Object object = PortableRemoteObject.narrow((Object)objRef, (Class)narrowTo);
                return object;
            }
            Object object = objRef;
            return object;
        }
        finally {
            initialContext.close();
        }
    }

    public static NotifyStatusInfoHome getHome() throws NamingException {
        if (cachedRemoteHome == null) {
            cachedRemoteHome = (NotifyStatusInfoHome)NotifyStatusInfoUtil.lookupHome(null, "NotifyStatusInfo", NotifyStatusInfoHome.class);
        }
        return cachedRemoteHome;
    }

    public static NotifyStatusInfoHome getHome(Hashtable environment) throws NamingException {
        return (NotifyStatusInfoHome)NotifyStatusInfoUtil.lookupHome(environment, "NotifyStatusInfo", NotifyStatusInfoHome.class);
    }

    public static NotifyStatusInfoLocalHome getLocalHome() throws NamingException {
        if (cachedLocalHome == null) {
            cachedLocalHome = (NotifyStatusInfoLocalHome)NotifyStatusInfoUtil.lookupHome(null, "NotifyStatusInfoLocal", NotifyStatusInfoLocalHome.class);
        }
        return cachedLocalHome;
    }

    public static final String generateGUID(Object o) {
        StringBuffer tmpBuffer = new StringBuffer(16);
        if (hexServerIP == null) {
            InetAddress localInetAddress = null;
            try {
                localInetAddress = InetAddress.getLocalHost();
            }
            catch (UnknownHostException uhe) {
                System.err.println("NotifyStatusInfoUtil: Could not get the local IP address using InetAddress.getLocalHost()!");
                uhe.printStackTrace();
                return null;
            }
            byte[] serverIP = localInetAddress.getAddress();
            hexServerIP = NotifyStatusInfoUtil.hexFormat(NotifyStatusInfoUtil.getInt(serverIP), 8);
        }
        String hashcode = NotifyStatusInfoUtil.hexFormat(System.identityHashCode(o), 8);
        tmpBuffer.append(hexServerIP);
        tmpBuffer.append(hashcode);
        long timeNow = System.currentTimeMillis();
        int timeLow = (int)timeNow & 0xFFFFFFFF;
        int node = seeder.nextInt();
        StringBuffer guid = new StringBuffer(32);
        guid.append(NotifyStatusInfoUtil.hexFormat(timeLow, 8));
        guid.append(tmpBuffer.toString());
        guid.append(NotifyStatusInfoUtil.hexFormat(node, 8));
        return guid.toString();
    }

    private static int getInt(byte[] bytes) {
        int i = 0;
        int j = 24;
        int k = 0;
        while (j >= 0) {
            int l = bytes[k] & 0xFF;
            i += l << j;
            j -= 8;
            ++k;
        }
        return i;
    }

    private static String hexFormat(int i, int j) {
        String s = Integer.toHexString(i);
        return NotifyStatusInfoUtil.padHex(s, j) + s;
    }

    private static String padHex(String s, int i) {
        StringBuffer tmpBuffer = new StringBuffer();
        if (s.length() < i) {
            for (int j = 0; j < i - s.length(); ++j) {
                tmpBuffer.append('0');
            }
        }
        return tmpBuffer.toString();
    }
}

