/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.monitor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.jboss.monitor.EntityLockMonitorMBean;
import org.jboss.monitor.LockMonitor;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.util.naming.NonSerializableFactory;

public class EntityLockMonitor
extends ServiceMBeanSupport
implements EntityLockMonitorMBean {
    public static final String JNDI_NAME = "EntityLockMonitor";
    protected HashMap monitorMap = new HashMap();
    protected long contenders = 0L;
    protected long maxContenders = 0L;
    protected ArrayList times = new ArrayList();
    protected long contentions = 0L;
    protected long totalTime = 0L;
    protected long sumContenders = 0L;

    protected void startService() throws Exception {
        this.bind();
        this.log.info((Object)"EntityLockMonitor started");
    }

    protected void stopService() {
        try {
            this.unbind();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.log.info((Object)"EntityLockMonitor stopped");
    }

    public synchronized long getAverageContenders() {
        if (this.contentions == 0L) {
            return 0L;
        }
        return this.sumContenders / this.contentions;
    }

    public synchronized long getMaxContenders() {
        return this.maxContenders;
    }

    public synchronized long getMedianWaitTime() {
        if (this.times.size() < 1) {
            return 0L;
        }
        Long[] alltimes = this.times.toArray(new Long[this.times.size()]);
        long[] thetimes = new long[alltimes.length];
        for (int i = 0; i < thetimes.length; ++i) {
            thetimes[i] = alltimes[i];
        }
        Arrays.sort(thetimes);
        return thetimes[thetimes.length / 2];
    }

    public synchronized long getTotalContentions() {
        return this.contentions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set listMonitoredBeans() {
        HashMap hashMap = this.monitorMap;
        synchronized (hashMap) {
            return new TreeSet(this.monitorMap.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockMonitor getLockMonitor(String jndiName) {
        HashMap hashMap = this.monitorMap;
        synchronized (hashMap) {
            return (LockMonitor)this.monitorMap.get(jndiName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String printLockMonitor() {
        StringBuffer rtn = new StringBuffer();
        rtn.append("<table width=\"1\" border=\"1\">");
        rtn.append("<tr><td><b>EJB JNDI-NAME</b></td><td><b>Total Lock Time</b></td><td><b>Num Contentions</b></td><td><b>Time Outs</b></td><td><b>Max Contenders</b></td></tr>");
        HashMap hashMap = this.monitorMap;
        synchronized (hashMap) {
            Iterator it = this.monitorMap.keySet().iterator();
            while (it.hasNext()) {
                rtn.append("<tr>");
                String jndiName = (String)it.next();
                rtn.append("<td>");
                rtn.append(jndiName);
                rtn.append("</td>");
                LockMonitor lm = (LockMonitor)this.monitorMap.get(jndiName);
                rtn.append("<td>");
                rtn.append("" + lm.getTotalTime());
                rtn.append("</td><td>");
                rtn.append("" + lm.getNumContentions());
                rtn.append("</td><td>");
                rtn.append("" + lm.getTimeouts());
                rtn.append("</td><td>");
                rtn.append("" + lm.getMaxContenders());
                rtn.append("</td></tr>");
            }
        }
        rtn.append("</table>");
        return rtn.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clearMonitor() {
        this.contenders = 0L;
        this.maxContenders = 0L;
        this.times.clear();
        this.contentions = 0L;
        this.totalTime = 0L;
        this.sumContenders = 0L;
        HashMap hashMap = this.monitorMap;
        synchronized (hashMap) {
            for (String jndiName : this.monitorMap.keySet()) {
                LockMonitor lm = (LockMonitor)this.monitorMap.get(jndiName);
                lm.reset();
            }
        }
    }

    public synchronized void incrementContenders() {
        ++this.contenders;
        ++this.contentions;
        this.sumContenders += this.contenders;
        if (this.contenders > this.maxContenders) {
            this.maxContenders = this.contenders;
        }
    }

    public synchronized void decrementContenders(long time) {
        this.times.add(new Long(time));
        --this.contenders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockMonitor getEntityLockMonitor(String jndiName) {
        LockMonitor lm = null;
        HashMap hashMap = this.monitorMap;
        synchronized (hashMap) {
            lm = (LockMonitor)this.monitorMap.get(jndiName);
            if (lm == null) {
                lm = new LockMonitor(this);
                this.monitorMap.put(jndiName, lm);
            }
        }
        return lm;
    }

    private void bind() throws NamingException {
        InitialContext ctx = new InitialContext();
        NonSerializableFactory.bind((String)JNDI_NAME, (Object)this);
        StringRefAddr addr = new StringRefAddr("nns", JNDI_NAME);
        Reference ref = new Reference(EntityLockMonitor.class.getName(), addr, NonSerializableFactory.class.getName(), null);
        ctx.bind(JNDI_NAME, (Object)ref);
    }

    private void unbind() throws NamingException {
        new InitialContext().unbind(JNDI_NAME);
        NonSerializableFactory.unbind((String)JNDI_NAME);
    }
}

