/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.transaction.SystemException;
import org.jboss.ejb.Container;
import org.jboss.ejb.EnterpriseContext;
import org.jboss.ejb.StatefulSessionContainer;
import org.jboss.ejb.StatefulSessionEnterpriseContext;
import org.jboss.ejb.StatefulSessionPersistenceManager;
import org.jboss.ejb.plugins.AbstractInstanceCache;

public class StatefulSessionInstanceCache
extends AbstractInstanceCache {
    private StatefulSessionContainer m_container;
    private ConcurrentReaderHashMap passivatedIDs = new ConcurrentReaderHashMap();
    private HashSet activating = new HashSet();
    private StringBuffer buffer = new StringBuffer();

    public long getPassivatedCount() {
        return this.passivatedIDs.size();
    }

    public void setContainer(Container c) {
        this.m_container = (StatefulSessionContainer)c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        StatefulSessionInstanceCache statefulSessionInstanceCache = this;
        synchronized (statefulSessionInstanceCache) {
            this.m_container = null;
        }
        this.passivatedIDs.clear();
        super.destroy();
    }

    protected synchronized Container getContainer() {
        return this.m_container;
    }

    protected void passivate(EnterpriseContext ctx) throws RemoteException {
        this.m_container.getPersistenceManager().passivateSession((StatefulSessionEnterpriseContext)ctx);
        this.passivatedIDs.put(ctx.getId(), (Object)new Long(System.currentTimeMillis()));
    }

    protected void activate(EnterpriseContext ctx) throws RemoteException {
        this.m_container.getPersistenceManager().activateSession((StatefulSessionEnterpriseContext)ctx);
        this.passivatedIDs.remove(ctx.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doActivate(EnterpriseContext ctx) throws RemoteException {
        Object id = ctx.getId();
        HashSet hashSet = this.activating;
        synchronized (hashSet) {
            if (this.activating.contains(id)) {
                return false;
            }
            this.activating.add(id);
        }
        try {
            boolean bl = super.doActivate(ctx);
            return bl;
        }
        finally {
            HashSet hashSet2 = this.activating;
            synchronized (hashSet2) {
                this.activating.remove(id);
            }
        }
    }

    protected EnterpriseContext acquireContext() throws Exception {
        return this.m_container.getInstancePool().get();
    }

    protected void freeContext(EnterpriseContext ctx) {
        this.m_container.getInstancePool().free(ctx);
    }

    protected Object getKey(EnterpriseContext ctx) {
        return ctx.getId();
    }

    protected void setKey(Object id, EnterpriseContext ctx) {
        ctx.setId(id);
    }

    protected boolean canPassivate(EnterpriseContext ctx) {
        if (ctx.isLocked()) {
            return false;
        }
        if (!this.m_container.getLockManager().canPassivate(ctx.getId())) {
            return false;
        }
        if (ctx.getTransaction() != null) {
            try {
                return ctx.getTransaction().getStatus() == 6;
            }
            catch (SystemException e) {
                return false;
            }
        }
        return true;
    }

    protected void removePassivated(long maxLifeAfterPassivation) {
        StatefulSessionPersistenceManager store = this.m_container.getPersistenceManager();
        long now = System.currentTimeMillis();
        log.debug((Object)("removePassivated, now=" + now + ", maxLifeAfterPassivation=" + maxLifeAfterPassivation));
        boolean trace = log.isTraceEnabled();
        Iterator entries = this.passivatedIDs.entrySet().iterator();
        while (entries.hasNext()) {
            long passivationTime;
            Map.Entry entry = (Map.Entry)entries.next();
            Object key = entry.getKey();
            Long value = (Long)entry.getValue();
            if (value == null || now - (passivationTime = value.longValue()) <= maxLifeAfterPassivation) continue;
            this.preRemovalPreparation(key);
            store.removePassivated(key);
            if (trace) {
                this.log(key, passivationTime);
            }
            entries.remove();
            this.postRemovalCleanup(key);
        }
    }

    protected void preRemovalPreparation(Object key) {
    }

    protected void postRemovalCleanup(Object key) {
    }

    private void log(Object key, long passivationTime) {
        if (log.isTraceEnabled()) {
            this.buffer.setLength(0);
            this.buffer.append("Removing from storage bean '");
            this.buffer.append(this.m_container.getBeanMetaData().getEjbName());
            this.buffer.append("' with id = ");
            this.buffer.append(key);
            this.buffer.append(", passivationTime=");
            this.buffer.append(passivationTime);
            log.trace((Object)this.buffer.toString());
        }
    }
}

