/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.impl;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.jboss.jms.server.MessagingTimeoutFactory;
import org.jboss.logging.Logger;
import org.jboss.messaging.core.contract.Delivery;
import org.jboss.messaging.core.contract.DeliveryObserver;
import org.jboss.messaging.core.contract.Distributor;
import org.jboss.messaging.core.contract.Filter;
import org.jboss.messaging.core.contract.Message;
import org.jboss.messaging.core.contract.MessageReference;
import org.jboss.messaging.core.contract.MessageStore;
import org.jboss.messaging.core.contract.PersistenceManager;
import org.jboss.messaging.core.contract.Queue;
import org.jboss.messaging.core.contract.Receiver;
import org.jboss.messaging.core.impl.ClusterRoundRobinDistributor;
import org.jboss.messaging.core.impl.PagingChannelSupport;
import org.jboss.messaging.core.impl.RoundRobinDistributor;
import org.jboss.messaging.core.impl.SimpleDelivery;
import org.jboss.messaging.core.impl.clusterconnection.MessageSucker;
import org.jboss.messaging.core.impl.tx.Transaction;
import org.jboss.util.timeout.Timeout;
import org.jboss.util.timeout.TimeoutTarget;

public class MessagingQueue
extends PagingChannelSupport
implements Queue {
    private static final Logger log = Logger.getLogger(MessagingQueue.class);
    private static final long DEFAULT_RECOVER_DELIVERIES_TIMEOUT = 3000000L;
    private int nodeID;
    protected String name;
    protected Filter filter;
    protected boolean clustered;
    protected Distributor remoteDistributor;
    protected Distributor localDistributor;
    private boolean trace = log.isTraceEnabled();
    private Set suckers;
    private boolean handleFlowControlForConsumers;
    private Map recoveryArea;
    private Map recoveryMap;
    private long recoverDeliveriesTimeout;

    public MessagingQueue(int nodeID, String name, long id, MessageStore ms, PersistenceManager pm, boolean recoverable, int maxSize, Filter filter, int fullSize, int pageSize, int downCacheSize, boolean clustered, long recoverDeliveriesTimeout) {
        super(id, ms, pm, recoverable, maxSize, fullSize, pageSize, downCacheSize);
        this.setup(nodeID, name, filter, clustered, recoverDeliveriesTimeout);
    }

    public MessagingQueue(int nodeID, String name, long id, MessageStore ms, PersistenceManager pm, boolean recoverable, Filter filter, boolean clustered) {
        super(id, ms, pm, recoverable, -1, 100000, 2000, 2000);
        this.setup(nodeID, name, filter, clustered, 3000000L);
    }

    public MessagingQueue(int nodeID, String name, long id, MessageStore ms, PersistenceManager pm, boolean recoverable, int maxSize, Filter filter, boolean clustered) {
        super(id, ms, pm, recoverable, maxSize);
        this.setup(nodeID, name, filter, clustered, 3000000L);
    }

    public MessagingQueue(int nodeID, String name, long id, boolean recoverable, Filter filter, boolean clustered) {
        super(id, null, null, recoverable, -1);
        this.setup(nodeID, name, filter, clustered, 3000000L);
    }

    private void setup(int nodeID, String name, Filter filter, boolean clustered, long recoverDeliveriesTimeout) {
        this.nodeID = nodeID;
        this.name = name;
        this.filter = filter;
        this.clustered = clustered;
        this.recoverDeliveriesTimeout = recoverDeliveriesTimeout;
        this.localDistributor = new DistributorWrapper(new RoundRobinDistributor());
        this.remoteDistributor = new DistributorWrapper(new RoundRobinDistributor());
        this.distributor = new ClusterRoundRobinDistributor(this.localDistributor, this.remoteDistributor);
        this.suckers = new HashSet();
        this.recoveryArea = new ConcurrentReaderHashMap();
        this.recoveryMap = Collections.synchronizedMap(new LinkedHashMap());
    }

    public int getNodeID() {
        return this.nodeID;
    }

    public String getName() {
        return this.name;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public boolean isClustered() {
        return this.clustered;
    }

    public Distributor getLocalDistributor() {
        return this.localDistributor;
    }

    public Distributor getRemoteDistributor() {
        return this.remoteDistributor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeIn(long theChannelID, int nodeID) throws Exception {
        if (this.trace) {
            log.trace((Object)("Merging queue " + this.channelID + " node id " + nodeID + " into " + this + " initially refs:" + this.messageRefs.size()));
        }
        Object object = this.lock;
        synchronized (object) {
            this.flushDownCache();
            PersistenceManager.InitialLoadInfo ili = this.pm.mergeAndLoad(theChannelID, this.channelID, this.fullSize - this.messageRefs.size(), this.firstPagingOrder, this.nextPagingOrder);
            if (this.trace) {
                log.trace((Object)("Loaded " + ili.getRefInfos().size() + " refs"));
            }
            this.doLoad(ili);
            Map toRecover = (Map)this.recoveryArea.remove(new Integer(nodeID));
            if (this.trace) {
                log.trace((Object)("To recover is: " + toRecover));
            }
            LinkedList<MessageReference> toTimeout = new LinkedList<MessageReference>();
            if (toRecover != null) {
                if (this.trace) {
                    log.trace((Object)"Recovery area is not empty, putting refs in recovery map");
                }
                ListIterator iter = this.messageRefs.iterator();
                while (iter.hasNext()) {
                    MessageReference ref = (MessageReference)iter.next();
                    Message message = ref.getMessage();
                    String sessionID = (String)toRecover.remove(new Long(message.getMessageID()));
                    if (sessionID == null) continue;
                    if (this.trace) {
                        log.trace((Object)("Added ref " + ref + " to recovery map"));
                    }
                    RecoveryEntry re = new RecoveryEntry();
                    re.ref = ref;
                    re.sessionID = sessionID;
                    this.recoveryMap.put(new Long(message.getMessageID()), re);
                    this.deliveringCount.increment();
                    iter.remove();
                    toTimeout.addLast(ref);
                }
                MessagingTimeoutFactory.instance.getFactory().schedule(System.currentTimeMillis() + this.recoverDeliveriesTimeout, (TimeoutTarget)new ClearRecoveryMapTimeoutTarget(toTimeout));
                if (this.trace) {
                    log.trace((Object)("Set timeout to fire in " + this.recoverDeliveriesTimeout));
                }
            }
            this.deliverInternal();
        }
    }

    public List recoverDeliveries(List messageIds) {
        if (this.trace) {
            log.trace((Object)"Recovering deliveries");
        }
        ArrayList<SimpleDelivery> refs = new ArrayList<SimpleDelivery>();
        for (Long messageID : messageIds) {
            RecoveryEntry re = (RecoveryEntry)this.recoveryMap.remove(messageID);
            if (re == null) continue;
            SimpleDelivery del = new SimpleDelivery(this, re.ref);
            if (this.trace) {
                log.trace((Object)("Recovered ref " + re.ref));
            }
            refs.add(del);
        }
        return refs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStrandedReferences(String sessionID) {
        MessageReference ref;
        if (this.trace) {
            log.trace((Object)("Removing stranded references for session " + sessionID));
        }
        Iterator iter = this.recoveryMap.values().iterator();
        if (this.trace) {
            log.trace((Object)"Scanning recovery map for stray entries for session");
        }
        ArrayList<MessageReference> toCancel = new ArrayList<MessageReference>();
        while (iter.hasNext()) {
            RecoveryEntry re = (RecoveryEntry)iter.next();
            if (this.trace) {
                log.trace((Object)("Session id id " + re.sessionID));
            }
            if (!re.sessionID.equals(sessionID)) continue;
            ref = re.ref;
            iter.remove();
            toCancel.add(ref);
        }
        for (int i = toCancel.size() - 1; i >= 0; --i) {
            ref = (MessageReference)toCancel.get(i);
            Object object = this.lock;
            synchronized (object) {
                this.messageRefs.addFirst(ref, ref.getMessage().getPriority());
                this.deliveringCount.decrement();
            }
            if (!this.trace) continue;
            log.trace((Object)"Found one, added back on queue");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSucker(MessageSucker sucker) {
        if (this.trace) {
            log.trace((Object)(this + " Registering sucker " + sucker));
        }
        Object object = this.lock;
        synchronized (object) {
            if (!this.suckers.contains(sucker)) {
                this.suckers.add(sucker);
                this.handleFlowControlForConsumers = true;
                if (this.getReceiversReady() && this.localDistributor.getNumberOfReceivers() > 0) {
                    if (this.trace) {
                        log.trace((Object)(this + " receivers ready so setting consumer to true"));
                    }
                    sucker.setConsuming(true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregisterSucker(MessageSucker sucker) {
        Object object = this.lock;
        synchronized (object) {
            boolean removed = this.suckers.remove(sucker);
            if (removed && this.suckers.isEmpty()) {
                this.handleFlowControlForConsumers = false;
            }
            return removed;
        }
    }

    public int getFullSize() {
        return this.fullSize;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getDownCacheSize() {
        return this.downCacheSize;
    }

    public void addToRecoveryArea(int nodeID, long messageID, String sessionID) {
        Integer nid;
        Map ids;
        if (this.trace) {
            log.trace((Object)("Adding message id " + messageID + " to recovery area from node " + nodeID));
        }
        if ((ids = (Map)this.recoveryArea.get(nid = new Integer(nodeID))) == null) {
            ids = new ConcurrentHashMap();
            this.recoveryArea.put(nid, ids);
        }
        ids.put(new Long(messageID), sessionID);
    }

    public void removeFromRecoveryArea(int nodeID, long messageID) {
        Integer nid;
        Map ids;
        if (this.trace) {
            log.trace((Object)("Removing message id " + messageID + " to recovery area from node " + nodeID));
        }
        if ((ids = (Map)this.recoveryArea.get(nid = new Integer(nodeID))) != null && ids.remove(new Long(messageID)) != null && ids.isEmpty()) {
            this.recoveryArea.remove(nid);
        }
    }

    public void removeAllFromRecoveryArea(int nodeID) {
        boolean removed;
        if (this.trace) {
            log.trace((Object)("Removing all from recovery area for node " + nodeID));
        }
        boolean bl = removed = this.recoveryArea.remove(new Integer(nodeID)) != null;
        if (this.trace) {
            log.trace((Object)("Removed:" + removed));
        }
    }

    public void addAllToRecoveryArea(int nodeID, Map ids) {
        if (this.trace) {
            log.trace((Object)("Adding all from recovery area for node " + nodeID + " set " + ids));
        }
        Integer nid = new Integer(nodeID);
        if (!(ids instanceof ConcurrentHashMap)) {
            ids = new ConcurrentHashMap(ids);
        }
        if (this.trace) {
            log.trace((Object)("Adding " + ids.size() + " ids to recovery area for node " + nodeID));
        }
        this.recoveryArea.put(nid, ids);
        if (this.trace) {
            log.trace((Object)"Added");
        }
    }

    public long getRecoverDeliveriesTimeout() {
        return this.recoverDeliveriesTimeout;
    }

    public Map getRecoveryArea() {
        if (this.trace) {
            log.trace((Object)("Getting recovery area, it is " + this.recoveryArea));
        }
        return this.recoveryArea;
    }

    public int getRecoveryMapSize() {
        return this.recoveryMap.size();
    }

    protected void deliverInternal() {
        super.deliverInternal();
        if (this.trace) {
            log.trace((Object)(this + " deliverInternal"));
        }
        if (this.handleFlowControlForConsumers && this.getReceiversReady() && this.localDistributor.getNumberOfReceivers() > 0 && this.messageRefs.isEmpty()) {
            if (this.trace) {
                log.trace((Object)"Informing suckers");
            }
            this.informSuckers(true);
        }
    }

    protected void setReceiversReady(boolean receiversReady) {
        if (this.trace) {
            log.trace((Object)(this + " setReceiversReady " + receiversReady));
        }
        this.receiversReady = receiversReady;
        if (this.handleFlowControlForConsumers && !receiversReady) {
            this.informSuckers(false);
        }
    }

    public String toString() {
        return "Queue[" + System.identityHashCode(this) + "/" + this.nodeID + "/" + this.channelID + "-" + this.name + "]";
    }

    public boolean equals(Object other) {
        if (!(other instanceof MessagingQueue)) {
            return false;
        }
        MessagingQueue queue = (MessagingQueue)other;
        return this.nodeID == queue.nodeID && this.name.equals(queue.name);
    }

    private void informSuckers(boolean consume) {
        for (MessageSucker sucker : this.suckers) {
            sucker.setConsuming(consume);
        }
    }

    private class ClearRecoveryMapTimeoutTarget
    implements TimeoutTarget {
        private List ids;

        ClearRecoveryMapTimeoutTarget(List ids) {
            this.ids = ids;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void timedOut(Timeout timeout) {
            if (MessagingQueue.this.trace) {
                log.trace((Object)"ClearRecoveryMap timeout fired");
            }
            Iterator iter = this.ids.iterator();
            boolean added = false;
            while (iter.hasNext()) {
                MessageReference ref = (MessageReference)iter.next();
                Object obj = MessagingQueue.this.recoveryMap.remove(new Long(ref.getMessage().getMessageID()));
                if (obj == null) continue;
                if (MessagingQueue.this.trace) {
                    log.trace((Object)("Adding ref " + ref + " back into queue"));
                }
                Object object = MessagingQueue.this.lock;
                synchronized (object) {
                    MessagingQueue.this.messageRefs.addFirst(ref, ref.getMessage().getPriority());
                    MessagingQueue.this.deliveringCount.decrement();
                }
                added = true;
            }
            if (added) {
                Object object = MessagingQueue.this.lock;
                synchronized (object) {
                    MessagingQueue.this.deliverInternal();
                }
            }
        }
    }

    static class RecoveryEntry {
        String sessionID;
        MessageReference ref;

        RecoveryEntry() {
        }
    }

    protected class DistributorWrapper
    implements Distributor {
        private Distributor distributor;

        protected DistributorWrapper(Distributor distributor) {
            this.distributor = distributor;
        }

        public Delivery handle(DeliveryObserver observer, MessageReference reference, Transaction tx) {
            return this.distributor.handle(observer, reference, tx);
        }

        public synchronized boolean add(Receiver receiver) {
            if (MessagingQueue.this.trace) {
                log.trace((Object)(this + " attempting to add receiver " + receiver));
            }
            boolean added = this.distributor.add(receiver);
            if (MessagingQueue.this.trace) {
                log.trace((Object)("receiver " + receiver + (added ? "" : " NOT") + " added"));
            }
            MessagingQueue.this.setReceiversReady(true);
            return added;
        }

        public void clear() {
            this.distributor.clear();
        }

        public boolean contains(Receiver receiver) {
            return this.distributor.contains(receiver);
        }

        public int getNumberOfReceivers() {
            return this.distributor.getNumberOfReceivers();
        }

        public Iterator iterator() {
            return this.distributor.iterator();
        }

        public synchronized boolean remove(Receiver receiver) {
            boolean removed = this.distributor.remove(receiver);
            if (removed && MessagingQueue.this.localDistributor.getNumberOfReceivers() == 0) {
                MessagingQueue.this.informSuckers(false);
                if (MessagingQueue.this.remoteDistributor.getNumberOfReceivers() == 0) {
                    MessagingQueue.this.setReceiversReady(false);
                }
            }
            if (MessagingQueue.this.trace) {
                log.trace((Object)(this + (removed ? " removed " : " did NOT remove ") + receiver));
            }
            return removed;
        }
    }
}

