/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.client.container;

import java.util.HashSet;
import java.util.Set;
import javax.jms.IllegalStateException;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.jms.client.Closeable;
import org.jboss.jms.client.container.DelegateIdentity;
import org.jboss.jms.client.delegate.DelegateSupport;
import org.jboss.jms.client.state.HierarchicalState;
import org.jboss.logging.Logger;

public class ClosedInterceptor
implements Interceptor {
    private static final Logger log = Logger.getLogger(ClosedInterceptor.class);
    private static final int NOT_CLOSED = 0;
    private static final int IN_CLOSING = 1;
    private static final int CLOSING = 2;
    private static final int IN_CLOSE = 3;
    private static final int CLOSED = -1;
    private boolean trace = log.isTraceEnabled();
    private int state = 0;
    private int inUseCount = 0;
    private DelegateIdentity id = null;

    public static String stateToString(int state) {
        return state == 0 ? "NOT_CLOSED" : (state == 1 ? "IN_CLOSING" : (state == 2 ? "CLOSING" : (state == 3 ? "IN_CLOSE" : (state == -1 ? "CLOSED" : "UNKNOWN"))));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ClosedInterceptor.");
        if (this.id == null) {
            sb.append("UNINITIALIZED");
        } else {
            sb.append(this.id.getType()).append("[").append(this.id.getID()).append("]");
        }
        return sb.toString();
    }

    public String getName() {
        return "ClosedInterceptor";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Invocation invocation) throws Throwable {
        Object object;
        if (this.id == null) {
            this.id = DelegateIdentity.getIdentity(invocation);
        }
        String methodName = ((MethodInvocation)invocation).getMethod().getName();
        boolean isClosing = methodName.equals("closing");
        boolean isClose = methodName.equals("close");
        if (isClosing) {
            if (this.checkClosingAlreadyDone()) {
                return new Long(-1L);
            }
        } else if (isClose) {
            if (this.checkCloseAlreadyDone()) {
                return null;
            }
        } else {
            object = this;
            synchronized (object) {
                if (this.state == 3 || this.state == -1) {
                    log.error((Object)(this + ": method " + methodName + "() did not go through, " + "the interceptor is " + ClosedInterceptor.stateToString(this.state)));
                    throw new IllegalStateException("The object is closed");
                }
                ++this.inUseCount;
            }
        }
        if (isClosing) {
            this.maintainRelatives(invocation);
        }
        try {
            object = invocation.invokeNext();
            return object;
        }
        catch (Exception t) {
            if (isClosing || isClose) {
                Long l = new Long(-1L);
                return l;
            }
            throw t;
        }
        finally {
            if (isClosing) {
                this.removeSelf(invocation);
                this.closing();
            } else if (isClose) {
                this.closed();
            } else {
                this.done();
            }
        }
    }

    protected synchronized boolean checkClosingAlreadyDone() throws Throwable {
        if (this.state != 0) {
            return true;
        }
        this.state = 1;
        return false;
    }

    protected synchronized void closing() throws Throwable {
        this.state = 2;
    }

    protected synchronized boolean checkCloseAlreadyDone() throws Throwable {
        if (this.state != 2) {
            return true;
        }
        while (this.inUseCount > 0) {
            this.wait();
        }
        this.state = 3;
        return false;
    }

    protected synchronized void closed() throws Throwable {
        this.state = -1;
        log.trace((Object)(this + " closed"));
    }

    protected synchronized void done() throws Throwable {
        if (--this.inUseCount == 0) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void maintainRelatives(Invocation invocation) {
        HashSet clone;
        HierarchicalState state = ((DelegateSupport)invocation.getTargetObject()).getState();
        Set children = state.getChildren();
        if (children == null) {
            if (this.trace) {
                log.trace((Object)(this + " has no children"));
            }
            return;
        }
        Set set = children;
        synchronized (set) {
            clone = new HashSet(children);
        }
        for (HierarchicalState child : clone) {
            Closeable del = (Closeable)((Object)child.getDelegate());
            try {
                del.closing(-1L);
                del.close();
            }
            catch (Throwable t) {
                if (!this.trace) continue;
                log.trace((Object)"Failed to close", t);
            }
        }
    }

    protected void removeSelf(Invocation invocation) {
        HierarchicalState state = ((DelegateSupport)invocation.getTargetObject()).getState();
        HierarchicalState parent = state.getParent();
        if (parent != null) {
            parent.getChildren().remove(state);
        }
    }
}

