/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jfree.util.ObjectUtils;
import org.jfree.util.PublicCloneable;

public class KeyToGroupMap
implements Cloneable,
PublicCloneable,
Serializable {
    private Comparable defaultGroup;
    private Map keyToGroupMap;

    public KeyToGroupMap() {
        this((Comparable)((Object)"Default Group"));
    }

    public KeyToGroupMap(Comparable defaultGroup) {
        if (defaultGroup == null) {
            throw new IllegalArgumentException("Null 'defaultGroup' argument.");
        }
        this.defaultGroup = defaultGroup;
        this.keyToGroupMap = new HashMap();
    }

    public List getGroups() {
        Collection values = this.keyToGroupMap.values();
        ArrayList<Comparable> result = new ArrayList<Comparable>();
        result.add(this.defaultGroup);
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            Comparable group = (Comparable)iterator.next();
            if (result.contains(group)) continue;
            result.add(group);
        }
        return result;
    }

    public int getGroupCount() {
        return this.getGroups().size();
    }

    public int getGroupIndex(Comparable group) {
        return this.getGroups().indexOf(group);
    }

    public Comparable getGroup(Comparable key) {
        Comparable result = this.defaultGroup;
        Comparable group = (Comparable)this.keyToGroupMap.get(key);
        if (group != null) {
            result = group;
        }
        return result;
    }

    public void mapKeyToGroup(Comparable key, Comparable group) {
        if (key == null) {
            throw new IllegalArgumentException("Null 'key' argument.");
        }
        if (group == null) {
            group = this.defaultGroup;
        }
        this.keyToGroupMap.put(key, group);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof KeyToGroupMap) {
            KeyToGroupMap m = (KeyToGroupMap)obj;
            boolean b0 = ObjectUtils.equal((Object)this.defaultGroup, (Object)m.defaultGroup);
            boolean b1 = ((Object)this.keyToGroupMap).equals(m.keyToGroupMap);
            return b0 && b1;
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

