/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.lock;

import EDU.oswego.cs.dl.util.concurrent.ReentrantWriterPreferenceReadWriteLock;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;

public class StripedLock {
    private static final int DEFAULT_CONCURRENCY = 20;
    private int lockSegmentMask;
    private int lockSegmentShift;
    ReentrantReadWriteLock[] sharedLocks;
    private Log log = LogFactory.getLog((Class)StripedLock.class);

    public StripedLock() {
        this(20);
    }

    public StripedLock(int concurrency) {
        int numLocks;
        int tempLockSegShift = 0;
        for (numLocks = 1; numLocks < concurrency; numLocks <<= 1) {
            ++tempLockSegShift;
        }
        this.lockSegmentShift = 32 - tempLockSegShift;
        this.lockSegmentMask = numLocks - 1;
        this.sharedLocks = new ReentrantReadWriteLock[numLocks];
        for (int i = 0; i < numLocks; ++i) {
            this.sharedLocks[i] = new ReentrantReadWriteLock();
        }
    }

    public void acquireLock(Fqn fqn, boolean exclusive) {
        ReentrantReadWriteLock lock = this.getLock(fqn);
        try {
            if (exclusive) {
                lock.writeLock().acquire();
            } else {
                lock.readLock().acquire();
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    public void releaseLock(Fqn fqn) {
        ReentrantReadWriteLock lock = this.getLock(fqn);
        if (lock.isWriteLockedByCurrentThread()) {
            lock.writeLock().release();
            if (lock.isWriteLockedByCurrentThread() && this.log.isWarnEnabled()) {
                this.log.warn((Object)("Write lock still exists on Fqn " + fqn + " for current thread.  Perhaps this was write-locked more than once?"));
            }
        } else {
            try {
                lock.readLock().release();
            }
            catch (IllegalMonitorStateException illegalMonitorStateException) {
                // empty catch block
            }
        }
    }

    ReentrantReadWriteLock getLock(Object o) {
        return this.sharedLocks[this.hashToIndex(o)];
    }

    int hashToIndex(Object o) {
        return this.hash(o) >>> this.lockSegmentShift & this.lockSegmentMask;
    }

    int hash(Object x) {
        int h = x.toString().hashCode();
        h += ~(h << 9);
        h ^= h >>> 14;
        h += h << 4;
        h ^= h >>> 10;
        return h;
    }

    public void releaseAllLocks(List fqns) {
        Iterator fqnsIterator = fqns.iterator();
        while (fqnsIterator.hasNext()) {
            this.releaseLock((Fqn)fqnsIterator.next());
        }
    }

    public void acquireAllLocks(List fqns, boolean exclusive) {
        Iterator fqnsIterator = fqns.iterator();
        while (fqnsIterator.hasNext()) {
            this.acquireLock((Fqn)fqnsIterator.next(), exclusive);
        }
    }

    class ReentrantReadWriteLock
    extends ReentrantWriterPreferenceReadWriteLock {
        ReentrantReadWriteLock() {
        }

        public boolean isWriteLockedByCurrentThread() {
            return this.activeWriter_ == Thread.currentThread();
        }
    }
}

