/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.monitor.run.factory;

import com.clustercontrol.accesscontrol.factory.AccessLock;
import com.clustercontrol.monitor.run.ejb.entity.MonitorInfoLocal;
import com.clustercontrol.monitor.run.ejb.entity.MonitorInfoPK;
import com.clustercontrol.monitor.run.ejb.entity.MonitorInfoUtil;
import com.clustercontrol.monitor.run.factory.ModifySchedule;
import com.clustercontrol.notify.ejb.session.NotifyControllerLocal;
import com.clustercontrol.notify.ejb.session.NotifyControllerUtil;
import com.clustercontrol.util.apllog.AplLogger;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.SchedulerException;

public abstract class DeleteMonitor {
    protected static Log m_log = LogFactory.getLog(DeleteMonitor.class);
    protected MonitorInfoLocal m_monitor;
    protected String m_monitorTypeId;
    protected String m_monitorId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean delete(String monitorTypeId, String monitorId) throws FinderException, RemoveException, SchedulerException, NamingException, NotSupportedException, HeuristicMixedException, HeuristicRollbackException, RollbackException, InvalidTransactionException, IllegalStateException, SystemException, CreateException {
        AccessLock.lock((String)"MONITOR");
        this.m_monitorTypeId = monitorTypeId;
        this.m_monitorId = monitorId;
        TransactionManager tm = null;
        Transaction oldTx = null;
        boolean result = false;
        try {
            InitialContext context = new InitialContext();
            tm = (TransactionManager)context.lookup("java:/TransactionManager");
            if (tm.getTransaction() != null) {
                oldTx = tm.suspend();
            }
            try {
                if (tm.getTransaction() == null) {
                    tm.begin();
                }
                if (result = this.deleteMonitorInfo()) {
                    tm.commit();
                }
            }
            catch (NotSupportedException e) {
                this.outputLog((Exception)((Object)e), "delete()");
                throw e;
            }
            catch (RollbackException e) {
                this.outputLog((Exception)((Object)e), "delete()");
                throw e;
            }
            catch (HeuristicMixedException e) {
                this.outputLog((Exception)((Object)e), "delete()");
                throw e;
            }
            catch (HeuristicRollbackException e) {
                this.outputLog((Exception)((Object)e), "delete()");
                throw e;
            }
            catch (SystemException e) {
                this.outputLog((Exception)((Object)e), "delete()");
                throw e;
            }
            catch (CreateException e) {
                this.outputLog((Exception)((Object)e), "delete()");
                throw e;
            }
            finally {
                if (tm.getTransaction() != null && !result) {
                    tm.rollback();
                }
            }
            if (oldTx == null) return result;
        }
        catch (Throwable throwable) {
            if (oldTx == null) throw throwable;
            try {
                tm.resume(oldTx);
                throw throwable;
            }
            catch (InvalidTransactionException e) {
                this.outputLog((Exception)((Object)e), "delete()");
                throw e;
            }
            catch (IllegalStateException e) {
                this.outputLog(e, "delete()");
                throw e;
            }
            catch (SystemException e) {
                this.outputLog((Exception)((Object)e), "delete()");
                throw e;
            }
        }
        try {
            tm.resume(oldTx);
            return result;
        }
        catch (InvalidTransactionException e) {
            this.outputLog((Exception)((Object)e), "delete()");
            throw e;
        }
        catch (IllegalStateException e) {
            this.outputLog(e, "delete()");
            throw e;
        }
        catch (SystemException e) {
            this.outputLog((Exception)((Object)e), "delete()");
            throw e;
        }
    }

    public abstract boolean deleteJudgementInfo() throws RemoveException, NamingException, CreateException, FinderException;

    public abstract boolean deleteCheckInfo() throws FinderException, RemoveException, NamingException;

    public boolean deleteMonitorInfo() throws FinderException, RemoveException, SchedulerException, NamingException, CreateException {
        try {
            MonitorInfoPK pk = new MonitorInfoPK(this.m_monitorId, this.m_monitorTypeId);
            this.m_monitor = MonitorInfoUtil.getLocalHome().findByPrimaryKey(pk);
            NotifyControllerLocal nc = NotifyControllerUtil.getLocalHome().create();
            nc.deleteNotifyInhibition(this.m_monitor.getNotifyGroupId());
            nc.deleteNotifyRelation(this.m_monitor.getNotifyGroupId());
            if (this.deleteCheckInfo() && this.deleteJudgementInfo()) {
                this.m_monitor.remove();
                ModifySchedule quartz = new ModifySchedule();
                quartz.deleteSchedule(this.m_monitorTypeId, this.m_monitorId);
                return true;
            }
        }
        catch (FinderException e) {
            this.outputLog((Exception)((Object)e), "deleteMonitorInfo()");
            throw e;
        }
        catch (RemoveException e) {
            this.outputLog((Exception)((Object)e), "deleteMonitorInfo()");
            throw e;
        }
        catch (SchedulerException e) {
            this.outputLog((Exception)((Object)e), "deleteMonitorInfo()");
            throw e;
        }
        catch (NamingException e) {
            this.outputLog(e, "deleteMonitorInfo()");
            throw e;
        }
        catch (CreateException e) {
            this.outputLog((Exception)((Object)e), "deleteMonitorInfo()");
            throw e;
        }
        return false;
    }

    private void outputLog(Exception e, String method) {
        AplLogger apllog = new AplLogger("MON", "mon");
        Object[] args = new String[]{this.m_monitorTypeId, this.m_monitorId};
        apllog.put("SYS", "009", args);
        m_log.debug((Object)(method + ":" + e.getMessage()));
    }
}

