/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.dao;

import com.clustercontrol.commons.util.ConnectionManager;
import com.clustercontrol.jobmanagement.dao.JobEndMasterDAO;
import com.clustercontrol.jobmanagement.ejb.entity.JobEndMasterBean;
import com.clustercontrol.jobmanagement.ejb.entity.JobEndMasterPK;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JobEndMasterDAOImpl
implements JobEndMasterDAO {
    protected static Log m_log = LogFactory.getLog(JobEndMasterDAOImpl.class);

    public void init() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load(JobEndMasterPK pk, JobEndMasterBean ejb) throws EJBException {
        m_log.debug((Object)("load() start : " + pk.toString()));
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "SELECT * FROM cc_job_end_mst WHERE job_id = ? AND end_status = ?";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, pk.getJob_id());
                stmt.setInt(2, pk.getEnd_status());
                res = stmt.executeQuery();
                if (!res.next()) {
                    String msg = "JobEndMaster data is not found.";
                    m_log.error((Object)("load() error : " + pk.toString() + " SQLException " + msg));
                    throw new EJBException(msg);
                }
                ejb.setEnd_status(res.getInt("end_status"));
                ejb.setEnd_value(res.getInt("end_value"));
                ejb.setEnd_value_from(res.getInt("end_value_from"));
                ejb.setEnd_value_to(res.getInt("end_value_to"));
                ejb.setJob_id(res.getString("job_id"));
                Object var9_9 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)("load() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("load() error : " + pk.toString() + " SQLException " + e1.getMessage()));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("load() error : " + pk.toString() + " SQLException " + e1.getMessage()));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (res != null) {
            res.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("load() end : " + pk.toString()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void store(JobEndMasterBean ejb) throws EJBException {
        m_log.debug((Object)("store() start : " + ejb.getJob_id() + ", " + ejb.getEnd_status()));
        Connection conn = null;
        Statement stmt = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                StringBuilder sql = new StringBuilder();
                sql.append("UPDATE cc_job_end_mst SET ");
                sql.append("end_value = ?, ");
                sql.append("end_value_from = ?, ");
                sql.append("end_value_to = ? ");
                sql.append("WHERE job_id = ? AND ");
                sql.append("end_status = ?");
                stmt = conn.prepareStatement(sql.toString());
                stmt.setInt(1, ejb.getEnd_value());
                stmt.setInt(2, ejb.getEnd_value_from());
                stmt.setInt(3, ejb.getEnd_value_to());
                stmt.setString(4, ejb.getJob_id());
                stmt.setInt(5, ejb.getEnd_status());
                int row = stmt.executeUpdate();
                if (row != 1) {
                    String msg = "result row is not 1";
                    m_log.error((Object)("store() error : " + ejb.getJob_id() + ", " + ejb.getJob_id() + " SQLException" + msg));
                    throw new EJBException(msg);
                }
                Object var8_8 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)("store() error : " + ejb.getJob_id() + ", " + ejb.getJob_id() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("store() error : " + ejb.getJob_id() + ", " + ejb.getJob_id() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("store() error : " + ejb.getJob_id() + ", " + ejb.getJob_id() + " SQLException"));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("store() end : " + ejb.getJob_id() + ", " + ejb.getEnd_status()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void remove(JobEndMasterPK pk) throws RemoveException, EJBException {
        m_log.debug((Object)("remove() start : " + pk.toString()));
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "DELETE FROM cc_job_end_mst WHERE job_id = ? AND end_status = ?";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, pk.getJob_id());
                stmt.setInt(2, pk.getEnd_status());
                int row = stmt.executeUpdate();
                if (row != 1) {
                    String msg = "result row is not 1";
                    m_log.error((Object)("remove() error : " + pk.toString() + " SQLException" + msg));
                    throw new EJBException(msg);
                }
                Object var8_8 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("remove() end : " + pk.toString()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JobEndMasterPK create(JobEndMasterBean ejb) throws CreateException, EJBException {
        JobEndMasterPK pk;
        m_log.debug((Object)("create() start : " + ejb.getJob_id() + ", " + ejb.getEnd_status()));
        Connection conn = null;
        Statement stmt = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                StringBuilder sql = new StringBuilder();
                sql.append("INSERT INTO cc_job_end_mst (");
                sql.append("job_id, ");
                sql.append("end_status, ");
                sql.append("end_value, ");
                sql.append("end_value_from, ");
                sql.append("end_value_to) ");
                sql.append("VALUES (?,?,?,?,?)");
                stmt = conn.prepareStatement(sql.toString());
                stmt.setString(1, ejb.getJob_id());
                stmt.setInt(2, ejb.getEnd_status());
                stmt.setInt(3, ejb.getEnd_value());
                stmt.setInt(4, ejb.getEnd_value_from());
                stmt.setInt(5, ejb.getEnd_value_to());
                int row = stmt.executeUpdate();
                pk = new JobEndMasterPK(ejb.getJob_id(), ejb.getEnd_status());
                if (row != 1) {
                    String msg = "result row is not 1";
                    m_log.error((Object)("create() error : " + ejb.getJob_id() + ", " + ejb.getEnd_status() + " SQLException"));
                    throw new EJBException(msg);
                }
                Object var9_9 = null;
            }
            catch (SQLException e) {
                if (!e.getSQLState().equals("23505")) throw new CreateException(e.getMessage());
                m_log.error((Object)("create() error : " + ejb.getJob_id() + ", " + ejb.getEnd_status() + " SQLException" + "DuplicateKeyException "));
                throw new DuplicateKeyException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("create() error : " + ejb.getJob_id() + ", " + ejb.getEnd_status() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("create() error : " + ejb.getJob_id() + ", " + ejb.getEnd_status() + " SQLException"));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("create() end : " + ejb.getJob_id() + ", " + ejb.getEnd_status()));
        return pk;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection findAll() throws FinderException {
        m_log.debug((Object)"findAll() start : ");
        ArrayList<JobEndMasterPK> ret = new ArrayList<JobEndMasterPK>();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "SELECT * FROM cc_job_end_mst";
                stmt = conn.prepareStatement(sql);
                res = stmt.executeQuery();
                while (res.next()) {
                    JobEndMasterPK pk = new JobEndMasterPK(res.getString("job_id"), res.getInt("end_status"));
                    ret.add(pk);
                }
                Object var8_8 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)"findAll() error :  SQLException");
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)"findAll() error :  SQLException");
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)"findAll() error :  SQLException");
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (res != null) {
            res.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)"findAll() end : ");
        return ret;
    }

    public JobEndMasterPK findByPrimaryKey(JobEndMasterPK pk) throws FinderException {
        ResultSet res;
        PreparedStatement stmt;
        Connection conn;
        block14: {
            m_log.debug((Object)("findByPrimaryKey() start : " + pk.toString()));
            conn = null;
            stmt = null;
            res = null;
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT * FROM cc_job_end_mst WHERE job_id = ? AND end_status = ?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, pk.getJob_id());
            stmt.setInt(2, pk.getEnd_status());
            res = stmt.executeQuery();
            if (!res.next()) break block14;
            JobEndMasterPK jobEndMasterPK = pk;
            Object var8_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("findByPrimaryKey() end : " + pk.toString()));
            return jobEndMasterPK;
        }
        try {
            try {
                String msg = "id " + pk.toString() + " not found.";
                throw new FinderException(msg);
            }
            catch (SQLException e) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("findByPrimaryKey() end : " + pk.toString()));
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection findByJobId(String job_id) throws FinderException {
        m_log.debug((Object)("findByJobId() start : " + job_id));
        ArrayList<JobEndMasterPK> ret = new ArrayList<JobEndMasterPK>();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "SELECT * FROM cc_job_end_mst WHERE job_id = ?";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, job_id);
                res = stmt.executeQuery();
                while (res.next()) {
                    JobEndMasterPK pk = new JobEndMasterPK(res.getString("job_id"), res.getInt("end_status"));
                    ret.add(pk);
                }
                Object var9_9 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)("findByJobId() error : " + job_id + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("findByJobId() error : " + job_id + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("findByJobId() error : " + job_id + " SQLException"));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (res != null) {
            res.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("findByJobId() end : " + job_id));
        return ret;
    }
}

