/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.poller.snmp;

import com.clustercontrol.poller.snmp.SnmpConfig;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnmpPollingConfig {
    private static Log m_log = LogFactory.getLog(SnmpPollingConfig.class);
    private Object modifyLock = new Object();
    private SnmpConfig m_snmpConfig;
    private boolean m_indexCheckFlg;
    private ConcurrentHashMap<String, IntervalAndOids> m_targetOidMap;
    private ConcurrentHashMap<String, IntervalAndNextTime> m_scheduleMap;
    private ConcurrentHashMap<Integer, Long> m_refreshTableTimes;
    private int m_minPollingInterval = -1;

    public SnmpPollingConfig(SnmpConfig config, boolean indexCheckFlg) {
        this.m_snmpConfig = config;
        this.m_targetOidMap = new ConcurrentHashMap();
        this.m_scheduleMap = new ConcurrentHashMap();
        this.m_refreshTableTimes = new ConcurrentHashMap();
        this.m_indexCheckFlg = indexCheckFlg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPollingOids(String collectorName, int interval, List<String> oids) {
        Object object = this.modifyLock;
        synchronized (object) {
            this.m_targetOidMap.put(collectorName, new IntervalAndOids(interval, oids));
        }
        this.rescheduling();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removePollingOids(String collectorName) {
        Object object = this.modifyLock;
        synchronized (object) {
            this.m_targetOidMap.remove(collectorName);
        }
        return this.rescheduling();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removePollingAllOids() {
        Object object = this.modifyLock;
        synchronized (object) {
            this.m_targetOidMap.clear();
        }
        return this.rescheduling();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean rescheduling() {
        Object object = this.modifyLock;
        synchronized (object) {
            boolean modifyFlg = false;
            this.m_scheduleMap.clear();
            this.m_minPollingInterval = Integer.MAX_VALUE;
            for (String collectorName : this.m_targetOidMap.keySet()) {
                IntervalAndOids setting = this.m_targetOidMap.get(collectorName);
                List<String> oidList = setting.getOidList();
                int interval = setting.getPollingInterval();
                if (this.m_minPollingInterval > interval) {
                    m_log.debug((Object)("Set Min Polling Intreval : " + interval));
                    this.m_minPollingInterval = interval;
                    modifyFlg = true;
                }
                for (String oid : oidList) {
                    if (this.m_scheduleMap.get(oid) != null) {
                        if (this.m_scheduleMap.get(oid).getPollingInterval() <= interval) continue;
                        this.m_scheduleMap.get(oid).setPollingInterval(interval);
                        continue;
                    }
                    this.m_scheduleMap.put(oid, new IntervalAndNextTime(interval));
                }
                if (this.m_refreshTableTimes.get(interval) != null) continue;
                this.m_refreshTableTimes.put(interval, 0L);
            }
            if (this.m_minPollingInterval == Integer.MAX_VALUE) {
                this.m_minPollingInterval = -1;
                modifyFlg = true;
            }
            return modifyFlg;
        }
    }

    public List<String> getCurrentTargetOids(long currentTime) {
        ArrayList<String> currentTarget = new ArrayList<String>();
        for (String oid : this.m_scheduleMap.keySet()) {
            if (this.m_scheduleMap.get(oid) == null) continue;
            long nextPollingTime = this.m_scheduleMap.get(oid).getNextPollingTime();
            int interval = this.m_scheduleMap.get(oid).getPollingInterval();
            if (nextPollingTime > currentTime) continue;
            currentTarget.add(oid);
            long intervalMillis = (long)interval * 1000L;
            long count = (currentTime - nextPollingTime) / intervalMillis;
            this.m_scheduleMap.get(oid).setNextPollingTime(nextPollingTime += intervalMillis * (count + 1L));
        }
        return currentTarget;
    }

    public List<Integer> getCurrentRefreshIntervals(long currentTime) {
        m_log.debug((Object)("current time : " + currentTime));
        ArrayList<Integer> currentTarget = new ArrayList<Integer>();
        Iterator itr = this.m_refreshTableTimes.keySet().iterator();
        while (itr.hasNext()) {
            int interval = (Integer)itr.next();
            long nextTime = this.m_refreshTableTimes.get(interval);
            if (nextTime > currentTime) continue;
            currentTarget.add(interval);
            long intervalMillis = (long)interval * 1000L;
            long count = (currentTime - nextTime) / intervalMillis;
            m_log.debug((Object)("put nexttime : " + interval + ", " + (nextTime += intervalMillis * (count + 1L))));
            this.m_refreshTableTimes.put(interval, nextTime);
        }
        return currentTarget;
    }

    public Set<String> getCollectorNames() {
        return this.m_targetOidMap.keySet();
    }

    public SnmpConfig getSnmpConfig() {
        return this.m_snmpConfig;
    }

    public void setSnmpConfig(SnmpConfig config) {
        this.m_snmpConfig = config;
    }

    public int getMinPollingInterval() {
        return this.m_minPollingInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsCollectorName(String collectorName) {
        Object object = this.modifyLock;
        synchronized (object) {
            return this.m_targetOidMap.containsKey(collectorName);
        }
    }

    public boolean isIndexCheckFlg() {
        return this.m_indexCheckFlg;
    }

    public String getDebugInfo() {
        String debugStr = "";
        for (String collectorName : this.m_targetOidMap.keySet()) {
            List oidList = this.m_targetOidMap.get(collectorName).m_oidList;
            int interval = this.m_targetOidMap.get(collectorName).getPollingInterval();
            String str = "\t" + collectorName + "  interval : " + interval + "\n";
            for (String oid : oidList) {
                IntervalAndNextTime ian = this.m_scheduleMap.get(oid);
                str = str + "\t" + oid + "\t" + ian.getPollingInterval() + "\t" + new Date(ian.getNextPollingTime()) + "\n";
            }
            debugStr = debugStr + str;
        }
        return debugStr;
    }

    private class IntervalAndNextTime {
        private int m_pollingInterval;
        private long m_nextPollingTime;

        public IntervalAndNextTime(int pollingInterval) {
            this.m_pollingInterval = pollingInterval;
            this.m_nextPollingTime = 0L;
        }

        public int getPollingInterval() {
            return this.m_pollingInterval;
        }

        public void setPollingInterval(int interval) {
            this.m_pollingInterval = interval;
        }

        public long getNextPollingTime() {
            return this.m_nextPollingTime;
        }

        public void setNextPollingTime(long nextPollingTime) {
            this.m_nextPollingTime = nextPollingTime;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IntervalAndOids {
        private int m_pollingInterval;
        private List<String> m_oidList;

        public IntervalAndOids(int pollingInterval, List<String> oidList) {
            this.m_pollingInterval = pollingInterval;
            this.m_oidList = oidList;
        }

        public int getPollingInterval() {
            return this.m_pollingInterval;
        }

        public List<String> getOidList() {
            return this.m_oidList;
        }
    }
}

