/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.framework.configuration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.avalon.framework.configuration.AbstractConfiguration;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.ConfigurationUtil;

public class DefaultConfiguration
extends AbstractConfiguration
implements Serializable {
    protected static final Configuration[] EMPTY_ARRAY = new Configuration[0];
    private final String m_name;
    private final String m_location;
    private final String m_namespace;
    private final String m_prefix;
    private HashMap m_attributes;
    private ArrayList m_children;
    private String m_value;
    private boolean m_readOnly;

    public DefaultConfiguration(String name) {
        this(name, null, "", "");
    }

    public DefaultConfiguration(String name, String location) {
        this(name, location, "", "");
    }

    public DefaultConfiguration(String name, String location, String ns, String prefix) {
        this.m_name = name;
        this.m_location = location;
        this.m_namespace = ns;
        this.m_prefix = prefix;
    }

    public String getName() {
        return this.m_name;
    }

    public String getNamespace() throws ConfigurationException {
        if (null != this.m_namespace) {
            return this.m_namespace;
        }
        throw new ConfigurationException("No namespace (not even default \"\") is associated with the configuration element \"" + this.getName() + "\" at " + this.getLocation());
    }

    protected String getPrefix() throws ConfigurationException {
        if (null != this.m_prefix) {
            return this.m_prefix;
        }
        throw new ConfigurationException("No prefix (not even default \"\") is associated with the configuration element \"" + this.getName() + "\" at " + this.getLocation());
    }

    public String getLocation() {
        return this.m_location;
    }

    public String getValue(String defaultValue) {
        if (null != this.m_value) {
            return this.m_value;
        }
        return defaultValue;
    }

    public String getValue() throws ConfigurationException {
        if (null != this.m_value) {
            return this.m_value;
        }
        throw new ConfigurationException("No value is associated with the configuration element \"" + this.getName() + "\" at " + this.getLocation());
    }

    public String[] getAttributeNames() {
        if (null == this.m_attributes) {
            return new String[0];
        }
        return this.m_attributes.keySet().toArray(new String[0]);
    }

    public Configuration[] getChildren() {
        if (null == this.m_children) {
            return new Configuration[0];
        }
        return this.m_children.toArray(new Configuration[0]);
    }

    public String getAttribute(String name) throws ConfigurationException {
        String value;
        String string = value = null != this.m_attributes ? (String)this.m_attributes.get(name) : null;
        if (null != value) {
            return value;
        }
        throw new ConfigurationException("No attribute named \"" + name + "\" is " + "associated with the configuration element \"" + this.getName() + "\" at " + this.getLocation());
    }

    public Configuration getChild(String name, boolean createNew) {
        if (null != this.m_children) {
            int size = this.m_children.size();
            for (int i = 0; i < size; ++i) {
                Configuration configuration = (Configuration)this.m_children.get(i);
                if (!name.equals(configuration.getName())) continue;
                return configuration;
            }
        }
        if (createNew) {
            return new DefaultConfiguration(name, "<generated>" + this.getLocation(), this.m_namespace, this.m_prefix);
        }
        return null;
    }

    public Configuration[] getChildren(String name) {
        if (null == this.m_children) {
            return new Configuration[0];
        }
        ArrayList<Configuration> children = new ArrayList<Configuration>();
        int size = this.m_children.size();
        for (int i = 0; i < size; ++i) {
            Configuration configuration = (Configuration)this.m_children.get(i);
            if (!name.equals(configuration.getName())) continue;
            children.add(configuration);
        }
        return children.toArray(new Configuration[0]);
    }

    public void appendValueData(String value) {
        this.checkWriteable();
        this.m_value = null == this.m_value ? value : this.m_value + value;
    }

    public void setValue(String value) {
        this.checkWriteable();
        this.m_value = value;
    }

    public void setAttribute(String name, String value) {
        this.checkWriteable();
        if (null == this.m_attributes) {
            this.m_attributes = new HashMap();
        }
        this.m_attributes.put(name, value);
    }

    public String addAttribute(String name, String value) {
        this.checkWriteable();
        if (null == this.m_attributes) {
            this.m_attributes = new HashMap();
        }
        return this.m_attributes.put(name, value);
    }

    public void addChild(Configuration configuration) {
        this.checkWriteable();
        if (null == this.m_children) {
            this.m_children = new ArrayList();
        }
        this.m_children.add(configuration);
    }

    public void addAll(Configuration other) {
        this.checkWriteable();
        this.setValue(other.getValue(null));
        this.addAllAttributes(other);
        this.addAllChildren(other);
    }

    public void addAllAttributes(Configuration other) {
        this.checkWriteable();
        String[] attributes = other.getAttributeNames();
        for (int i = 0; i < attributes.length; ++i) {
            String name = attributes[i];
            String value = other.getAttribute(name, null);
            this.setAttribute(name, value);
        }
    }

    public void addAllChildren(Configuration other) {
        this.checkWriteable();
        Configuration[] children = other.getChildren();
        for (int i = 0; i < children.length; ++i) {
            this.addChild(children[i]);
        }
    }

    public void removeChild(Configuration configuration) {
        this.checkWriteable();
        if (null == this.m_children) {
            return;
        }
        this.m_children.remove(configuration);
    }

    public int getChildCount() {
        if (null == this.m_children) {
            return 0;
        }
        return this.m_children.size();
    }

    public void makeReadOnly() {
        this.m_readOnly = true;
    }

    protected final void checkWriteable() throws IllegalStateException {
        if (this.m_readOnly) {
            throw new IllegalStateException("Configuration is read only and can not be modified");
        }
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof Configuration)) {
            return false;
        }
        return ConfigurationUtil.equals(this, (Configuration)other);
    }

    public int hashCode() {
        int hash = this.m_prefix.hashCode();
        if (this.m_name != null) {
            hash ^= this.m_name.hashCode();
        }
        hash >>>= 7;
        if (this.m_location != null) {
            hash ^= this.m_location.hashCode();
        }
        hash >>>= 7;
        if (this.m_namespace != null) {
            hash ^= this.m_namespace.hashCode();
        }
        hash >>>= 7;
        if (this.m_attributes != null) {
            hash ^= this.m_attributes.hashCode();
        }
        hash >>>= 7;
        if (this.m_children != null) {
            hash ^= this.m_children.hashCode();
        }
        hash >>>= 7;
        if (this.m_value != null) {
            hash ^= this.m_value.hashCode();
        }
        hash >>>= 7;
        return hash ^= this.m_readOnly ? 1 : 3;
    }
}

