/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.server;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.HashMap;
import javax.xml.namespace.QName;
import javax.xml.rpc.server.ServiceLifecycle;
import javax.xml.rpc.server.ServletEndpointContext;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.handler.MessageContext;
import org.jboss.logging.Logger;
import org.jboss.ws.Constants;
import org.jboss.ws.core.CommonBinding;
import org.jboss.ws.core.CommonBindingProvider;
import org.jboss.ws.core.CommonMessageContext;
import org.jboss.ws.core.CommonSOAPBinding;
import org.jboss.ws.core.CommonSOAPFaultException;
import org.jboss.ws.core.DirectionHolder;
import org.jboss.ws.core.EndpointInvocation;
import org.jboss.ws.core.MessageAbstraction;
import org.jboss.ws.core.jaxrpc.ServletEndpointContextImpl;
import org.jboss.ws.core.jaxrpc.handler.HandlerDelegateJAXRPC;
import org.jboss.ws.core.jaxrpc.handler.MessageContextJAXRPC;
import org.jboss.ws.core.jaxrpc.handler.SOAPMessageContextJAXRPC;
import org.jboss.ws.core.jaxws.binding.BindingProviderImpl;
import org.jboss.ws.core.jaxws.handler.HandlerDelegateJAXWS;
import org.jboss.ws.core.jaxws.handler.MessageContextJAXWS;
import org.jboss.ws.core.jaxws.handler.SOAPMessageContextJAXWS;
import org.jboss.ws.core.server.DelegatingInvocation;
import org.jboss.ws.core.server.ServerHandlerDelegate;
import org.jboss.ws.core.server.ServletRequestContext;
import org.jboss.ws.core.soap.MessageContextAssociation;
import org.jboss.ws.core.soap.SOAPBodyImpl;
import org.jboss.ws.core.soap.SOAPMessageImpl;
import org.jboss.ws.extensions.xop.XOPContext;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.OperationMetaData;
import org.jboss.ws.metadata.umdm.ServerEndpointMetaData;
import org.jboss.wsf.common.JavaUtils;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.invocation.ExtensibleWebServiceContext;
import org.jboss.wsf.spi.invocation.Invocation;
import org.jboss.wsf.spi.invocation.InvocationContext;
import org.jboss.wsf.spi.invocation.InvocationHandler;
import org.jboss.wsf.spi.invocation.InvocationType;
import org.jboss.wsf.spi.invocation.WebServiceContextFactory;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;

public class ServiceEndpointInvoker {
    private static final Logger log = Logger.getLogger(ServiceEndpointInvoker.class);
    protected Endpoint endpoint;
    protected CommonBindingProvider bindingProvider;
    protected ServerHandlerDelegate delegate;
    private WebServiceContextFactory contextFactory;

    public ServiceEndpointInvoker() {
        SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
        this.contextFactory = spiProvider.getSPI(WebServiceContextFactory.class);
    }

    public void init(Endpoint endpoint) {
        this.endpoint = endpoint;
        ServerEndpointMetaData sepMetaData = endpoint.getAttachment(ServerEndpointMetaData.class);
        if (sepMetaData == null) {
            throw new IllegalStateException("Cannot obtain endpoint meta data");
        }
        if (sepMetaData.getType() == EndpointMetaData.Type.JAXRPC) {
            this.bindingProvider = new CommonBindingProvider(sepMetaData);
            this.delegate = new HandlerDelegateJAXRPC(sepMetaData);
        } else {
            this.bindingProvider = new BindingProviderImpl(sepMetaData);
            this.delegate = new HandlerDelegateJAXWS(sepMetaData);
        }
    }

    public boolean callRequestHandlerChain(ServerEndpointMetaData sepMetaData, UnifiedHandlerMetaData.HandlerType type) {
        return this.delegate.callRequestHandlerChain(sepMetaData, type);
    }

    public boolean callResponseHandlerChain(ServerEndpointMetaData sepMetaData, UnifiedHandlerMetaData.HandlerType type) {
        return this.delegate.callResponseHandlerChain(sepMetaData, type);
    }

    public void closeHandlerChain(ServerEndpointMetaData sepMetaData, UnifiedHandlerMetaData.HandlerType type) {
        this.delegate.closeHandlerChain(sepMetaData, type);
    }

    public boolean callFaultHandlerChain(ServerEndpointMetaData sepMetaData, UnifiedHandlerMetaData.HandlerType type, Exception ex) {
        return this.delegate.callFaultHandlerChain(sepMetaData, type, ex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(InvocationContext invContext) throws Exception {
        CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
        ServerEndpointMetaData sepMetaData = (ServerEndpointMetaData)msgContext.getEndpointMetaData();
        MessageAbstraction reqMessage = msgContext.getMessageAbstraction();
        DirectionHolder direction = new DirectionHolder(DirectionHolder.Direction.InBound);
        UnifiedHandlerMetaData.HandlerType[] handlerType = this.delegate.getHandlerTypeOrder();
        UnifiedHandlerMetaData.HandlerType[] faultType = this.delegate.getHandlerTypeOrder();
        this.setInboundContextProperties();
        try {
            boolean oneway = false;
            EndpointInvocation sepInv = null;
            OperationMetaData opMetaData = null;
            CommonBinding binding = this.bindingProvider.getCommonBinding();
            binding.setHeaderSource(this.delegate);
            boolean handlersPass = this.callRequestHandlerChain(sepMetaData, handlerType[0]);
            if (handlersPass) {
                opMetaData = this.getDispatchDestination(sepMetaData, reqMessage);
                msgContext.setOperationMetaData(opMetaData);
                oneway = opMetaData.isOneWay();
                if (binding instanceof CommonSOAPBinding) {
                    ((CommonSOAPBinding)binding).checkMustUnderstand(opMetaData);
                }
                sepInv = binding.unbindRequestMessage(opMetaData, reqMessage);
            }
            handlersPass = handlersPass && this.callRequestHandlerChain(sepMetaData, handlerType[1]);
            boolean bl = handlersPass = handlersPass && this.callRequestHandlerChain(sepMetaData, handlerType[2]);
            if (handlersPass) {
                msgContext.put(CommonMessageContext.ALLOW_EXPAND_TO_DOM, (Object)Boolean.TRUE);
                try {
                    if (msgContext.isModified()) {
                        log.debug((Object)"Handler modified payload, unbind message again");
                        reqMessage = msgContext.getMessageAbstraction();
                        sepInv = binding.unbindRequestMessage(opMetaData, reqMessage);
                    }
                    Invocation inv = this.setupInvocation(this.endpoint, sepInv, invContext);
                    InvocationHandler invHandler = this.endpoint.getInvocationHandler();
                    try {
                        invHandler.invoke(this.endpoint, inv);
                    }
                    catch (InvocationTargetException th) {
                        Throwable targetEx = th.getTargetException();
                        throw targetEx instanceof Exception ? (Exception)targetEx : new UndeclaredThrowableException(targetEx);
                    }
                    sepInv = inv.getInvocationContext().getAttachment(EndpointInvocation.class);
                }
                finally {
                    msgContext.remove(CommonMessageContext.ALLOW_EXPAND_TO_DOM);
                }
                msgContext = this.processPivotInternal(msgContext, direction);
                this.setOutboundContextProperties();
                if (binding instanceof CommonSOAPBinding) {
                    XOPContext.setMTOMEnabled(((CommonSOAPBinding)binding).isMTOMEnabled());
                }
                MessageAbstraction resMessage = binding.bindResponseMessage(opMetaData, sepInv);
                msgContext.setMessageAbstraction(resMessage);
            } else {
                MessageAbstraction resMessage = msgContext.getMessageAbstraction();
                msgContext = this.processPivotInternal(msgContext, direction);
                msgContext.setMessageAbstraction(resMessage);
            }
            if (!oneway) {
                handlersPass = this.callResponseHandlerChain(sepMetaData, handlerType[2]);
                faultType[2] = null;
                handlersPass = handlersPass && this.callResponseHandlerChain(sepMetaData, handlerType[1]);
                faultType[1] = null;
                handlersPass = handlersPass && this.callResponseHandlerChain(sepMetaData, handlerType[0]);
                faultType[0] = null;
            }
        }
        catch (RuntimeException ex) {
            this.processPivotInternal(msgContext, direction);
            try {
                CommonBinding binding = this.bindingProvider.getCommonBinding();
                binding.bindFaultMessage(ex);
                boolean handlersPass = true;
                if (faultType[2] != null) {
                    boolean bl = handlersPass = handlersPass && this.callFaultHandlerChain(sepMetaData, faultType[2], ex);
                }
                if (faultType[1] != null) {
                    boolean bl = handlersPass = handlersPass && this.callFaultHandlerChain(sepMetaData, faultType[1], ex);
                }
                if (faultType[0] != null) {
                    handlersPass = handlersPass && this.callFaultHandlerChain(sepMetaData, faultType[0], ex);
                }
            }
            catch (RuntimeException subEx) {
                log.warn((Object)"Exception while processing handleFault: ", (Throwable)ex);
                ex = subEx;
            }
            throw ex;
        }
        finally {
            this.closeHandlerChain(sepMetaData, handlerType[2]);
            this.closeHandlerChain(sepMetaData, handlerType[1]);
            this.closeHandlerChain(sepMetaData, handlerType[0]);
        }
    }

    protected Invocation setupInvocation(Endpoint ep, EndpointInvocation epInv, InvocationContext invContext) throws Exception {
        CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
        if (msgContext instanceof SOAPMessageContextJAXWS) {
            if (ep.getService().getDeployment().getType() == Deployment.DeploymentType.JAXWS_JSE) {
                if (msgContext.get("javax.xml.ws.servlet.request") != null) {
                    ExtensibleWebServiceContext wsContext = this.contextFactory.newWebServiceContext(InvocationType.JAXWS_JSE, (SOAPMessageContextJAXWS)msgContext);
                    invContext.addAttachment(WebServiceContext.class, wsContext);
                } else {
                    log.warn((Object)"Cannot provide WebServiceContext, since the current MessageContext does not provide a ServletRequest");
                }
            }
            invContext.addAttachment(MessageContext.class, msgContext);
        }
        if (msgContext instanceof SOAPMessageContextJAXRPC) {
            invContext.addAttachment(javax.xml.rpc.handler.MessageContext.class, msgContext);
        }
        if (ServiceLifecycle.class.isAssignableFrom(ep.getTargetBeanClass()) && invContext instanceof ServletRequestContext) {
            ServletEndpointContextImpl servletEndpointContext = new ServletEndpointContextImpl((ServletRequestContext)invContext);
            invContext.addAttachment(ServletEndpointContext.class, servletEndpointContext);
        }
        invContext.addAttachment(EndpointInvocation.class, epInv);
        DelegatingInvocation wsInv = new DelegatingInvocation();
        wsInv.setInvocationContext(invContext);
        wsInv.setJavaMethod(this.getImplMethod(this.endpoint, epInv));
        return wsInv;
    }

    protected Method getImplMethod(Endpoint endpoint, EndpointInvocation sepInv) throws ClassNotFoundException, NoSuchMethodException {
        Class implClass = endpoint.getTargetBeanClass();
        Method seiMethod = sepInv.getJavaMethod();
        String methodName = seiMethod.getName();
        Class<?>[] paramTypes = seiMethod.getParameterTypes();
        for (int i = 0; i < paramTypes.length; ++i) {
            Class paramType = paramTypes[i];
            if (JavaUtils.isPrimitive(paramType)) continue;
            String paramTypeName = paramType.getName();
            paramTypes[i] = paramType = JavaUtils.loadJavaType(paramTypeName);
        }
        Method implMethod = null;
        try {
            implMethod = implClass.getMethod(methodName, paramTypes);
        }
        catch (NoSuchMethodException ex) {
            log.error((Object)("CodeSource: " + implClass.getProtectionDomain().getCodeSource()));
            log.error((Object)("ClassLoader: " + implClass.getClassLoader()));
            throw ex;
        }
        return implMethod;
    }

    protected void setInboundContextProperties() {
        CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
        if (msgContext instanceof MessageContextJAXWS) {
            msgContext.put("javax.xml.ws.binding.attachments.inbound", (Object)new HashMap());
        }
    }

    protected void setOutboundContextProperties() {
        CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
        if (msgContext instanceof MessageContextJAXWS) {
            msgContext.put("javax.xml.ws.binding.attachments.outbound", (Object)new HashMap());
        }
    }

    private CommonMessageContext processPivotInternal(CommonMessageContext msgContext, DirectionHolder direction) {
        if (direction.getDirection() == DirectionHolder.Direction.InBound) {
            EndpointMetaData epMetaData = msgContext.getEndpointMetaData();
            msgContext = epMetaData.getType() == EndpointMetaData.Type.JAXRPC ? MessageContextJAXRPC.processPivot(msgContext) : MessageContextJAXWS.processPivot(msgContext);
            direction.setDirection(DirectionHolder.Direction.OutBound);
        }
        return msgContext;
    }

    private OperationMetaData getDispatchDestination(EndpointMetaData epMetaData, MessageAbstraction reqMessage) throws SOAPException {
        OperationMetaData opMetaData;
        String bindingID = epMetaData.getBindingId();
        if ("http://www.w3.org/2004/08/wsdl/http".equals(bindingID)) {
            if (epMetaData.getOperations().size() != 1) {
                throw new IllegalStateException("Multiple operations not supported for HTTP binding");
            }
            opMetaData = epMetaData.getOperations().get(0);
        } else {
            SOAPMessageImpl soapMessage = (SOAPMessageImpl)reqMessage;
            opMetaData = soapMessage.getOperationMetaData(epMetaData);
            SOAPHeader soapHeader = soapMessage.getSOAPHeader();
            if (opMetaData == null) {
                QName faultCode;
                String faultString;
                SOAPBodyImpl soapBody = (SOAPBodyImpl)soapMessage.getSOAPBody();
                SOAPBodyElement soapBodyElement = soapBody.getBodyElement();
                if (soapBodyElement != null) {
                    Name soapName = soapBodyElement.getElementName();
                    faultString = "Endpoint " + epMetaData.getPortName() + " does not contain operation meta data for: " + soapName;
                } else {
                    faultString = "Endpoint " + epMetaData.getPortName() + " does not contain operation meta data for empty soap body";
                }
                if (soapHeader != null && soapHeader.examineMustUnderstandHeaderElements("http://schemas.xmlsoap.org/soap/actor/next").hasNext()) {
                    faultCode = Constants.SOAP11_FAULT_CODE_MUST_UNDERSTAND;
                    throw new CommonSOAPFaultException(faultCode, faultString);
                }
                faultCode = Constants.SOAP11_FAULT_CODE_CLIENT;
                throw new CommonSOAPFaultException(faultCode, faultString);
            }
        }
        return opMetaData;
    }
}

