/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.util.tracing;

import org.jacorb.util.tracing.ClientTraceInterceptor;
import org.jacorb.util.tracing.ServerTraceInterceptor;
import org.jacorb.util.tracing.TracingService;
import org.jacorb.util.tracing.TracingServiceHelper;
import org.omg.CORBA.LocalObject;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.IOP.Codec;
import org.omg.IOP.Encoding;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitializer;

public class TraceInitializer
extends LocalObject
implements ORBInitializer {
    public void post_init(ORBInitInfo oRBInitInfo) {
        try {
            int n = oRBInitInfo.allocate_slot_id();
            NamingContextExt namingContextExt = NamingContextExtHelper.narrow(oRBInitInfo.resolve_initial_references("NameService"));
            TracingService tracingService = TracingServiceHelper.narrow(namingContextExt.resolve(namingContextExt.to_name("tracing.service")));
            if (tracingService == null) {
                System.err.println("No Tracing Service, cannot register tracer interceptor!");
                return;
            }
            Encoding encoding = new Encoding(0, 1, 0);
            Codec codec = oRBInitInfo.codec_factory().create_codec(encoding);
            ClientTraceInterceptor clientTraceInterceptor = new ClientTraceInterceptor(codec, n, tracingService);
            oRBInitInfo.add_client_request_interceptor(clientTraceInterceptor);
            oRBInitInfo.add_server_request_interceptor(new ServerTraceInterceptor(n, codec));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void pre_init(ORBInitInfo oRBInitInfo) {
    }
}

