/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.poa;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.dsi.ServerRequest;
import org.jacorb.poa.EventMulticaster;
import org.jacorb.poa.RequestController;
import org.jacorb.poa.RequestQueueListener;
import org.jacorb.poa.except.ResourceLimitReachedException;
import org.jacorb.poa.util.StringPair;
import org.jacorb.util.ObjectUtil;
import org.omg.CORBA.BAD_INV_ORDER;

public class RequestQueue
implements Configurable {
    private RequestQueueListener queueListener;
    private final RequestController controller;
    private org.jacorb.config.Configuration configuration = null;
    private Logger logger;
    private int queueMin;
    private int queueMax;
    private boolean queueWait;
    private List queueListeners;
    private boolean configured = false;
    private final LinkedList queue = new LinkedList();

    protected RequestQueue(RequestController requestController) {
        this.controller = requestController;
    }

    public synchronized void configure(Configuration configuration) throws ConfigurationException {
        if (this.configured) {
            return;
        }
        this.configuration = (org.jacorb.config.Configuration)configuration;
        this.logger = this.configuration.getNamedLogger("jacorb.poa.queue");
        this.queueMax = this.configuration.getAttributeAsInteger("jacorb.poa.queue_max", 100);
        this.queueMin = this.configuration.getAttributeAsInteger("jacorb.poa.queue_min", 10);
        this.queueWait = this.configuration.getAttributeAsBoolean("jacorb.poa.queue_wait", false);
        this.queueListeners = this.configuration.getAttributeList("jacorb.poa.queue_listeners");
        this.configured = true;
        Iterator iterator = this.queueListeners.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            try {
                RequestQueueListener requestQueueListener = (RequestQueueListener)ObjectUtil.classForName(string).newInstance();
                this.addRequestQueueListener(requestQueueListener);
            }
            catch (Exception exception) {
                throw new ConfigurationException("could not instantiate queue listener", (Throwable)exception);
            }
        }
    }

    protected synchronized void add(ServerRequest serverRequest) throws ResourceLimitReachedException {
        this.checkIsConfigured();
        if (this.queue.size() >= this.queueMax) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Request queue is full, consider increasing jacorb.poa.queue_max (currently: " + this.queueMax + ")");
            }
            if (this.queueWait) {
                while (this.queue.size() > this.queueMin) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            } else {
                throw new ResourceLimitReachedException();
            }
        }
        this.queue.add(serverRequest);
        if (this.queue.size() == 1) {
            this.controller.continueToWork();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("rid: " + serverRequest.requestId() + " opname: " + serverRequest.operation() + " is queued (queue size: " + this.queue.size() + ")");
        }
        if (this.queueListener != null) {
            this.queueListener.requestAddedToQueue(serverRequest, this.queue.size());
        }
    }

    protected synchronized void addRequestQueueListener(RequestQueueListener requestQueueListener) {
        this.checkIsConfigured();
        this.queueListener = EventMulticaster.add(this.queueListener, requestQueueListener);
    }

    protected synchronized StringPair[] deliverContent() {
        this.checkIsConfigured();
        StringPair[] stringPairArray = new StringPair[this.queue.size()];
        Iterator iterator = this.queue.iterator();
        for (int i = 0; i < stringPairArray.length; ++i) {
            ServerRequest serverRequest = (ServerRequest)iterator.next();
            stringPairArray[i] = new StringPair(Integer.toString(serverRequest.requestId()), new String(serverRequest.objectId()));
        }
        return stringPairArray;
    }

    protected synchronized ServerRequest getElementAndRemove(int n) {
        this.checkIsConfigured();
        if (!this.queue.isEmpty()) {
            Iterator iterator = this.queue.iterator();
            while (iterator.hasNext()) {
                ServerRequest serverRequest = (ServerRequest)iterator.next();
                if (serverRequest.requestId() != n) continue;
                iterator.remove();
                this.notifyAll();
                if (this.queueListener != null) {
                    this.queueListener.requestRemovedFromQueue(serverRequest, this.queue.size());
                }
                return serverRequest;
            }
        }
        return null;
    }

    protected synchronized ServerRequest getFirst() {
        this.checkIsConfigured();
        if (!this.queue.isEmpty()) {
            return (ServerRequest)this.queue.getFirst();
        }
        return null;
    }

    protected boolean isEmpty() {
        this.checkIsConfigured();
        return this.queue.isEmpty();
    }

    protected synchronized ServerRequest removeFirst() {
        this.checkIsConfigured();
        if (!this.queue.isEmpty()) {
            ServerRequest serverRequest = (ServerRequest)this.queue.removeFirst();
            this.notifyAll();
            if (this.queueListener != null) {
                this.queueListener.requestRemovedFromQueue(serverRequest, this.queue.size());
            }
            return serverRequest;
        }
        return null;
    }

    protected synchronized ServerRequest removeLast() {
        this.checkIsConfigured();
        if (!this.queue.isEmpty()) {
            ServerRequest serverRequest = (ServerRequest)this.queue.removeLast();
            this.notifyAll();
            if (this.queueListener != null) {
                this.queueListener.requestRemovedFromQueue(serverRequest, this.queue.size());
            }
            return serverRequest;
        }
        return null;
    }

    protected synchronized void removeRequestQueueListener(RequestQueueListener requestQueueListener) {
        this.checkIsConfigured();
        this.queueListener = EventMulticaster.remove(this.queueListener, requestQueueListener);
    }

    protected int size() {
        return this.queue.size();
    }

    private void checkIsConfigured() {
        if (!this.configured) {
            throw new BAD_INV_ORDER("RequestQueue is not configured yet.");
        }
    }
}

