/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.syslogng.factory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.notify.bean.NotifyRelationInfo;
import com.clustercontrol.notify.ejb.session.NotifyControllerLocal;
import com.clustercontrol.notify.ejb.session.NotifyControllerUtil;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import com.clustercontrol.syslogng.bean.LogFilterInfo;
import com.clustercontrol.syslogng.ejb.entity.SyslogMonitorRuleLocal;
import com.clustercontrol.syslogng.ejb.entity.SyslogMonitorRuleUtil;
import com.clustercontrol.util.apllog.AplLogger;


/**
 * フィルタ情報を検索するクラス<BR>
 *
 * @version 3.0.0
 * @since 1.0.0
 */
public class SelectMonitorRule {
	
	/** ログ出力のインスタンス。 */
	protected static Log m_log = LogFactory.getLog( SelectMonitorRule.class );
	
	/**
	 * フィルタ情報一覧を返します。
	 * 
	 * @return フィルタ情報一覧 （{@link com.clustercontrol.syslogng.bean.LogFilterInfo}のリスト）
	 * @throws CreateException
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList<LogFilterInfo> getFilterInfoList() throws CreateException, FinderException, NamingException {
		
		ArrayList<LogFilterInfo> list = null;
		try 
		{
			// 監視条件を取得
			Collection ct = SyslogMonitorRuleUtil.getLocalHome().findAllByOrderNoOrder();
			RepositoryControllerLocal repository = RepositoryControllerUtil.getLocalHome().create();
			
			list = new ArrayList<LogFilterInfo>();
			Iterator itr = ct.iterator();
			while(itr.hasNext())
			{
				SyslogMonitorRuleLocal moniterRule = (SyslogMonitorRuleLocal)itr.next();
				
				//通知情報
				NotifyControllerLocal nc = NotifyControllerUtil.getLocalHome().create();
				Collection<NotifyRelationInfo> notifyId = nc.getNotifyRelation(moniterRule.getNotifyGroupId());
				
				
				LogFilterInfo filterInfo = new LogFilterInfo();
				
				filterInfo.setOrderNo((moniterRule.getOrderNo()).intValue());
				filterInfo.setDescription(moniterRule.getDescription());
				
				//スコープの取得
				String facilityPath = repository.getFacilityPath(moniterRule.getFacilityId(), null);
				
				filterInfo.setFacilityId(moniterRule.getFacilityId());
				filterInfo.setScope(facilityPath);
				filterInfo.setPattern(moniterRule.getPattern());
				filterInfo.setProcessType((moniterRule.getProcessType()).intValue());
				filterInfo.setPriority((moniterRule.getPriority()).intValue());
				filterInfo.setMonitorId(moniterRule.getMonitorId());
				filterInfo.setApplication(moniterRule.getApplication());
				filterInfo.setMessageId(moniterRule.getMessageId());
				filterInfo.setMessage(moniterRule.getMessage());
				filterInfo.setNotifyGroupId(moniterRule.getNotifyGroupId());
				filterInfo.setCalendarId(moniterRule.getCalendarId());
				filterInfo.setValid(moniterRule.getValidFlg());
//				filterInfo.setValidFlg(ValidConstant.typeToBoolean((moniterRule.getValidFlg()).intValue()));
				filterInfo.setNotifyId(notifyId);
				filterInfo.setRegDate(moniterRule.getRegDate());
				filterInfo.setUpdateDate(moniterRule.getUpdateDate());
				filterInfo.setRegUser(moniterRule.getRegUser());
				filterInfo.setUpdateUser(moniterRule.getUpdateUser());
				list.add(filterInfo);
			}
			
		} catch (CreateException e) {
            AplLogger apllog = new AplLogger("SLOGNG", "slogng");
            String[] args = null;
            apllog.put("SYS", "001", args);
			m_log.debug("getFilterInfoList():" + e.getMessage());
			throw e;
		} catch (FinderException e) {
            AplLogger apllog = new AplLogger("SLOGNG", "slogng");
            String[] args = null;
            apllog.put("SYS", "001", args);
			m_log.debug("getFilterInfoList():" + e.getMessage());
			throw e;
		} catch (NamingException e) {
            AplLogger apllog = new AplLogger("SLOGNG", "slogng");
            String[] args = null;
            apllog.put("SYS", "001", args);
			m_log.debug("getFilterInfoList():" + e.getMessage());
			throw e;
		}
		return list;
	}
}
