package com.clustercontrol.monitor.run.util;

import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * 監視を並列実行するクラス<BR>
 * <p>
 *
 * @version 2.4.0
 * @since 2.4.0
 */
public class ParallelExecution {
	
	private static int m_maxThreadPool = 50;
		
	public static ExecutorService m_executorService = Executors.newFixedThreadPool(m_maxThreadPool);
	
	private Properties m_props;
	
	//ロガー
	private static Log log = LogFactory.getLog(ParallelExecution.class);
	
	/**
	 * コンストラクタ
	 * @param props プロパティファイル情報
	 */
	public ParallelExecution(Properties props) {
		m_props = props;
		
		// プールするスレッドの最大数を取得
		String maxThreadPool = m_props.getProperty("monitor.common.thread.pool");
		if (maxThreadPool != null) {
			try {
				m_maxThreadPool = Integer.parseInt(maxThreadPool);
			} catch (NumberFormatException e) {
				log.error("monitor.common.thread.pool",e);
			}
		}
		
		m_executorService = Executors.newFixedThreadPool(m_maxThreadPool);
				
	}
	
	/**
	 * コンストラクタ
	 */
	public ParallelExecution() {
		
		m_executorService = Executors.newFixedThreadPool(m_maxThreadPool);
				
	}
	
}
