/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.monitor.bean;

import java.util.Date;

/**
 * 帳票出力用イベント情報を保持するクラス<BR>
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class ReportEventInfo implements java.io.Serializable{

	private static final long serialVersionUID = 1786971512225137242L;
	
	private String m_application;		// アプリケーション
	private String m_confirmFlg;		// 未確認/確認済
	private String m_facilityId;		// ファシリティID
	private Date m_generationDate;		// 出力日時
	private String m_message;			// メッセージ
	private String m_messageId;		// メッセージID
	private String m_messageOrg;		// オリジナルメッセージ
	private String m_monitorId;		// 監視項目ID
	private Date m_outputDate;			// 受信日時
	private String m_pluginId;			// プラグインID
	private String m_priority;			// 重要度
	private String m_scopeText;		// スコープ
	private String m_confirmUser;		// 確認ユーザ
	
	/**
	 * アプリケーションを返します。
	 *  
	 * @return アプリケーション
	 */
	public String getApplication() {
		return m_application;
	}
	/**
	 * アプリケーションを設定します。
	 * 
	 * @param application アプリケーション
	 */
	public void setApplication(String application) {
		this.m_application = application;
	}
	/**
	 * 確認フラグ（未／済）を返します。
	 *  
	 * @return 確認フラグ（未／済）
	 * @see com.clustercontrol.bean.ConfirmConstant
	 */
	public String getConfirmFlg() {
		return m_confirmFlg;
	}
	/**
	 * 確認フラグ（未／済）を設定します。
	 * 
	 * @param flg 確認フラグ（未／済）
	 * @see com.clustercontrol.bean.ConfirmConstant
	 */
	public void setConfirmFlg(String flg) {
		m_confirmFlg = flg;
	}
	/**
	 * ファシリティIDを返します。
	 * 
	 * @return ファシリティID
	 */
	public String getFacilityId() {
		return m_facilityId;
	}
	/**
	 * ファシリティIDを設定します。
	 * 
	 * @param id ファシリティID
	 */
	public void setFacilityId(String id) {
		m_facilityId = id;
	}
	/**
	 * 出力日時を返します。
	 * 
	 * @return 出力日時
	 */
	public Date getGenerationDate() {
		return m_generationDate;
	}
	/**
	 * 出力日時を設定します。
	 * 
	 * @param date 出力日時
	 */
	public void setGenerationDate(Date date) {
		m_generationDate = date;
	}
	/**
	 * メッセージを返します。
	 * 
	 * @return メッセージ
	 */
	public String getMessage() {
		return m_message;
	}
	/**
	 * メッセージを設定します。
	 * 
	 * @param message メッセージ
	 */
	public void setMessage(String message) {
		this.m_message = message;
	}
	/**
	 * オリジナルメッセージを返します。
	 * 
	 * @return オリジナルメッセージ
	 */
	public String getMessageOrg() {
		return m_messageOrg;
	}
	/**
	 * オリジナルメッセージを設定します。
	 * 
	 * @param org オリジナルメッセージ
	 */
	public void setMessageOrg(String org) {
		m_messageOrg = org;
	}
	/**
	 * 監視項目IDを返します。
	 * 
	 * @return 監視項目ID
	 */
	public String getMonitorId() {
		return m_monitorId;
	}
	/**
	 * 監視項目IDを設定します。
	 * 
	 * @param id 監視項目ID
	 */
	public void setMonitorId(String id) {
		m_monitorId = id;
	}
	/**
	 * 受信日時を返します。
	 * 
	 * @return 受信日時
	 */
	public Date getOutputDate() {
		return m_outputDate;
	}
	/**
	 * 受信日時を設定します。
	 * 
	 * @param date 受信日時
	 */
	public void setOutputDate(Date date) {
		m_outputDate = date;
	}
	/**
	 * プラグインIDを返します。
	 * 
	 * @return プラグインID
	 */
	public String getPluginId() {
		return m_pluginId;
	}
	/**
	 * プラグインIDを設定します。
	 * 
	 * @param id プラグインID
	 */
	public void setPluginId(String id) {
		m_pluginId = id;
	}
	/**
	 * 重要度を返します。
	 * 
	 * @return 重要度
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public String getPriority() {
		return m_priority;
	}
	/**
	 * 重要度を設定します。
	 * 
	 * @param priority 重要度
	 * @see com.clustercontrol.bean.PriorityConstant 
	 */
	public void setPriority(String priority) {
		this.m_priority = priority;
	}
	/**
	 * スコープを返します。
	 * 
	 * @return スコープ
	 */
	public String getScopeText() {
		return m_scopeText;
	}
	/**
	 * スコープを設定します。
	 * 
	 * @param text スコープ
	 */
	public void setScopeText(String text) {
		m_scopeText = text;
	}
	/**
	 * メッセージIDを返します。
	 * 
	 * @return メッセージID
	 */
	public String getMessageId() {
		return m_messageId;
	}
	/**
	 * メッセージIDを設定します。
	 * 
	 * @param id メッセージID
	 */
	public void setMessageId(String id) {
		m_messageId = id;
	}
	
	/**
	 * 確認ユーザを返します。
	 * @return 確認ユーザ
	 */
	public String getConfirmUser() {
		return m_confirmUser;
	}
	/**
	 * 確認ユーザを設定します。
	 * @param user 確認ユーザ
	 */
	public void setConfirmUser(String user) {
		m_confirmUser = user;
	}
}