/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.maintenance.bean;

import java.io.Serializable;
import java.util.Date;

import com.clustercontrol.bean.Schedule;

/**
 * 
 * ジョブのスケジュールに関する情報を格納するクラスです。
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ScheduleInfo implements Serializable {
	/** シリアライズ可能クラスに定義するUID */
	private static final long serialVersionUID = 2798625217156631572L;
	
	/** スケジュールID */
	protected String m_id;
	
	/** スケジュール名 */
	protected String m_name;
	
	/** ジョブID */
	protected String m_jobId;
	
	/** ジョブ名 */
	protected String m_jobName;
	
	/** スケジュール */
	protected Schedule m_schedule;
	
	/** カレンダID */
	protected String m_calendarId;
	
	/** 新規作成ユーザ */
	protected String m_createUser;
	
	/** 作成日時 */
	protected Date m_createTime;
	
	/** 最新更新ユーザ */
	protected String m_updateUser;
	
	/** 最新更新日時 */
	protected Date m_updateTime;
	
	/** 有効/無効 */
	protected int m_valid;
	
	/**
	 * スケジュールIDを返す
	 * @return スケジュールID
	 */
	public String getId() {
		return m_id;
	}
	
	/**
	 * スケジュールIDを設定する
	 * @param id スケジュールID
	 */
	public void setId(String id) {
		this.m_id = id;
	}
	
	/**
	 * ジョブIDを返す
	 * @return ジョブID
	 */
	public String getJobId() {
		return m_jobId;
	}
	
	/**
	 * ジョブIDを設定する
	 * @param jobId ジョブID
	 */
	public void setJobId(String jobId) {
		this.m_jobId = jobId;
	}
	
	/**
	 * ジョブ名を返す
	 * @return ジョブ名
	 */
	public String getJobName() {
		return m_jobName;
	}
	
	/**
	 * ジョブ名を設定する
	 * @param jobName ジョブ名
	 */
	public void setJobName(String jobName) {
		this.m_jobName = jobName;
	}
	
	/**
	 * スケジュール名を返す
	 * @return スケジュール名
	 */
	public String getName() {
		return m_name;
	}
	
	/**
	 * スケジュール名を設定する
	 * @param name スケジュール名
	 */
	public void setName(String name) {
		this.m_name = name;
	}
	
	/**
	 * 有効/無効を返す
	 * @return 有効/無効
	 */
	public int getValid() {
		return m_valid;
	}
	
	/**
	 * 有効/無効を設定する
	 * @param valid 有効/無効
	 */
	public void setValid(int valid) {
		this.m_valid = valid;
	}
	
	/**
	 * 作成日時を返す
	 * @return 作成日時
	 */
	public Date getCreateTime() {
		return m_createTime;
	}
	
	/**
	 * 作成日時を設定する
	 * @param createTime 作成日時
	 */
	public void setCreateTime(Date createTime) {
		this.m_createTime = createTime;
	}
	
	/**
	 * 最新更新日時を返す
	 * @return 最新更新日時
	 */
	public Date getUpdateTime() {
		return m_updateTime;
	}
	
	/**
	 * 最新更新日時を設定する
	 * @param updateTime 最新更新日時
	 */
	public void setUpdateTime(Date updateTime) {
		this.m_updateTime = updateTime;
	}
	
	/**
	 * スケジュールを返す
	 * @return スケジュール
	 */
	public Schedule getSchedule() {
		return m_schedule;
	}
	
	/**
	 * スケジュールを設定する
	 * @param schedule スケジュール
	 */
	public void setSchedule(Schedule schedule) {
		this.m_schedule = schedule;
	}
	
	/**
	 * カレンダIDを返す
	 * @return カレンダID
	 */
	public String getCalendarId() {
		return m_calendarId;
	}
	
	/**
	 * カレンダIDを設定する
	 * @param calendarId カレンダID
	 */
	public void setCalendarId(String calendarId) {
		this.m_calendarId = calendarId;
	}
	
	/**
	 * 新規作成ユーザを返す
	 * @return 新規作成ユーザ
	 */
	public String getCreateUser() {
		return m_createUser;
	}
	
	/**
	 * 新規作成ユーザを設定する
	 * @param createUser 新規作成ユーザ
	 */
	public void setCreateUser(String createUser) {
		this.m_createUser = createUser;
	}
	
	/**
	 * 最新更新ユーザを返す
	 * @return 最新更新ユーザ
	 */
	public String getUpdateUser() {
		return m_updateUser;
	}
	
	/**
	 * 最新更新ユーザを設定する
	 * @param updateUser 最新更新ユーザ
	 */
	public void setUpdateUser(String updateUser) {
		this.m_updateUser = updateUser;
	}
}