/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.logtransfer.ejb.entity;

import javax.ejb.EntityBean;

/**
 * ログ転送設定(ファイル情報)を管理するEntity Bean<BR>
 * 
 * @ejb.bean name="LogTransferFileInfo"
 *     jndi-name="LogTransferFileInfo"
 *     type="CMP"
 *     schema="LogTransferFileInfo"
 *     cmp-version="2.x"
 *     data-source="java:/HinemosDS"
 *     primkey-field="transferId","logFile"
 *       
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @ejb.permission
 *     unchecked="true"
 *           
 * @ejb.persistence 
 *     table-name="cc_log_transfer_file_info"
 *     
 * @ejb.finder 
 *     query="SELECT OBJECT(a) FROM LogTransferFileInfo as a"  
 *     signature="java.util.Collection findAll()"
 *     
 * @ejb.pk class="com.clustercontrol.logtransfer.ejb.entity.LogTransferFileInfoPK"
 *           
 */
public abstract class LogTransferFileInfoBean implements EntityBean {
	
	/**
	 *
	 * <!-- begin-user-doc -->
	 * The  ejbCreate method.
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.create-method 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public LogTransferFileInfoPK ejbCreate(
			String transferId,
			String filePath,
			Integer runInterval, 
			Integer existenceFlg,
			Integer validFlg
	) throws javax.ejb.CreateException {
		
		this.setTransferId(transferId);
		this.setFilePath(filePath);
		this.setRunInterval(runInterval);
		this.setExistenceFlg(existenceFlg);
		this.setValidFlg(validFlg);
		return null;
	}

	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="transfer_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * @return Returns the transferId.
	 */
	public abstract String getTransferId();
	
	/**
	 * @ejb.interface-method
	 * 
	 * @param transferId The transferId to set.
	 */
	public abstract void setTransferId(String transferId);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="file_path"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(1024)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *  
	 * @ejb.interface-method
	 * 
	 * @param Returns the filePath.
	 */
	public abstract String getFilePath();
	
	/**
	 * @ejb.interface-method
	 * 
	 * @param filePath The description to set.
	 */
	public abstract void setFilePath(String filePath);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="existence_flg"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @param Returns the existenceFlg.
	 */
	public abstract Integer getExistenceFlg();
	
	/**
	 * @ejb.interface-method
	 * 
	 * @param existenceFlg The existenceFlg to set.
	 */
	public abstract void setExistenceFlg(Integer existenceFlg);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="run_interval"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return statusFlg The statusFlg to set.
	 */
	public abstract Integer getRunInterval();
	
	/**
	 * @ejb.interface-method
	 * 
	 * @param runInterval The runInterval to set.
	 */
	public abstract void setRunInterval(Integer runInterval);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="valid_flg"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return Returns the validFlg.
	 */
	public abstract Integer getValidFlg();
	
	/**
	 * @ejb.interface-method
	 * 
	 * @param validFlg The validFlg to set.
	 */
	public abstract void setValidFlg(Integer validFlg);
	
	
	//	==========================================
	//	 CMR fields
	//	==========================================
	/**
	 * @ejb.interface-method view-type="local"
	 * 
	 * @ejb.relation 
	 * name="LogTransferInfo-LogTransferFileInfo"
	 * role-name="LogTransferFileInfo-LogTransferInfo(multi)"
	 * cascade-delete="yes"
	 * 
	 * @jboss.relation
	 * related-pk-field="transferId"
	 * fk-column="transfer_id"
	 * 
	 */
	public abstract LogTransferInfoLocal getLogTransferInfo();
	
	/**
	 * 
	 * @ejb.interface-method view-type="local"
	 */
	public abstract void setLogTransferInfo(LogTransferInfoLocal logTransferInfo);
}
